/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import ognl.ASTAnd;
import ognl.ASTConst;
import ognl.ASTCtor;
import ognl.ASTIn;
import ognl.ASTOr;
import ognl.ASTProperty;
import ognl.ASTSequence;
import ognl.ASTStaticField;
import ognl.ASTVarRef;
import ognl.DynamicSubscript;
import ognl.Node;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.OrderedReturn;
import ognl.enhance.UnsupportedCompilationException;

public class ASTChain
extends SimpleNode
implements NodeType,
OrderedReturn {
    private static final long serialVersionUID = 6689037266594707682L;
    private final boolean shortCircuit = Boolean.parseBoolean(System.getProperty("ognl.chain.short-circuit", "true"));
    private Class<?> getterClass;
    private Class<?> setterClass;
    private String lastExpression;
    private String coreExpression;

    public ASTChain(int id) {
        super(id);
    }

    public ASTChain(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public String getLastExpression() {
        return this.lastExpression;
    }

    @Override
    public String getCoreExpression() {
        return this.coreExpression;
    }

    @Override
    public void jjtClose() {
        this.flattenTree();
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source2) throws OgnlException {
        Object result = source2;
        if (this.shortCircuit && result == null && !(this.parent instanceof ASTIn)) {
            return null;
        }
        int ilast = this.children.length - 1;
        for (int i = 0; i <= ilast; ++i) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            if (this.shortCircuit && result == null && this.children[i] instanceof ASTProperty) {
                return null;
            }
            boolean handled = false;
            if (i < ilast && this.children[i] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this.children[i]).getIndexedPropertyType(context, result)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this.children[i + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this.children[i + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context, result);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context, result);
                        int len = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                result = Array.newInstance(array.getClass().getComponentType(), len);
                                System.arraycopy(array, 0, result, 0, len);
                                handled = true;
                                ++i;
                                break;
                            }
                            case 0: {
                                index = len > 0 ? 0 : -1;
                                break;
                            }
                            case 1: {
                                index = len > 0 ? len / 2 : -1;
                                break;
                            }
                            case 2: {
                                index = len > 0 ? len - 1 : -1;
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled) {
                    result = OgnlRuntime.getIndexedProperty(context, result, propertyNode.getProperty(context, result).toString(), index);
                    handled = true;
                    ++i;
                }
            }
            if (handled) continue;
            result = this.children[i].getValue(context, result);
        }
        return result;
    }

    @Override
    protected void setValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        boolean handled = false;
        int ilast = this.children.length - 2;
        for (int i = 0; i <= ilast; ++i) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            if (this.children[i] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this.children[i]).getIndexedPropertyType(context, target)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this.children[i + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this.children[i + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context, target);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context, target);
                        int len = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                System.arraycopy(target, 0, value, 0, len);
                                handled = true;
                                ++i;
                                break;
                            }
                            case 0: {
                                index = len > 0 ? 0 : -1;
                                break;
                            }
                            case 1: {
                                index = len > 0 ? len / 2 : -1;
                                break;
                            }
                            case 2: {
                                index = len > 0 ? len - 1 : -1;
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled && i == ilast) {
                    OgnlRuntime.setIndexedProperty(context, target, propertyNode.getProperty(context, target).toString(), index, value);
                    handled = true;
                    ++i;
                } else if (!handled) {
                    target = OgnlRuntime.getIndexedProperty(context, target, propertyNode.getProperty(context, target).toString(), index);
                    ++i;
                    continue;
                }
            }
            if (handled) continue;
            target = this.children[i].getValue(context, target);
        }
        if (!handled) {
            this.children[this.children.length - 1].setValue(context, target, value);
        }
    }

    @Override
    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        boolean result = false;
        if (this.children != null && this.children.length > 0) {
            result = true;
            for (int i = 0; result && i < this.children.length; ++i) {
                result = this.children[i] instanceof SimpleNode ? ((SimpleNode)this.children[i]).isSimpleProperty(context) : false;
            }
        }
        return result;
    }

    @Override
    public Class<?> getGetterClass() {
        return this.getterClass;
    }

    @Override
    public Class<?> getSetterClass() {
        return this.setterClass;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!(i <= 0 || this.children[i] instanceof ASTProperty && ((ASTProperty)this.children[i]).isIndexedAccess())) {
                    result.append(".");
                }
                result.append(this.children[i].toString());
            }
        }
        return result.toString();
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        String prevChain = (String)context.get("_currentChain");
        if (target != null) {
            context.setCurrentObject(target);
            context.setCurrentType(target.getClass());
        }
        String result = "";
        NodeType _lastType = null;
        boolean ordered = false;
        boolean constructor = false;
        try {
            if (this.children != null && this.children.length > 0) {
                for (Node child : this.children) {
                    String value = child.toGetSourceString(context, context.getCurrentObject());
                    if (child instanceof ASTCtor) {
                        constructor = true;
                    }
                    if (child instanceof NodeType && ((NodeType)((Object)child)).getGetterClass() != null) {
                        _lastType = (NodeType)((Object)child);
                    }
                    if (!(child instanceof ASTVarRef || constructor || child instanceof OrderedReturn && ((OrderedReturn)((Object)child)).getLastExpression() != null || this.parent instanceof ASTSequence)) {
                        value = OgnlRuntime.getCompiler().castExpression(context, child, value);
                    }
                    if (child instanceof OrderedReturn && ((OrderedReturn)((Object)child)).getLastExpression() != null) {
                        ordered = true;
                        OrderedReturn or = (OrderedReturn)((Object)child);
                        result = or.getCoreExpression() == null || or.getCoreExpression().trim().length() <= 0 ? "" : result + or.getCoreExpression();
                        this.lastExpression = or.getLastExpression();
                        if (context.get("_preCast") != null) {
                            this.lastExpression = context.remove("_preCast") + this.lastExpression;
                        }
                    } else if (child instanceof ASTOr || child instanceof ASTAnd || child instanceof ASTCtor || child instanceof ASTStaticField && this.parent == null) {
                        context.put("_noRoot", (Object)"true");
                        result = value;
                    } else {
                        result = result + value;
                    }
                    context.put("_currentChain", (Object)result);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        if (_lastType != null) {
            this.getterClass = _lastType.getGetterClass();
            this.setterClass = _lastType.getSetterClass();
        }
        if (ordered) {
            this.coreExpression = result;
        }
        context.put("_currentChain", (Object)prevChain);
        return result;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        String prevChain = (String)context.get("_currentChain");
        String prevChild = (String)context.get("_lastChild");
        if (prevChain != null) {
            throw new UnsupportedCompilationException("Can't compile nested chain expressions.");
        }
        if (target != null) {
            context.setCurrentObject(target);
            context.setCurrentType(target.getClass());
        }
        String result = "";
        NodeType _lastType = null;
        boolean constructor = false;
        try {
            if (this.children != null && this.children.length > 0) {
                if (this.children[0] instanceof ASTConst) {
                    throw new UnsupportedCompilationException("Can't modify constant values.");
                }
                for (int i = 0; i < this.children.length; ++i) {
                    if (i == this.children.length - 1) {
                        context.put("_lastChild", (Object)"true");
                    }
                    String value = this.children[i].toSetSourceString(context, context.getCurrentObject());
                    if (this.children[i] instanceof ASTCtor) {
                        constructor = true;
                    }
                    if (this.children[i] instanceof NodeType && ((NodeType)((Object)this.children[i])).getGetterClass() != null) {
                        _lastType = (NodeType)((Object)this.children[i]);
                    }
                    if (!(this.children[i] instanceof ASTVarRef || constructor || this.children[i] instanceof OrderedReturn && ((OrderedReturn)((Object)this.children[i])).getLastExpression() != null || this.parent instanceof ASTSequence)) {
                        value = OgnlRuntime.getCompiler().castExpression(context, this.children[i], value);
                    }
                    if (this.children[i] instanceof ASTOr || this.children[i] instanceof ASTAnd || this.children[i] instanceof ASTCtor || this.children[i] instanceof ASTStaticField) {
                        context.put("_noRoot", (Object)"true");
                        result = value;
                    } else {
                        result = result + value;
                    }
                    context.put("_currentChain", (Object)result);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        context.put("_lastChild", (Object)prevChild);
        context.put("_currentChain", (Object)prevChain);
        if (_lastType != null) {
            this.setterClass = _lastType.getSetterClass();
        }
        return result;
    }

    @Override
    public boolean isChain(OgnlContext context) {
        return true;
    }
}

