/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.function.BiConsumer;
import io.termd.core.function.Consumer;
import io.termd.core.readline.Completion;
import io.termd.core.readline.EventQueue;
import io.termd.core.readline.Function;
import io.termd.core.readline.FunctionEvent;
import io.termd.core.readline.KeyEvent;
import io.termd.core.readline.Keymap;
import io.termd.core.readline.LineBuffer;
import io.termd.core.readline.LineStatus;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.util.Helper;
import io.termd.core.util.Logging;
import io.termd.core.util.Vector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Readline {
    private static final int MAX_HISTORY_SIZE = 500;
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final EventQueue decoder;
    private Interaction interaction;
    private Vector size;
    private volatile List<int[]> history;
    private final Function ACCEPT_LINE = new Function(){

        @Override
        public String name() {
            return "accept-line";
        }

        @Override
        public void apply(Interaction interaction) {
            interaction.line.insert(interaction.buffer.toArray());
            LineStatus pb = new LineStatus();
            for (int i = 0; i < interaction.line.getSize(); ++i) {
                pb.accept(interaction.line.getAt(i));
            }
            interaction.buffer.clear();
            if (pb.isEscaping()) {
                interaction.line.delete(-1);
                interaction.currentPrompt = "> ";
                interaction.conn.write("\n> ");
                interaction.resume();
            } else if (pb.isQuoted()) {
                interaction.line.insert(10);
                interaction.conn.write("\n> ");
                interaction.currentPrompt = "> ";
                interaction.resume();
            } else {
                String raw = interaction.line.toString();
                if (interaction.line.getSize() > 0) {
                    this.addToHistory(interaction.line.toArray());
                }
                interaction.line.clear();
                interaction.conn.write("\n");
                interaction.end(raw);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToHistory(int[] command) {
            Class<Readline> clazz = Readline.class;
            synchronized (Readline.class) {
                ArrayList<int[]> tmp = new ArrayList<int[]>(Readline.this.history.size());
                tmp.add(command);
                for (int[] c : Readline.this.history) {
                    tmp.add(c);
                    if (tmp.size() < 500) continue;
                    break;
                }
                Readline.this.history = tmp;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    };

    public Readline(Keymap keymap) {
        this.decoder = new EventQueue(keymap);
        this.history = new ArrayList<int[]>();
        this.addFunction(this.ACCEPT_LINE);
    }

    public List<int[]> getHistory() {
        return this.history;
    }

    public void setHistory(List<int[]> history) {
        this.history = history;
    }

    public Vector size() {
        return this.size;
    }

    public Readline addFunction(Function function) {
        this.functions.put(function.name(), function);
        return this;
    }

    public Readline addFunctions(Iterable<Function> functions) {
        for (Function function : functions) {
            this.addFunction(function);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Interaction interaction;
        Readline readline = this;
        synchronized (readline) {
            interaction = this.interaction;
            if (interaction == null) {
                return false;
            }
        }
        return interaction.end(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver() {
        while (true) {
            Interaction handler;
            KeyEvent event;
            Readline readline = this;
            synchronized (readline) {
                if (!this.decoder.hasNext() || this.interaction == null || this.interaction.paused) {
                    return;
                }
                event = this.decoder.next();
                handler = this.interaction;
            }
            handler.handle(event);
        }
    }

    public void readline(TtyConnection conn, String prompt, Consumer<String> requestHandler) {
        this.readline(conn, prompt, requestHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readline(TtyConnection conn, String prompt, Consumer<String> requestHandler, Consumer<Completion> completionHandler) {
        Readline readline = this;
        synchronized (readline) {
            if (this.interaction != null) {
                throw new IllegalStateException("Already reading a line");
            }
            this.interaction = new Interaction(conn, prompt, requestHandler, completionHandler);
        }
        this.interaction.install();
        conn.write(prompt);
        this.schedulePendingEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulePendingEvent() {
        TtyConnection conn;
        Readline readline = this;
        synchronized (readline) {
            if (this.interaction == null) {
                throw new IllegalStateException("No interaction!");
            }
            if (!this.decoder.hasNext()) {
                return;
            }
            conn = this.interaction.conn;
        }
        conn.execute(new Runnable(){

            @Override
            public void run() {
                Readline.this.deliver();
            }
        });
    }

    public synchronized Readline queueEvent(int[] codePoints) {
        this.decoder.append(codePoints);
        return this;
    }

    public synchronized boolean hasEvent() {
        return this.decoder.hasNext();
    }

    public synchronized KeyEvent nextEvent() {
        return this.decoder.next();
    }

    public class Interaction {
        final TtyConnection conn;
        private Consumer<int[]> prevReadHandler;
        private Consumer<Vector> prevSizeHandler;
        private BiConsumer<TtyEvent, Integer> prevEventHandler;
        private final String prompt;
        private final Consumer<String> requestHandler;
        private final Consumer<Completion> completionHandler;
        private final Map<String, Object> data;
        private final LineBuffer line = new LineBuffer();
        private final LineBuffer buffer = new LineBuffer();
        private int historyIndex = -1;
        private String currentPrompt;
        private boolean paused;

        private Interaction(TtyConnection conn, String prompt, Consumer<String> requestHandler, Consumer<Completion> completionHandler) {
            this.conn = conn;
            this.prompt = prompt;
            this.data = new HashMap<String, Object>();
            this.currentPrompt = prompt;
            this.requestHandler = requestHandler;
            this.completionHandler = completionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean end(String s2) {
            Readline readline = Readline.this;
            synchronized (readline) {
                if (Readline.this.interaction == null) {
                    return false;
                }
                Readline.this.interaction = null;
                this.conn.setStdinHandler(this.prevReadHandler);
                this.conn.setSizeHandler(this.prevSizeHandler);
                this.conn.setEventHandler(this.prevEventHandler);
            }
            this.requestHandler.accept(s2);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle(KeyEvent event) {
            if (event.length() == 1) {
                if (event.getCodePointAt(0) == 4 && this.buffer.getSize() == 0) {
                    this.end(null);
                    return;
                }
                if (event.getCodePointAt(0) == 3) {
                    this.line.clear();
                    this.buffer.clear();
                    this.data.clear();
                    this.historyIndex = -1;
                    this.currentPrompt = this.prompt;
                    this.conn.stdoutHandler().accept(new int[]{10});
                    this.conn.write(((Readline)Readline.this).interaction.prompt);
                    return;
                }
                if (event.getCodePointAt(0) == 12) {
                    this.conn.write("\u001b[H\u001b[2J");
                    this.redraw();
                    return;
                }
            }
            if (event instanceof FunctionEvent) {
                FunctionEvent fname = (FunctionEvent)event;
                Function function = (Function)Readline.this.functions.get(fname.name());
                if (function != null) {
                    Interaction interaction = this;
                    synchronized (interaction) {
                        this.paused = true;
                    }
                    function.apply(this);
                } else {
                    Logging.READLINE.warn("Unimplemented function " + fname.name());
                }
            } else {
                LineBuffer buf = this.buffer.copy();
                for (int i = 0; i < event.length(); ++i) {
                    int codePoint = event.getCodePointAt(i);
                    try {
                        buf.insert(codePoint);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.conn.stdoutHandler().accept(new int[]{7});
                    }
                }
                this.refresh(buf);
            }
        }

        void resize(int oldWith, int newWidth) {
            LineBuffer abc = new LineBuffer(this.buffer.getCapacity());
            abc.insert(this.currentPrompt);
            abc.insert(this.buffer.toArray());
            abc.setCursor(this.currentPrompt.length() + this.buffer.getCursor());
            Vector pos = abc.getCursorPosition(newWidth);
            int curWidth = pos.x();
            int curHeight = pos.y();
            Vector end = abc.getPosition(abc.getSize(), oldWith);
            int endHeight = end.y() + end.x() / newWidth;
            Consumer<int[]> out = this.conn.stdoutHandler();
            out.accept(new int[]{13});
            while (curHeight != endHeight) {
                if (curHeight > endHeight) {
                    out.accept(new int[]{27, 91, 49, 65});
                    --curHeight;
                    continue;
                }
                out.accept(new int[]{10});
                ++curHeight;
            }
            while (curHeight > 0) {
                out.accept(new int[]{27, 91, 49, 75});
                out.accept(new int[]{27, 91, 49, 65});
                --curHeight;
            }
            out.accept(new int[]{27, 91, 49, 75});
            out.accept(Helper.toCodePoints(this.currentPrompt));
            this.refresh(new LineBuffer(), newWidth);
        }

        public Consumer<Completion> completionHandler() {
            return this.completionHandler;
        }

        public Map<String, Object> data() {
            return this.data;
        }

        public List<int[]> history() {
            return Readline.this.history;
        }

        public int getHistoryIndex() {
            return this.historyIndex;
        }

        public void setHistoryIndex(int historyIndex) {
            this.historyIndex = historyIndex;
        }

        public LineBuffer line() {
            return this.line;
        }

        public LineBuffer buffer() {
            return this.buffer;
        }

        public String currentPrompt() {
            return this.currentPrompt;
        }

        public Vector size() {
            return Readline.this.size;
        }

        public void redraw() {
            LineBuffer toto = new LineBuffer(this.buffer.getCapacity());
            toto.insert(Helper.toCodePoints(this.currentPrompt));
            toto.insert(this.buffer.toArray());
            toto.setCursor(this.currentPrompt.length() + this.buffer.getCursor());
            LineBuffer abc = new LineBuffer(toto.getCapacity());
            abc.update(toto, this.conn.stdoutHandler(), Readline.this.size.x());
        }

        public Interaction refresh(LineBuffer buffer) {
            this.refresh(buffer, Readline.this.size.x());
            return this;
        }

        private void refresh(LineBuffer update, int width) {
            LineBuffer copy3 = new LineBuffer(update.getCapacity());
            final LinkedList<Integer> codePoints = new LinkedList<Integer>();
            copy3.insert(Helper.toCodePoints(this.currentPrompt));
            copy3.insert(this.buffer().toArray());
            copy3.setCursor(this.currentPrompt.length() + this.buffer().getCursor());
            LineBuffer copy2 = new LineBuffer(copy3.getCapacity());
            copy2.insert(Helper.toCodePoints(this.currentPrompt));
            copy2.insert(update.toArray());
            copy2.setCursor(this.currentPrompt.length() + update.getCursor());
            copy3.update(copy2, new Consumer<int[]>(){

                @Override
                public void accept(int[] data) {
                    for (int cp : data) {
                        codePoints.add(cp);
                    }
                }
            }, width);
            this.conn.stdoutHandler().accept(Helper.convert(codePoints));
            this.buffer.clear();
            this.buffer.insert(update.toArray());
            this.buffer.setCursor(update.getCursor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Readline readline = Readline.this;
            synchronized (readline) {
                if (!this.paused) {
                    throw new IllegalStateException();
                }
                this.paused = false;
            }
            Readline.this.schedulePendingEvent();
        }

        private void install() {
            this.prevReadHandler = this.conn.getStdinHandler();
            this.prevSizeHandler = this.conn.getSizeHandler();
            this.prevEventHandler = this.conn.getEventHandler();
            this.conn.setStdinHandler(new Consumer<int[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int[] data) {
                    Readline readline = Readline.this;
                    synchronized (readline) {
                        Readline.this.decoder.append(data);
                    }
                    Readline.this.deliver();
                }
            });
            Readline.this.size = this.conn.size();
            this.conn.setSizeHandler(new Consumer<Vector>(){

                @Override
                public void accept(Vector dim) {
                    if (Readline.this.size != null) {
                        // empty if block
                    }
                    Readline.this.size = dim;
                }
            });
            this.conn.setEventHandler(null);
        }
    }
}

