/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.renderers;

import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.LineRenderer;
import com.taobao.text.Renderer;
import com.taobao.text.Style;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.Utils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ThreadRenderer
extends Renderer<Thread> {
    private static final EnumMap<Thread.State, Color> colorMapping = new EnumMap(Thread.State.class);
    private long sampleInterval;

    public ThreadRenderer() {
        this.sampleInterval = 100L;
    }

    public ThreadRenderer(long sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    @Override
    public Class<Thread> getType() {
        return Thread.class;
    }

    @Override
    public LineRenderer renderer(Iterator<Thread> stream) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        List<Thread> threads = Utils.list(stream);
        HashMap<Long, Long> times1 = new HashMap<Long, Long>();
        for (Thread thread2 : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread2.getId());
            times1.put(thread2.getId(), cpu);
        }
        try {
            Thread.sleep(this.sampleInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        HashMap<Long, Long> times2 = new HashMap<Long, Long>(threads.size());
        for (Thread thread3 : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread3.getId());
            times2.put(thread3.getId(), cpu);
        }
        long l = 0L;
        HashMap<Object, Long> deltas = new HashMap<Object, Long>(threads.size());
        for (Object id : times2.keySet()) {
            long time1 = (Long)times2.get(id);
            long time2 = (Long)times1.get(id);
            if (time1 == -1L) {
                time1 = time2;
            } else if (time2 == -1L) {
                time2 = time1;
            }
            long delta = time2 - time1;
            deltas.put(id, delta);
            l += delta;
        }
        final HashMap<Thread, Long> cpus = new HashMap<Thread, Long>(threads.size());
        for (Thread thread4 : threads) {
            long cpu = l == 0L ? 0L : (long)Math.round((Long)deltas.get(thread4.getId()) * 100L / l);
            cpus.put(thread4, cpu);
        }
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread o1, Thread o2) {
                long l2;
                long l1 = (Long)cpus.get(o1);
                if (l1 < (l2 = ((Long)cpus.get(o2)).longValue())) {
                    return 1;
                }
                if (l1 > l2) {
                    return -1;
                }
                return 0;
            }
        });
        TableElement table = new TableElement(1, 3, 2, 1, 1, 1, 1, 1, 1).overflow(Overflow.HIDDEN).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("ID", "NAME", "GROUP", "PRIORITY", "STATE", "%CPU", "TIME", "INTERRUPTED", "DAEMON"));
        for (Thread thread5 : threads) {
            Color c = colorMapping.get((Object)thread5.getState());
            long seconds = (Long)times2.get(thread5.getId()) / 1000000000L;
            long min2 = seconds / 60L;
            String time = min2 + ":" + seconds % 60L;
            long cpu = (Long)cpus.get(thread5);
            ThreadGroup group = thread5.getThreadGroup();
            LabelElement daemonLabel = new LabelElement(thread5.isDaemon());
            if (!thread5.isDaemon()) {
                daemonLabel.setStyle(Style.style(Color.magenta));
            }
            table.row(new LabelElement(thread5.getId()), new LabelElement(thread5.getName()), new LabelElement(group == null ? "" : group.getName()), new LabelElement(thread5.getPriority()), new LabelElement((Object)thread5.getState()).style(c.fg()), new LabelElement(cpu), new LabelElement(time), new LabelElement(thread5.isInterrupted()), daemonLabel);
        }
        return table.renderer();
    }

    static {
        colorMapping.put(Thread.State.NEW, Color.cyan);
        colorMapping.put(Thread.State.RUNNABLE, Color.green);
        colorMapping.put(Thread.State.BLOCKED, Color.red);
        colorMapping.put(Thread.State.WAITING, Color.yellow);
        colorMapping.put(Thread.State.TIMED_WAITING, Color.magenta);
        colorMapping.put(Thread.State.TERMINATED, Color.blue);
    }
}

