/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.command.internal;

import com.taobao.arthas.core.command.basic1000.GrepCommand;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.command.internal.StdoutHandler;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import java.util.List;
import java.util.regex.Pattern;

public class GrepHandler
extends StdoutHandler {
    public static final String NAME = "grep";
    private String keyword;
    private boolean ignoreCase;
    private final boolean invertMatch;
    private final Pattern pattern;
    private final boolean showLineNumber;
    private boolean trimEnd;
    private final Integer beforeLines;
    private final Integer afterLines;
    private final Integer maxCount;
    private static CLI cli = null;

    public static StdoutHandler inject(List<CliToken> tokens) {
        List<String> args2 = StdoutHandler.parseArgs(tokens, NAME);
        GrepCommand grepCommand = new GrepCommand();
        if (cli == null) {
            cli = CLIConfigurator.define(GrepCommand.class);
        }
        CommandLine commandLine = cli.parse(args2, true);
        try {
            CLIConfigurator.inject(commandLine, grepCommand);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        int context = grepCommand.getContext();
        int beforeLines = grepCommand.getBeforeLines();
        int afterLines = grepCommand.getAfterLines();
        if (context > 0) {
            if (beforeLines < 1) {
                beforeLines = context;
            }
            if (afterLines < 1) {
                afterLines = context;
            }
        }
        return new GrepHandler(grepCommand.getPattern(), grepCommand.isIgnoreCase(), grepCommand.isInvertMatch(), grepCommand.isRegEx(), grepCommand.isShowLineNumber(), grepCommand.isTrimEnd(), beforeLines, afterLines, grepCommand.getMaxCount());
    }

    GrepHandler(String keyword, boolean ignoreCase, boolean invertMatch, boolean regexpMode, boolean showLineNumber, boolean trimEnd, int beforeLines, int afterLines, int maxCount) {
        this.ignoreCase = ignoreCase;
        this.invertMatch = invertMatch;
        this.showLineNumber = showLineNumber;
        this.trimEnd = trimEnd;
        this.beforeLines = beforeLines > 0 ? beforeLines : 0;
        this.afterLines = afterLines > 0 ? afterLines : 0;
        this.maxCount = maxCount > 0 ? maxCount : 0;
        if (regexpMode) {
            int flags = ignoreCase ? 2 : 0;
            this.pattern = Pattern.compile(keyword, flags);
        } else {
            this.pattern = null;
        }
        this.keyword = ignoreCase ? keyword.toLowerCase() : keyword;
    }

    @Override
    public String apply(String input) {
        StringBuilder output = new StringBuilder();
        String[] lines = input.split("\n");
        int continueCount = 0;
        int lastStartPos = 0;
        int lastContinueLineNum = -1;
        int matchCount = 0;
        int lineNum = 0;
        while (lineNum < lines.length) {
            String line = null;
            line = this.trimEnd ? StringUtils.stripEnd(lines[lineNum], null) : lines[lineNum];
            ++lineNum;
            boolean match = this.pattern == null ? (this.ignoreCase ? line.toLowerCase() : line).contains(this.keyword) : this.pattern.matcher(line).find();
            if (this.invertMatch != match) {
                ++matchCount;
                if (this.beforeLines > continueCount) {
                    int n;
                    int n2 = lastContinueLineNum == -1 ? (this.beforeLines >= lineNum ? 1 : lineNum - this.beforeLines) : (n = lineNum - this.beforeLines - continueCount);
                    if (n >= lastContinueLineNum || lastContinueLineNum == -1) {
                        StringBuilder beforeSb = new StringBuilder();
                        for (int i = n; i < lineNum; ++i) {
                            this.appendLine(beforeSb, i, lines[i - 1]);
                        }
                        output.insert(lastStartPos, beforeSb);
                    }
                }
                lastStartPos = output.length();
                this.appendLine(output, lineNum, line);
                if (this.afterLines > continueCount) {
                    int last = lineNum + this.afterLines - continueCount;
                    if (last > lines.length) {
                        last = lines.length;
                    }
                    for (int i = lineNum; i < last; ++i) {
                        this.appendLine(output, i + 1, lines[i]);
                        ++lineNum;
                        ++continueCount;
                        lastStartPos = output.length();
                    }
                }
                ++continueCount;
                if (this.maxCount <= 0 || matchCount < this.maxCount) continue;
                break;
            }
            if (continueCount <= 0) continue;
            lastContinueLineNum = lineNum - 1;
            continueCount = 0;
        }
        String str = output.toString();
        return str;
    }

    protected void appendLine(StringBuilder output, int lineNum, String line) {
        if (this.showLineNumber) {
            output.append(lineNum).append(':');
        }
        output.append(line).append('\n');
    }
}

