/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathCompilerReflect;
import com.alibaba.fastjson2.JSONPathCompilerReflectASM;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.ExtraProcessor;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;

public final class JSONFactory {
    static volatile Throwable initErrorLast;
    public static final String CREATOR;
    public static final String PROPERTY_DENY_PROPERTY = "fastjson2.parser.deny";
    public static final String PROPERTY_AUTO_TYPE_ACCEPT = "fastjson2.autoTypeAccept";
    public static final String PROPERTY_AUTO_TYPE_HANDLER = "fastjson2.autoTypeHandler";
    public static final String PROPERTY_AUTO_TYPE_BEFORE_HANDLER = "fastjson2.autoTypeBeforeHandler";
    static boolean useJacksonAnnotation;
    static boolean useGsonAnnotation;
    static long defaultReaderFeatures;
    static String defaultReaderFormat;
    static ZoneId defaultReaderZoneId;
    static long defaultWriterFeatures;
    static String defaultWriterFormat;
    static ZoneId defaultWriterZoneId;
    static boolean defaultWriterAlphabetic;
    static final boolean disableReferenceDetect;
    static final boolean disableArrayMapping;
    static final boolean disableJSONB;
    static final boolean disableAutoType;
    static final boolean disableSmartMatch;
    static Supplier<Map> defaultObjectSupplier;
    static Supplier<List> defaultArraySupplier;
    static final NameCacheEntry[] NAME_CACHE;
    static final NameCacheEntry2[] NAME_CACHE2;
    static final Function<JSONWriter.Context, JSONWriter> INCUBATOR_VECTOR_WRITER_CREATOR_UTF8;
    static final Function<JSONWriter.Context, JSONWriter> INCUBATOR_VECTOR_WRITER_CREATOR_UTF16;
    static final JSONReaderUTF8Creator INCUBATOR_VECTOR_READER_CREATOR_ASCII;
    static final JSONReaderUTF8Creator INCUBATOR_VECTOR_READER_CREATOR_UTF8;
    static final JSONReaderUTF16Creator INCUBATOR_VECTOR_READER_CREATOR_UTF16;
    static int defaultDecimalMaxScale;
    static final char[] CA;
    static final int[] DIGITS2;
    static final float[] FLOAT_10_POW;
    static final double[] DOUBLE_10_POW;
    static final Double DOUBLE_ZERO;
    static final CacheItem[] CACHE_ITEMS;
    static final int CACHE_THRESHOLD = 0x400000;
    static final AtomicReferenceFieldUpdater<CacheItem, char[]> CHARS_UPDATER;
    static final AtomicReferenceFieldUpdater<CacheItem, byte[]> BYTES_UPDATER;
    static final Properties DEFAULT_PROPERTIES;
    static final ObjectWriterProvider defaultObjectWriterProvider;
    static final ObjectReaderProvider defaultObjectReaderProvider;
    static final JSONPathCompiler defaultJSONPathCompiler;
    static final ThreadLocal<ObjectReaderCreator> readerCreatorLocal;
    static final ThreadLocal<ObjectReaderProvider> readerProviderLocal;
    static final ThreadLocal<ObjectWriterCreator> writerCreatorLocal;
    static final ThreadLocal<JSONPathCompiler> jsonPathCompilerLocal;
    static final ObjectReader<JSONArray> ARRAY_READER;
    static final ObjectReader<JSONObject> OBJECT_READER;
    static final byte[] UUID_VALUES;

    public static String getProperty(String key) {
        return DEFAULT_PROPERTIES.getProperty(key);
    }

    private static boolean getPropertyBool(Properties properties, String name, boolean defaultValue) {
        boolean propertyValue = defaultValue;
        String property = System.getProperty(name);
        if (property != null) {
            if ((property = property.trim()).isEmpty() && (property = properties.getProperty(name)) != null) {
                property = property.trim();
            }
            if (defaultValue) {
                if ("false".equals(property)) {
                    propertyValue = false;
                }
            } else if ("true".equals(property)) {
                propertyValue = true;
            }
        }
        return propertyValue;
    }

    private static String getProperty(Properties properties, String name) {
        String property = System.getProperty(name);
        if (property != null && (property = property.trim()).isEmpty() && (property = properties.getProperty(name)) != null) {
            property = property.trim();
        }
        return property;
    }

    public static boolean isUseJacksonAnnotation() {
        return useJacksonAnnotation;
    }

    public static boolean isUseGsonAnnotation() {
        return useGsonAnnotation;
    }

    public static void setUseJacksonAnnotation(boolean useJacksonAnnotation) {
        JSONFactory.useJacksonAnnotation = useJacksonAnnotation;
    }

    public static void setDefaultObjectSupplier(Supplier<Map> objectSupplier) {
        defaultObjectSupplier = objectSupplier;
    }

    public static void setDefaultArraySupplier(Supplier<List> arraySupplier) {
        defaultArraySupplier = arraySupplier;
    }

    public static Supplier<Map> getDefaultObjectSupplier() {
        return defaultObjectSupplier;
    }

    public static Supplier<List> getDefaultArraySupplier() {
        return defaultArraySupplier;
    }

    public static JSONWriter.Context createWriteContext() {
        return new JSONWriter.Context(defaultObjectWriterProvider);
    }

    public static JSONWriter.Context createWriteContext(ObjectWriterProvider provider, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(provider);
        context.config(features);
        return context;
    }

    public static JSONWriter.Context createWriteContext(JSONWriter.Feature ... features) {
        return new JSONWriter.Context(defaultObjectWriterProvider, features);
    }

    public static JSONReader.Context createReadContext() {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider);
    }

    public static JSONReader.Context createReadContext(long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider, features);
    }

    public static JSONReader.Context createReadContext(JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider());
        for (int i = 0; i < features.length; ++i) {
            context.features |= features[i].mask;
        }
        return context;
    }

    public static JSONReader.Context createReadContext(Filter filter, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        if (filter instanceof JSONReader.AutoTypeBeforeHandler) {
            context.autoTypeBeforeHandler = (JSONReader.AutoTypeBeforeHandler)filter;
        }
        if (filter instanceof ExtraProcessor) {
            context.extraProcessor = (ExtraProcessor)filter;
        }
        for (int i = 0; i < features.length; ++i) {
            context.features |= features[i].mask;
        }
        return context;
    }

    public static JSONReader.Context createReadContext(ObjectReaderProvider provider, JSONReader.Feature ... features) {
        if (provider == null) {
            provider = JSONFactory.getDefaultObjectReaderProvider();
        }
        JSONReader.Context context = new JSONReader.Context(provider);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider, symbolTable);
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, symbolTable);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, Supplier<List> arraySupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.setArraySupplier(arraySupplier);
        context.config(features);
        return context;
    }

    public static ObjectReader getObjectReader(Type type, long features) {
        return JSONFactory.getDefaultObjectReaderProvider().getObjectReader(type, JSONReader.Feature.FieldBased.isEnabled(features));
    }

    public static ObjectWriter getObjectWriter(Type type, long features) {
        return JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(type, TypeUtils.getClass(type), JSONWriter.Feature.FieldBased.isEnabled(features));
    }

    public static ObjectWriterProvider getDefaultObjectWriterProvider() {
        return defaultObjectWriterProvider;
    }

    public static ObjectReaderProvider getDefaultObjectReaderProvider() {
        ObjectReaderProvider providerLocal = readerProviderLocal.get();
        if (providerLocal != null) {
            return providerLocal;
        }
        return defaultObjectReaderProvider;
    }

    public static JSONPathCompiler getDefaultJSONPathCompiler() {
        JSONPathCompiler compilerLocal = jsonPathCompilerLocal.get();
        if (compilerLocal != null) {
            return compilerLocal;
        }
        return defaultJSONPathCompiler;
    }

    public static void setContextReaderCreator(ObjectReaderCreator creator) {
        readerCreatorLocal.set(creator);
    }

    public static void setContextObjectReaderProvider(ObjectReaderProvider creator) {
        readerProviderLocal.set(creator);
    }

    public static ObjectReaderCreator getContextReaderCreator() {
        return readerCreatorLocal.get();
    }

    public static void setContextJSONPathCompiler(JSONPathCompiler compiler) {
        jsonPathCompilerLocal.set(compiler);
    }

    public static void setContextWriterCreator(ObjectWriterCreator creator) {
        writerCreatorLocal.set(creator);
    }

    public static ObjectWriterCreator getContextWriterCreator() {
        return writerCreatorLocal.get();
    }

    public static long getDefaultReaderFeatures() {
        return defaultReaderFeatures;
    }

    public static ZoneId getDefaultReaderZoneId() {
        return defaultReaderZoneId;
    }

    public static String getDefaultReaderFormat() {
        return defaultReaderFormat;
    }

    public static long getDefaultWriterFeatures() {
        return defaultWriterFeatures;
    }

    public static ZoneId getDefaultWriterZoneId() {
        return defaultWriterZoneId;
    }

    public static String getDefaultWriterFormat() {
        return defaultWriterFormat;
    }

    public static boolean isDefaultWriterAlphabetic() {
        return defaultWriterAlphabetic;
    }

    public static void setDefaultWriterAlphabetic(boolean defaultWriterAlphabetic) {
        JSONFactory.defaultWriterAlphabetic = defaultWriterAlphabetic;
    }

    public static boolean isDisableReferenceDetect() {
        return disableReferenceDetect;
    }

    public static boolean isDisableAutoType() {
        return disableAutoType;
    }

    public static boolean isDisableJSONB() {
        return disableJSONB;
    }

    public static boolean isDisableArrayMapping() {
        return disableArrayMapping;
    }

    public static void setDisableReferenceDetect(boolean disableReferenceDetect) {
        defaultObjectWriterProvider.setDisableReferenceDetect(disableReferenceDetect);
        defaultObjectReaderProvider.setDisableReferenceDetect(disableReferenceDetect);
    }

    public static void setDisableArrayMapping(boolean disableArrayMapping) {
        defaultObjectWriterProvider.setDisableArrayMapping(disableArrayMapping);
        defaultObjectReaderProvider.setDisableArrayMapping(disableArrayMapping);
    }

    public static void setDisableJSONB(boolean disableJSONB) {
        defaultObjectWriterProvider.setDisableJSONB(disableJSONB);
        defaultObjectReaderProvider.setDisableJSONB(disableJSONB);
    }

    public static void setDisableAutoType(boolean disableAutoType) {
        defaultObjectWriterProvider.setDisableAutoType(disableAutoType);
        defaultObjectReaderProvider.setDisableAutoType(disableAutoType);
    }

    public static boolean isDisableSmartMatch() {
        return disableSmartMatch;
    }

    public static void setDisableSmartMatch(boolean disableSmartMatch) {
        defaultObjectReaderProvider.setDisableSmartMatch(disableSmartMatch);
    }

    static {
        int c;
        NAME_CACHE = new NameCacheEntry[8192];
        NAME_CACHE2 = new NameCacheEntry2[8192];
        defaultDecimalMaxScale = 2048;
        CA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DIGITS2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        FLOAT_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        DOUBLE_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        DOUBLE_ZERO = 0.0;
        Properties properties = new Properties();
        InputStream inputStream2 = AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String resourceFile = "fastjson2.properties";
            if (cl != null) {
                return cl.getResourceAsStream("fastjson2.properties");
            }
            return ClassLoader.getSystemResourceAsStream("fastjson2.properties");
        });
        if (inputStream2 != null) {
            try {
                properties.load(inputStream2);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.close(inputStream2);
            }
        }
        DEFAULT_PROPERTIES = properties;
        String property = System.getProperty("fastjson2.creator");
        if (property != null) {
            property = property.trim();
        }
        if ((property == null || property.isEmpty()) && (property = properties.getProperty("fastjson2.creator")) != null) {
            property = property.trim();
        }
        CREATOR = property == null ? "asm" : property;
        boolean disableReferenceDetect0 = false;
        boolean disableArrayMapping0 = false;
        boolean disableJSONB0 = false;
        boolean disableAutoType0 = false;
        boolean disableSmartMatch0 = false;
        String features = System.getProperty("fastjson2.features");
        if (features == null) {
            features = JSONFactory.getProperty("fastjson2.features");
        }
        if (features != null) {
            String[] stringArray = features.split(",");
            int n = stringArray.length;
            block37: for (int i = 0; i < n; ++i) {
                String feature;
                switch (feature = stringArray[i]) {
                    case "disableReferenceDetect": {
                        disableReferenceDetect0 = true;
                        continue block37;
                    }
                    case "disableArrayMapping": {
                        disableArrayMapping0 = true;
                        continue block37;
                    }
                    case "disableJSONB": {
                        disableJSONB0 = true;
                        continue block37;
                    }
                    case "disableAutoType": {
                        disableAutoType0 = true;
                        continue block37;
                    }
                    case "disableSmartMatch": {
                        disableSmartMatch0 = true;
                        continue block37;
                    }
                }
            }
        }
        disableReferenceDetect = disableReferenceDetect0;
        disableArrayMapping = disableArrayMapping0;
        disableJSONB = disableJSONB0;
        disableAutoType = disableAutoType0;
        disableSmartMatch = disableSmartMatch0;
        useJacksonAnnotation = JSONFactory.getPropertyBool(properties, "fastjson2.useJacksonAnnotation", true);
        useGsonAnnotation = JSONFactory.getPropertyBool(properties, "fastjson2.useGsonAnnotation", true);
        defaultWriterAlphabetic = JSONFactory.getPropertyBool(properties, "fastjson2.writer.alphabetic", true);
        boolean readerVector = JSONFactory.getPropertyBool(properties, "fastjson2.readerVector", false);
        Function incubatorVectorCreatorUTF8 = null;
        Function incubatorVectorCreatorUTF16 = null;
        JSONReaderUTF8Creator readerCreatorASCII = null;
        JSONReaderUTF8Creator readerCreatorUTF8 = null;
        JSONReaderUTF16Creator readerCreatorUTF16 = null;
        if (JDKUtils.VECTOR_SUPPORT) {
            Class<?> factoryClass;
            if (JDKUtils.VECTOR_BIT_LENGTH >= 64) {
                try {
                    factoryClass = Class.forName("com.alibaba.fastjson2.JSONWriterUTF8Vector$Factory");
                    incubatorVectorCreatorUTF8 = (Function)factoryClass.newInstance();
                }
                catch (Throwable e) {
                    initErrorLast = e;
                }
                try {
                    factoryClass = Class.forName("com.alibaba.fastjson2.JSONWriterUTF16Vector$Factory");
                    incubatorVectorCreatorUTF16 = (Function)factoryClass.newInstance();
                }
                catch (Throwable e) {
                    initErrorLast = e;
                }
                if (readerVector) {
                    try {
                        factoryClass = Class.forName("com.alibaba.fastjson2.JSONReaderASCIIVector$Factory");
                        readerCreatorASCII = (JSONReaderUTF8Creator)factoryClass.newInstance();
                    }
                    catch (Throwable e) {
                        initErrorLast = e;
                    }
                    try {
                        factoryClass = Class.forName("com.alibaba.fastjson2.JSONReaderUTF8Vector$Factory");
                        readerCreatorUTF8 = (JSONReaderUTF8Creator)factoryClass.newInstance();
                    }
                    catch (Throwable e) {
                        initErrorLast = e;
                    }
                }
            }
            if (JDKUtils.VECTOR_BIT_LENGTH >= 128 && readerVector) {
                try {
                    factoryClass = Class.forName("com.alibaba.fastjson2.JSONReaderUTF16Vector$Factory");
                    readerCreatorUTF16 = (JSONReaderUTF16Creator)factoryClass.newInstance();
                }
                catch (Throwable e) {
                    initErrorLast = e;
                }
            }
        }
        INCUBATOR_VECTOR_WRITER_CREATOR_UTF8 = incubatorVectorCreatorUTF8;
        INCUBATOR_VECTOR_WRITER_CREATOR_UTF16 = incubatorVectorCreatorUTF16;
        INCUBATOR_VECTOR_READER_CREATOR_ASCII = readerCreatorASCII;
        INCUBATOR_VECTOR_READER_CREATOR_UTF8 = readerCreatorUTF8;
        INCUBATOR_VECTOR_READER_CREATOR_UTF16 = readerCreatorUTF16;
        CacheItem[] items = new CacheItem[16];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new CacheItem();
        }
        CACHE_ITEMS = items;
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, char[].class, "chars");
        BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, byte[].class, "bytes");
        defaultObjectWriterProvider = new ObjectWriterProvider();
        defaultObjectReaderProvider = new ObjectReaderProvider();
        JSONPathCompilerReflect compiler = null;
        switch (CREATOR) {
            case "reflect": 
            case "lambda": {
                compiler = JSONPathCompilerReflect.INSTANCE;
                break;
            }
            default: {
                try {
                    if (!JDKUtils.ANDROID && !JDKUtils.GRAAL) {
                        compiler = JSONPathCompilerReflectASM.INSTANCE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (compiler != null) break;
                compiler = JSONPathCompilerReflect.INSTANCE;
            }
        }
        defaultJSONPathCompiler = compiler;
        readerCreatorLocal = new ThreadLocal();
        readerProviderLocal = new ThreadLocal();
        writerCreatorLocal = new ThreadLocal();
        jsonPathCompilerLocal = new ThreadLocal();
        ARRAY_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONArray.class));
        OBJECT_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONObject.class));
        UUID_VALUES = new byte[55];
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 48);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 65 + 10);
        }
    }

    public static interface JSONPathCompiler {
        public JSONPath compile(Class var1, JSONPath var2);
    }

    static final class CacheItem {
        volatile char[] chars;
        volatile byte[] bytes;

        CacheItem() {
        }
    }

    static final class NameCacheEntry2 {
        final String name;
        final long value0;
        final long value1;

        public NameCacheEntry2(String name, long value0, long value1) {
            this.name = name;
            this.value0 = value0;
            this.value1 = value1;
        }
    }

    static final class NameCacheEntry {
        final String name;
        final long value;

        public NameCacheEntry(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }

    static interface JSONReaderUTF16Creator {
        public JSONReader create(JSONReader.Context var1, String var2, char[] var3, int var4, int var5);
    }

    static interface JSONReaderUTF8Creator {
        public JSONReader create(JSONReader.Context var1, String var2, byte[] var3, int var4, int var5);
    }
}

