/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

final class CSVReaderUTF8<T>
extends CSVReader<T> {
    static final Map<Long, Function<Consumer, ByteArrayValueConsumer>> valueConsumerCreators = new ConcurrentHashMap<Long, Function<Consumer, ByteArrayValueConsumer>>();
    byte[] buf;
    InputStream input;
    Charset charset = StandardCharsets.UTF_8;
    ByteArrayValueConsumer valueConsumer;

    CSVReaderUTF8(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Charset charset, Class<T> objectClass) {
        super(objectClass);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.charset = charset;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Charset charset, ByteArrayValueConsumer valueConsumer) {
        this.valueConsumer = valueConsumer;
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.charset = charset;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Type[] types) {
        super(types);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.types = types;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Class<T> objectClass) {
        super(objectClass);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVReaderUTF8(InputStream input, Charset charset, Type[] types) {
        super(types);
        this.charset = charset;
        this.input = input;
    }

    CSVReaderUTF8(InputStream input, Charset charset, Class<T> objectClass) {
        super(objectClass);
        this.charset = charset;
        this.input = input;
    }

    CSVReaderUTF8(InputStream input, Charset charset, ByteArrayValueConsumer valueConsumer) {
        this.charset = charset;
        this.input = input;
        this.valueConsumer = valueConsumer;
    }

    @Override
    protected boolean seekLine() throws IOException {
        byte[] buf = this.buf;
        int off = this.off;
        if (buf == null && this.input != null) {
            this.buf = new byte[524288];
            buf = this.buf;
            int cnt = this.input.read(buf);
            if (cnt == -1) {
                this.inputEnd = true;
                return false;
            }
            this.end = cnt;
            if (this.end > 3 && buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
                this.lineNextStart = off = 3;
            }
        }
        for (int k = 0; k < 3; ++k) {
            this.lineTerminated = false;
            for (int i = off; i < this.end; ++i) {
                int n;
                byte ch = buf[i];
                if (ch == 34) {
                    ++this.lineSize;
                    if (!this.quote) {
                        this.quote = true;
                        continue;
                    }
                    n = i + 1;
                    if (n >= this.end) break;
                    if (buf[n] == 34) {
                        ++this.lineSize;
                        ++i;
                        continue;
                    }
                    this.quote = false;
                    continue;
                }
                if (this.quote) {
                    ++this.lineSize;
                    continue;
                }
                if (ch == 10) {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = off = i + 1;
                    break;
                }
                if (ch == 13) {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    n = i + 1;
                    if (n >= this.end) break;
                    if (buf[n] == 10) {
                        ++i;
                    }
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = off = i + 1;
                    break;
                }
                ++this.lineSize;
            }
            if (!this.lineTerminated) {
                if (this.input != null && !this.inputEnd) {
                    int cnt;
                    int len = this.end - off;
                    if (off > 0) {
                        if (len > 0) {
                            System.arraycopy(buf, off, buf, 0, len);
                        }
                        this.lineNextStart = 0;
                        this.lineStart = 0;
                        off = 0;
                        this.end = len;
                        this.quote = false;
                    }
                    if ((cnt = this.input.read(buf, this.end, buf.length - this.end)) == -1) {
                        this.inputEnd = true;
                        if (off == this.end) {
                            this.off = off;
                            return false;
                        }
                    } else {
                        this.end += cnt;
                        continue;
                    }
                }
                this.lineStart = this.lineNextStart;
                this.lineEnd = this.end;
                ++this.rowCount;
                this.lineSize = 0;
                off = this.end;
            }
            this.lineTerminated = off == this.end;
            break;
        }
        this.off = off;
        return true;
    }

    Object readValue(byte[] bytes, int off, int len, Type type) {
        if (len == 0) {
            return null;
        }
        if (type == Integer.class) {
            return TypeUtils.parseInt(bytes, off, len);
        }
        if (type == Long.class) {
            return TypeUtils.parseLong(bytes, off, len);
        }
        if (type == BigDecimal.class) {
            return TypeUtils.parseBigDecimal(bytes, off, len);
        }
        if (type == Float.class) {
            return Float.valueOf(TypeUtils.parseFloat(bytes, off, len));
        }
        if (type == Double.class) {
            return TypeUtils.parseDouble(bytes, off, len);
        }
        if (type == Date.class) {
            long millis = DateUtils.parseMillis(bytes, off, len, this.charset, DateUtils.DEFAULT_ZONE_ID);
            return new Date(millis);
        }
        if (type == Boolean.class) {
            return TypeUtils.parseBoolean(bytes, off, len);
        }
        String str = new String(bytes, off, len, this.charset);
        return TypeUtils.cast((Object)str, type);
    }

    @Override
    public boolean isEnd() {
        return this.inputEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] readLineValues(boolean strings) {
        ArrayList<Object> valueList;
        Object[] values2;
        block61: {
            Object value;
            int columnIndex;
            block57: {
                Type type;
                byte c1;
                int valueSize;
                int valueStart;
                block62: {
                    try {
                        if (this.inputEnd) {
                            return null;
                        }
                        if (this.input == null && this.off >= this.end) {
                            return null;
                        }
                        boolean result = this.seekLine();
                        if (!result) {
                            return null;
                        }
                    }
                    catch (IOException e) {
                        throw new JSONException("seekLine error", e);
                    }
                    values2 = null;
                    valueList = null;
                    if (this.columns != null) {
                        values2 = strings ? new String[this.columns.size()] : new Object[this.columns.size()];
                    }
                    boolean quote = false;
                    valueStart = this.lineStart;
                    valueSize = 0;
                    int escapeCount = 0;
                    columnIndex = 0;
                    for (int i = this.lineStart; i < this.lineEnd; ++i) {
                        block59: {
                            Object value2;
                            block56: {
                                Type type2;
                                block60: {
                                    byte ch;
                                    block55: {
                                        block58: {
                                            ch = this.buf[i];
                                            if (!quote) break block58;
                                            if (ch == 34) {
                                                int n = i + 1;
                                                if (n < this.lineEnd) {
                                                    c1 = this.buf[n];
                                                    if (c1 == 34) {
                                                        valueSize += 2;
                                                        ++escapeCount;
                                                        ++i;
                                                        continue;
                                                    }
                                                    if (c1 == 44) {
                                                        ++i;
                                                        ch = c1;
                                                    }
                                                    break block55;
                                                } else if (n == this.lineEnd) {
                                                    break;
                                                }
                                                break block55;
                                            } else {
                                                ++valueSize;
                                                continue;
                                            }
                                        }
                                        if (ch == 34) {
                                            quote = true;
                                            continue;
                                        }
                                    }
                                    if (ch != 44) break block59;
                                    Type type3 = type2 = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                                    if (!quote) break block60;
                                    if (escapeCount == 0) {
                                        if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                            value2 = new String(this.buf, valueStart + 1, valueSize, this.charset);
                                            break block56;
                                        } else {
                                            try {
                                                value2 = this.readValue(this.buf, valueStart + 1, valueSize, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                        break block56;
                                    } else {
                                        byte[] bytes = new byte[valueSize - escapeCount];
                                        int valueEnd = valueStart + valueSize;
                                        int k = 0;
                                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                                            byte c = this.buf[j];
                                            bytes[k++] = c;
                                            if (c != 34 || this.buf[j + 1] != 34) continue;
                                            ++j;
                                        }
                                        if (type2 == null || type2 == String.class || type2 == Object.class) {
                                            value2 = new String(bytes, 0, bytes.length, this.charset);
                                            break block56;
                                        } else {
                                            try {
                                                value2 = this.readValue(bytes, 0, bytes.length, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                    }
                                    break block56;
                                }
                                if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                    byte c12;
                                    byte c0;
                                    value2 = valueSize == 1 && (c0 = this.buf[valueStart]) >= 0 ? TypeUtils.toString((char)c0) : (valueSize == 2 && (c0 = this.buf[valueStart]) >= 0 && (c12 = this.buf[valueStart + 1]) >= 0 ? TypeUtils.toString((char)c0, (char)c12) : new String(this.buf, valueStart, valueSize, this.charset));
                                } else {
                                    try {
                                        value2 = this.readValue(this.buf, valueStart, valueSize, type2);
                                    }
                                    catch (Exception e) {
                                        value2 = this.error(columnIndex, e);
                                    }
                                }
                            }
                            if (values2 != null) {
                                if (columnIndex < values2.length) {
                                    values2[columnIndex] = value2;
                                }
                            } else {
                                if (valueList == null) {
                                    valueList = new ArrayList();
                                }
                                valueList.add(value2);
                            }
                            quote = false;
                            valueStart = i + 1;
                            valueSize = 0;
                            escapeCount = 0;
                            ++columnIndex;
                            continue;
                        }
                        ++valueSize;
                    }
                    if (valueSize <= 0 && !quote) break block61;
                    Type type4 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                    if (!quote) break block62;
                    if (escapeCount == 0) {
                        if (type == null || type == String.class || type == Object.class || strings) {
                            value = new String(this.buf, valueStart + 1, valueSize, this.charset);
                            break block57;
                        } else {
                            try {
                                value = this.readValue(this.buf, valueStart + 1, valueSize, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                        break block57;
                    } else {
                        byte[] bytes = new byte[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            byte c = this.buf[j];
                            bytes[k++] = c;
                            if (c != 34 || this.buf[j + 1] != 34) continue;
                            ++j;
                        }
                        if (type == null || type == String.class || type == Object.class || strings) {
                            value = new String(bytes, 0, bytes.length, this.charset);
                            break block57;
                        } else {
                            try {
                                value = this.readValue(bytes, 0, bytes.length, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                    }
                    break block57;
                }
                if (type == null || type == String.class || type == Object.class || strings) {
                    byte c0;
                    value = valueSize == 1 && (c0 = this.buf[valueStart]) >= 0 ? TypeUtils.toString((char)c0) : (valueSize == 2 && (c0 = this.buf[valueStart]) >= 0 && (c1 = this.buf[valueStart + 1]) >= 0 ? TypeUtils.toString((char)c0, (char)c1) : new String(this.buf, valueStart, valueSize, this.charset));
                } else {
                    try {
                        value = this.readValue(this.buf, valueStart, valueSize, type);
                    }
                    catch (Exception e) {
                        value = this.error(columnIndex, e);
                    }
                }
            }
            if (values2 != null) {
                if (columnIndex < values2.length) {
                    values2[columnIndex] = value;
                }
            } else {
                if (valueList == null) {
                    valueList = new ArrayList<Object>();
                }
                valueList.add(value);
            }
        }
        if (values2 == null && valueList != null) {
            values2 = strings ? new String[valueList.size()] : new Object[valueList.size()];
            valueList.toArray(values2);
        }
        if (this.input == null && this.off == this.end) {
            this.inputEnd = true;
        }
        return values2;
    }

    @Override
    public void close() {
        if (this.input != null) {
            IOUtils.close(this.input);
        }
    }

    @Override
    public void statAll() {
        ByteArrayValueConsumer consumer = (row, column, bytes, off, len, charset) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len, charset);
        };
        this.readAll(consumer, Integer.MAX_VALUE);
    }

    @Override
    public void statAll(int maxRows) {
        ByteArrayValueConsumer consumer = (row, column, bytes, off, len, charset) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len, charset);
        };
        this.readAll(consumer, maxRows);
    }

    @Override
    public void readAll() {
        if (this.valueConsumer == null) {
            throw new JSONException("unsupported operation, consumer is null");
        }
        this.readAll(this.valueConsumer, Integer.MAX_VALUE);
    }

    @Override
    public void readAll(int maxRows) {
        if (this.valueConsumer == null) {
            throw new JSONException("unsupported operation, consumer is null");
        }
        this.readAll(this.valueConsumer, maxRows);
    }

    @Override
    public void readLineObjectAll(boolean readHeader, Consumer<T> consumer) {
        if (readHeader) {
            this.readHeader();
        }
        if (this.fieldReaders == null) {
            Object[] line;
            while ((line = this.readLineValues(false)) != null) {
                consumer.accept(line);
            }
            return;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        if (this.fieldReaders == null && this.objectClass != null) {
            ObjectReaderAdapter objectReader = (ObjectReaderAdapter)provider.getObjectReader(this.objectClass);
            this.fieldReaders = objectReader.getFieldReaders();
            this.objectCreator = provider.createObjectCreator(this.objectClass, this.features);
        }
        String[] strings = new String[this.fieldReaders.length + 1];
        strings[0] = this.objectClass.getName();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            strings[i + 1] = this.fieldReaders[i].fieldName;
        }
        long fullNameHash = Fnv.hashCode64(strings);
        Function<Consumer, ByteArrayValueConsumer> valueConsumerCreator = valueConsumerCreators.get(fullNameHash);
        if (valueConsumerCreator == null && (valueConsumerCreator = provider.createValueConsumerCreator(this.objectClass, this.fieldReaders)) != null) {
            valueConsumerCreators.putIfAbsent(fullNameHash, valueConsumerCreator);
        }
        ByteArrayValueConsumer bytesConsumer = null;
        if (valueConsumerCreator != null) {
            bytesConsumer = valueConsumerCreator.apply(consumer);
        }
        if (bytesConsumer == null) {
            bytesConsumer = new ByteArrayConsumerImpl(consumer);
        }
        this.readAll(bytesConsumer, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAll(ByteArrayValueConsumer consumer, int maxRows) {
        consumer.start();
        for (int r = 0; r < maxRows || maxRows < 0; ++r) {
            try {
                boolean result;
                if (this.inputEnd || this.input == null && this.off >= this.end || !(result = this.seekLine())) {
                    break;
                }
            }
            catch (IOException e) {
                throw new JSONException("seekLine error", e);
            }
            consumer.beforeRow(this.rowCount);
            boolean quote = false;
            int valueStart = this.lineStart;
            int valueSize = 0;
            int escapeCount = 0;
            int columnIndex = 0;
            for (int i = this.lineStart; i < this.lineEnd; ++i) {
                byte ch;
                block25: {
                    block28: {
                        ch = this.buf[i];
                        if (!quote) break block28;
                        if (ch == 34) {
                            int n = i + 1;
                            if (n < this.lineEnd) {
                                byte c1 = this.buf[n];
                                if (c1 == 34) {
                                    valueSize += 2;
                                    ++escapeCount;
                                    ++i;
                                    continue;
                                }
                                if (c1 == 44) {
                                    ++i;
                                    ch = c1;
                                }
                                break block25;
                            } else if (n == this.lineEnd) {
                                break;
                            }
                            break block25;
                        } else {
                            ++valueSize;
                            continue;
                        }
                    }
                    if (ch == 34) {
                        quote = true;
                        continue;
                    }
                }
                if (ch == 44) {
                    byte[] columnBuf = this.buf;
                    int columnStart = 0;
                    int columnSize = valueSize;
                    if (quote) {
                        if (escapeCount == 0) {
                            columnStart = valueStart + 1;
                        } else {
                            byte[] bytes = new byte[valueSize - escapeCount];
                            int valueEnd = valueStart + valueSize;
                            int k = 0;
                            for (int j = valueStart + 1; j < valueEnd; ++j) {
                                byte c = this.buf[j];
                                bytes[k++] = c;
                                if (c != 34 || this.buf[j + 1] != 34) continue;
                                ++j;
                            }
                            columnBuf = bytes;
                            columnSize = bytes.length;
                        }
                    } else {
                        columnStart = valueStart;
                    }
                    consumer.accept(this.rowCount, columnIndex, columnBuf, columnStart, columnSize, this.charset);
                    quote = false;
                    valueStart = i + 1;
                    valueSize = 0;
                    escapeCount = 0;
                    ++columnIndex;
                    continue;
                }
                ++valueSize;
            }
            if (valueSize > 0) {
                byte[] columnBuf = this.buf;
                int columnStart = 0;
                int columnSize = valueSize;
                if (quote) {
                    if (escapeCount == 0) {
                        columnStart = valueStart + 1;
                    } else {
                        byte[] bytes = new byte[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            byte c = this.buf[j];
                            bytes[k++] = c;
                            if (c != 34 || this.buf[j + 1] != 34) continue;
                            ++j;
                        }
                        columnBuf = bytes;
                        columnSize = bytes.length;
                    }
                } else {
                    columnStart = valueStart;
                }
                consumer.accept(this.rowCount, columnIndex, columnBuf, columnStart, columnSize, this.charset);
            }
            consumer.afterRow(this.rowCount);
        }
        consumer.end();
    }

    class ByteArrayConsumerImpl
    implements ByteArrayValueConsumer {
        protected Object object;
        final Consumer consumer;

        public ByteArrayConsumerImpl(Consumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public final void beforeRow(int row) {
            if (CSVReaderUTF8.this.objectCreator != null) {
                this.object = CSVReaderUTF8.this.objectCreator.get();
            }
        }

        @Override
        public void accept(int row, int column, byte[] bytes, int off, int len, Charset charset) {
            if (column >= CSVReaderUTF8.this.fieldReaders.length || len == 0) {
                return;
            }
            FieldReader fieldReader = CSVReaderUTF8.this.fieldReaders[column];
            Object fieldValue = CSVReaderUTF8.this.readValue(bytes, off, len, fieldReader.fieldType);
            fieldReader.accept(this.object, fieldValue);
        }

        @Override
        public final void afterRow(int row) {
            this.consumer.accept(this.object);
            this.object = null;
        }
    }
}

