/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONBDump;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterJSONB;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.internal.trove.map.hash.TLongIntHashMap;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.MultiType;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface JSONB {
    public static void dump(byte[] jsonbBytes) {
        System.out.println(JSONB.toJSONString(jsonbBytes, true));
    }

    public static void dump(byte[] jsonbBytes, SymbolTable symbolTable) {
        JSONBDump dump = new JSONBDump(jsonbBytes, symbolTable, true);
        String str = dump.toString();
        System.out.println(str);
    }

    public static byte[] toBytes(boolean v) {
        return new byte[]{v ? (byte)-79 : -80};
    }

    public static byte[] toBytes(int i) {
        if (i >= -16 && i <= 47) {
            return new byte[]{(byte)i};
        }
        try (JSONWriter jsonWriter = JSONWriter.ofJSONB();){
            jsonWriter.writeInt32(i);
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(byte i) {
        try (JSONWriter jsonWriter = JSONWriter.ofJSONB();){
            jsonWriter.writeInt8(i);
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(short i) {
        try (JSONWriter jsonWriter = JSONWriter.ofJSONB();){
            jsonWriter.writeInt16(i);
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(long i) {
        if (i >= -8L && i <= 15L) {
            return new byte[]{(byte)(-40L + (i - -8L))};
        }
        try (JSONWriter jsonWriter = JSONWriter.ofJSONB();){
            jsonWriter.writeInt64(i);
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    public static Object parse(byte[] jsonbBytes, JSONReader.Context context) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object = reader.readAnyObject();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
    }

    public static Object parse(byte[] jsonbBytes, JSONReader.Feature ... features) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), features), jsonbBytes, 0, jsonbBytes.length);){
            Object object = reader.readAnyObject();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
    }

    public static Object parse(InputStream in, JSONReader.Context context) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, in);){
            Object object = reader.readAny();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
    }

    public static Object parse(byte[] jsonbBytes, SymbolTable symbolTable, JSONReader.Feature ... features) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), symbolTable, features), jsonbBytes, 0, jsonbBytes.length);){
            Object object = reader.readAnyObject();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
    }

    public static JSONObject parseObject(byte[] jsonbBytes) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider()), jsonbBytes, 0, jsonbBytes.length);){
            JSONObject object = (JSONObject)reader.readObject();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] jsonbBytes, JSONReader.Feature ... features) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), features), jsonbBytes, 0, jsonbBytes.length);){
            JSONObject object = (JSONObject)reader.readObject();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream in, JSONReader.Context context) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, in);){
            JSONObject object = (JSONObject)reader.readObject();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONArray parseArray(byte[] jsonbBytes) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider()), jsonbBytes, 0, jsonbBytes.length);){
            JSONArray array = (JSONArray)reader.readArray();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(InputStream in, JSONReader.Context context) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, in);){
            JSONArray array = (JSONArray)reader.readArray();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(byte[] jsonbBytes, Type type) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider()), jsonbBytes, 0, jsonbBytes.length);){
            List list = (List)reader.read(paramType);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] jsonbBytes, Type type, JSONReader.Feature ... features) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), features), jsonbBytes, 0, jsonbBytes.length);){
            List list = (List)reader.read(paramType);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] jsonbBytes, Type ... types) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider()), jsonbBytes, 0, jsonbBytes.length);){
            List list = reader.readList(types);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] jsonbBytes, Type[] types, JSONReader.Feature ... features) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), features), jsonbBytes, 0, jsonbBytes.length);){
            List list = reader.readList(types);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(new JSONReader.Context(provider), jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            if (objectClass == Object.class) {
                object = jsonReader.readAny();
            } else {
                ObjectReader objectReader = provider.getObjectReader(objectClass, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
                object = objectReader.readJSONBObject(jsonReader, objectClass, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(objectType);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(new JSONReader.Context(provider), jsonbBytes, 0, jsonbBytes.length);){
            Object object = objectReader.readJSONBObject(jsonReader, objectType, null, 0L);
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type ... types) {
        return JSONB.parseObject(jsonbBytes, (Type)new MultiType(types));
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType, SymbolTable symbolTable) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(objectType);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(new JSONReader.Context(provider, symbolTable), jsonbBytes, 0, jsonbBytes.length);){
            Object object = objectReader.readJSONBObject(reader, objectType, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType, SymbolTable symbolTable, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, symbolTable, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectType, fieldBased);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object = objectReader.readJSONBObject(reader, objectType, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass, Filter filter, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, filter, features);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            for (int i = 0; i < features.length; ++i) {
                context.features |= features[i].mask;
            }
            if (objectClass == Object.class) {
                object = jsonReader.readAnyObject();
            } else {
                boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
                ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
                object = objectReader.readJSONBObject(jsonReader, objectClass, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType, SymbolTable symbolTable, Filter[] filters, JSONReader.Feature ... features) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, symbolTable, filters, features);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            for (int i = 0; i < features.length; ++i) {
                context.features |= features[i].mask;
            }
            if (objectType == Object.class) {
                object = jsonReader.readAnyObject();
            } else {
                boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
                ObjectReader objectReader = provider.getObjectReader(objectType, fieldBased);
                object = objectReader.readJSONBObject(jsonReader, objectType, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T copy(T object, JSONWriter.Feature ... features) {
        return JSON.copy(object, features);
    }

    public static <T> T parseObject(byte[] jsonbBytes, TypeReference typeReference, JSONReader.Feature ... features) {
        return JSONB.parseObject(jsonbBytes, typeReference.getType(), features);
    }

    public static <T> T parseObject(InputStream in, Class objectClass, JSONReader.Feature ... features) throws IOException {
        return JSONB.parseObject(in, objectClass, JSONFactory.createReadContext(features));
    }

    public static <T> T parseObject(InputStream in, Type objectType, JSONReader.Feature ... features) throws IOException {
        return JSONB.parseObject(in, objectType, JSONFactory.createReadContext(features));
    }

    public static <T> T parseObject(InputStream in, Type objectType, JSONReader.Context context) {
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, in);){
            Object object;
            if (objectType == Object.class) {
                object = jsonReader.readAny();
            } else {
                ObjectReader objectReader = context.getObjectReader(objectType);
                object = objectReader.readJSONBObject(jsonReader, objectType, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(InputStream in, Class objectClass, JSONReader.Context context) {
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, in);){
            Object object;
            if (objectClass == Object.class) {
                object = jsonReader.readAny();
            } else {
                ObjectReader objectReader = context.getObjectReader(objectClass);
                object = objectReader.readJSONBObject(jsonReader, objectClass, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObject(InputStream in, int length, Type objectType, JSONReader.Context context) throws IOException {
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(cacheItem, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        try {
            int read;
            if (bytes.length < length) {
                bytes = new byte[length];
            }
            if ((read = in.read(bytes, 0, length)) != length) {
                throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
            }
            T t = JSONB.parseObject(bytes, 0, length, objectType, context);
            return t;
        }
        finally {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObject(InputStream in, int length, Type objectType, JSONReader.Feature ... features) throws IOException {
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(cacheItem, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        try {
            int read;
            if (bytes.length < length) {
                bytes = new byte[length];
            }
            if ((read = in.read(bytes, 0, length)) != length) {
                throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
            }
            T t = JSONB.parseObject(bytes, 0, length, objectType, features);
            return t;
        }
        finally {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, bytes);
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            if (objectClass == Object.class) {
                object = jsonReader.readAnyObject();
            } else {
                boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
                ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
                object = (context.features & JSONReader.Feature.SupportArrayToBean.mask) != 0L && jsonReader.isArray() && objectReader instanceof ObjectReaderBean ? objectReader.readArrayMappingJSONBObject(jsonReader, objectClass, null, 0L) : objectReader.readJSONBObject(jsonReader, objectClass, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass, JSONReader.Context context) {
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            if (objectClass == Object.class) {
                object = jsonReader.readAnyObject();
            } else {
                ObjectReader objectReader = context.provider.getObjectReader(objectClass, (context.features & JSONReader.Feature.FieldBased.mask) != 0L);
                object = (context.features & JSONReader.Feature.SupportArrayToBean.mask) != 0L && jsonReader.isArray() && objectReader instanceof ObjectReaderBean ? objectReader.readArrayMappingJSONBObject(jsonReader, objectClass, null, 0L) : objectReader.readJSONBObject(jsonReader, objectClass, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectClass, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader(objectClass, (context.features & JSONReader.Feature.FieldBased.mask) != 0L);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type type) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectType, JSONReader.Context context) {
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(objectType, fieldBased);
            Object object = objectReader.readJSONBObject(reader, objectType, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectType, JSONReader.Feature ... features) {
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            ObjectReader objectReader = reader.getObjectReader(objectType);
            Object object = objectReader.readJSONBObject(reader, objectType, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass, SymbolTable symbolTable) {
        JSONReader.Context context = JSONFactory.createReadContext(symbolTable);
        ObjectReader objectReader = context.getObjectReader(objectClass);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectClass, SymbolTable symbolTable) {
        JSONReader.Context context = JSONFactory.createReadContext(symbolTable);
        ObjectReader objectReader = context.getObjectReader(objectClass);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass, SymbolTable symbolTable, JSONReader.Feature ... features) {
        JSONReader.Context context = JSONFactory.createReadContext(symbolTable, features);
        ObjectReader objectReader = context.getObjectReader(objectClass);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectClass, SymbolTable symbolTable, JSONReader.Feature ... features) {
        JSONReader.Context context = JSONFactory.createReadContext(symbolTable, features);
        ObjectReader objectReader = context.getObjectReader(objectClass);
        try (JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, off, len);){
            Object object = objectReader.readJSONBObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static byte[] toBytes(String str) {
        byte[] value;
        int strlen;
        int coder;
        if (str == null) {
            return new byte[]{-81};
        }
        if (JDKUtils.JVM_VERSION == 8) {
            char[] chars = JDKUtils.getCharArray(str);
            int strlen2 = chars.length;
            if (strlen2 <= 47) {
                boolean ascii = true;
                for (int i = 0; i < strlen2; ++i) {
                    if (chars[i] <= '\u007f') continue;
                    ascii = false;
                    break;
                }
                if (ascii) {
                    byte[] bytes = new byte[chars.length + 1];
                    bytes[0] = (byte)(strlen2 + 73);
                    for (int i = 0; i < strlen2; ++i) {
                        bytes[i + 1] = (byte)chars[i];
                    }
                    return bytes;
                }
            }
        } else if (JDKUtils.STRING_VALUE != null && (coder = JDKUtils.STRING_CODER.applyAsInt(str)) == 0 && (strlen = (value = JDKUtils.STRING_VALUE.apply(str)).length) <= 47) {
            byte[] bytes = new byte[value.length + 1];
            bytes[0] = (byte)(strlen + 73);
            System.arraycopy(value, 0, bytes, 1, value.length);
            return bytes;
        }
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider), null);){
            writer.writeString(str);
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(String str, Charset charset) {
        int type;
        if (str == null) {
            return new byte[]{-81};
        }
        if (charset == StandardCharsets.UTF_16) {
            type = 123;
        } else if (charset == StandardCharsets.UTF_16BE) {
            type = 125;
        } else if (charset == StandardCharsets.UTF_16LE) {
            type = 124;
        } else if (charset == StandardCharsets.UTF_8) {
            type = 122;
        } else if (charset == StandardCharsets.US_ASCII || charset == StandardCharsets.ISO_8859_1) {
            type = 121;
        } else if (charset != null && "GB18030".equals(charset.name())) {
            type = 126;
        } else {
            return JSONB.toBytes(str);
        }
        byte[] utf16 = str.getBytes(charset);
        int byteslen = 2 + utf16.length;
        byteslen = utf16.length <= 47 ? (byteslen += 0) : (utf16.length <= 2047 ? ++byteslen : (utf16.length <= 262143 ? (byteslen += 2) : (byteslen += 4)));
        byte[] bytes = new byte[byteslen];
        bytes[0] = type;
        int off = IO.writeInt32(bytes, 1, utf16.length);
        System.arraycopy(utf16, 0, bytes, off, utf16.length);
        return bytes;
    }

    public static byte[] toBytes(Object object) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider);
        try (JSONWriterJSONB writer = new JSONWriterJSONB(context, null);){
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.writeJSONB(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, JSONWriter.Context context) {
        if (context == null) {
            context = JSONFactory.createWriteContext();
        }
        try (JSONWriterJSONB writer = new JSONWriterJSONB(context, null);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((context.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, SymbolTable symbolTable) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider);
        try (JSONWriterJSONB writer = new JSONWriterJSONB(context, symbolTable);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.writeJSONB(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, SymbolTable symbolTable, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        try (JSONWriterJSONB writer = new JSONWriterJSONB(context, symbolTable);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((context.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, SymbolTable symbolTable, Filter[] filters, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        context.configFilter(filters);
        try (JSONWriterJSONB writer = new JSONWriterJSONB(context, symbolTable);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((context.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        try (JSONWriterJSONB writer = new JSONWriterJSONB(context, null);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((context.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static SymbolTable symbolTable(String ... names) {
        return new SymbolTable(names);
    }

    public static String toJSONString(byte[] jsonbBytes) {
        return new JSONBDump(jsonbBytes, false).toString();
    }

    public static String toJSONString(byte[] jsonbBytes, boolean raw) {
        return new JSONBDump(jsonbBytes, raw).toString();
    }

    public static String toJSONString(byte[] jsonbBytes, SymbolTable symbolTable) {
        return JSONB.toJSONString(jsonbBytes, symbolTable, false);
    }

    public static String toJSONString(byte[] jsonbBytes, SymbolTable symbolTable, boolean raw) {
        return new JSONBDump(jsonbBytes, symbolTable, raw).toString();
    }

    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider), null);
        try {
            writer.config(features);
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.writeJSONB(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            writer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JSONException("writeJSONString error", e);
            }
        }
    }

    public static byte[] fromJSONString(String str) {
        return JSONB.toBytes(JSON.parse(str));
    }

    public static byte[] fromJSONBytes(byte[] jsonUtf8Bytes) {
        JSONReader reader = JSONReader.of(jsonUtf8Bytes);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
        Object object = objectReader.readObject(reader, null, null, 0L);
        return JSONB.toBytes(object);
    }

    public static String typeName(byte type) {
        switch (type) {
            case -90: {
                return "OBJECT " + Integer.toString(type);
            }
            case -91: {
                return "OBJECT_END " + Integer.toString(type);
            }
            case -109: {
                return "REFERENCE " + Integer.toString(type);
            }
            case 127: {
                return "SYMBOL " + Integer.toString(type);
            }
            case -81: {
                return "NULL " + Integer.toString(type);
            }
            case -79: {
                return "TRUE " + Integer.toString(type);
            }
            case -80: {
                return "FALSE " + Integer.toString(type);
            }
            case 122: {
                return "STR_UTF8 " + Integer.toString(type);
            }
            case 123: {
                return "STR_UTF16 " + Integer.toString(type);
            }
            case 124: {
                return "STR_UTF16LE " + Integer.toString(type);
            }
            case 125: {
                return "STR_UTF16BE " + Integer.toString(type);
            }
            case -67: {
                return "INT8 " + Integer.toString(type);
            }
            case -68: {
                return "INT16 " + Integer.toString(type);
            }
            case 72: {
                return "INT32 " + Integer.toString(type);
            }
            case -66: 
            case -65: {
                return "INT64 " + Integer.toString(type);
            }
            case -74: 
            case -73: {
                return "FLOAT " + Integer.toString(type);
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: {
                return "DOUBLE " + Integer.toString(type);
            }
            case -70: 
            case -69: {
                return "BIGINT " + Integer.toString(type);
            }
            case -72: 
            case -71: {
                return "DECIMAL " + Integer.toString(type);
            }
            case -89: {
                return "LOCAL_TIME " + Integer.toString(type);
            }
            case -111: {
                return "BINARY " + Integer.toString(type);
            }
            case -88: {
                return "LOCAL_DATETIME " + Integer.toString(type);
            }
            case -82: {
                return "TIMESTAMP " + Integer.toString(type);
            }
            case -83: {
                return "TIMESTAMP_MINUTES " + Integer.toString(type);
            }
            case -84: {
                return "TIMESTAMP_SECONDS " + Integer.toString(type);
            }
            case -85: {
                return "TIMESTAMP_MILLIS " + Integer.toString(type);
            }
            case -86: {
                return "TIMESTAMP_WITH_TIMEZONE " + Integer.toString(type);
            }
            case -87: {
                return "LOCAL_DATE " + Integer.toString(type);
            }
            case -110: {
                return "TYPED_ANY " + Integer.toString(type);
            }
        }
        if (type >= -108 && type <= -92) {
            return "ARRAY " + Integer.toString(type);
        }
        if (type >= 73 && type <= 121) {
            return "STR_ASCII " + Integer.toString(type);
        }
        if (type >= -16 && type <= 47) {
            return "INT32 " + Integer.toString(type);
        }
        if (type >= 48 && type <= 63) {
            return "INT32 " + Integer.toString(type);
        }
        if (type >= 64 && type <= 71) {
            return "INT32 " + Integer.toString(type);
        }
        if (type >= -40 && type <= -17) {
            return "INT64 " + Integer.toString(type);
        }
        if (type >= -56 && type <= -41) {
            return "INT64 " + Integer.toString(type);
        }
        if (type >= -64 && type <= -57) {
            return "INT64 " + Integer.toString(type);
        }
        return Integer.toString(type);
    }

    public static boolean isInt32(int type) {
        return type >= -16 && type <= 72;
    }

    public static boolean isInt32Num(int type) {
        return type >= -16 && type <= 47;
    }

    public static boolean isInt32Byte(int type) {
        return (type & 0xF0) == 48;
    }

    public static boolean isInt32Short(int type) {
        return (type & 0xF8) == 64;
    }

    public static boolean isInt64Num(int type) {
        return type >= -40 && type <= -17;
    }

    public static boolean isInt64Byte(int type) {
        return (type - -56 & 0xF0) == 0;
    }

    public static boolean isInt64Short(int type) {
        return (type & 0xF8) == 192;
    }

    public static boolean isInt32ByteValue(int i) {
        return (i + 2048 & 0xFFFFF000) != 0;
    }

    public static boolean isInt32ByteValue1(int i) {
        return i >= -2048 && i <= 2047;
    }

    public static interface Constants {
        public static final byte BC_CHAR = -112;
        public static final byte BC_BINARY = -111;
        public static final byte BC_TYPED_ANY = -110;
        public static final byte BC_REFERENCE = -109;
        public static final int ARRAY_FIX_LEN = 15;
        public static final byte BC_ARRAY_FIX_0 = -108;
        public static final byte BC_ARRAY_FIX_MIN = -108;
        public static final byte BC_ARRAY_FIX_MAX = -93;
        public static final byte BC_ARRAY = -92;
        public static final byte BC_OBJECT_END = -91;
        public static final byte BC_OBJECT = -90;
        public static final byte BC_LOCAL_TIME = -89;
        public static final byte BC_LOCAL_DATETIME = -88;
        public static final byte BC_LOCAL_DATE = -87;
        public static final byte BC_TIMESTAMP_WITH_TIMEZONE = -86;
        public static final byte BC_TIMESTAMP_MILLIS = -85;
        public static final byte BC_TIMESTAMP_SECONDS = -84;
        public static final byte BC_TIMESTAMP_MINUTES = -83;
        public static final byte BC_TIMESTAMP = -82;
        public static final byte BC_NULL = -81;
        public static final byte BC_FALSE = -80;
        public static final byte BC_TRUE = -79;
        public static final byte BC_DOUBLE_NUM_0 = -78;
        public static final byte BC_DOUBLE_NUM_1 = -77;
        public static final byte BC_DOUBLE_LONG = -76;
        public static final byte BC_DOUBLE = -75;
        public static final byte BC_FLOAT_INT = -74;
        public static final byte BC_FLOAT = -73;
        public static final byte BC_DECIMAL_LONG = -72;
        public static final byte BC_DECIMAL = -71;
        public static final byte BC_BIGINT_LONG = -70;
        public static final byte BC_BIGINT = -69;
        public static final byte BC_INT16 = -68;
        public static final byte BC_INT8 = -67;
        public static final byte BC_INT64 = -66;
        public static final byte BC_INT64_INT = -65;
        public static final int INT64_SHORT_MIN = -262144;
        public static final int INT64_SHORT_MAX = 262143;
        public static final int INT64_BYTE_MIN = -2048;
        public static final int INT64_BYTE_MAX = 2047;
        public static final byte BC_INT64_SHORT_MIN = -64;
        public static final byte BC_INT64_SHORT_ZERO = -60;
        public static final byte BC_INT64_SHORT_MAX = -57;
        public static final byte BC_INT64_BYTE_MIN = -56;
        public static final byte BC_INT64_BYTE_ZERO = -48;
        public static final byte BC_INT64_BYTE_MAX = -41;
        public static final byte BC_INT64_NUM_MIN = -40;
        public static final byte BC_INT64_NUM_MAX = -17;
        public static final int INT64_NUM_LOW_VALUE = -8;
        public static final int INT64_NUM_HIGH_VALUE = 15;
        public static final byte BC_INT32_NUM_0 = 0;
        public static final byte BC_INT32_NUM_1 = 1;
        public static final byte BC_INT32_NUM_16 = 16;
        public static final byte BC_INT32_NUM_MIN = -16;
        public static final byte BC_INT32_NUM_MAX = 47;
        public static final byte BC_INT32_BYTE_MIN = 48;
        public static final byte BC_INT32_BYTE_ZERO = 56;
        public static final byte BC_INT32_BYTE_MAX = 63;
        public static final byte BC_INT32_SHORT_MIN = 64;
        public static final byte BC_INT32_SHORT_ZERO = 68;
        public static final byte BC_INT32_SHORT_MAX = 71;
        public static final byte BC_INT32 = 72;
        public static final int INT32_BYTE_MIN = -2048;
        public static final int INT32_BYTE_MAX = 2047;
        public static final int INT32_SHORT_MIN = -262144;
        public static final int INT32_SHORT_MAX = 262143;
        public static final byte BC_STR_ASCII_FIX_0 = 73;
        public static final byte BC_STR_ASCII_FIX_1 = 74;
        public static final byte BC_STR_ASCII_FIX_4 = 77;
        public static final byte BC_STR_ASCII_FIX_5 = 78;
        public static final byte BC_STR_ASCII_FIX_32 = 105;
        public static final byte BC_STR_ASCII_FIX_36 = 109;
        public static final int STR_ASCII_FIX_LEN = 47;
        public static final byte BC_STR_ASCII_FIX_MIN = 73;
        public static final byte BC_STR_ASCII_FIX_MAX = 120;
        public static final byte BC_STR_ASCII = 121;
        public static final byte BC_STR_UTF8 = 122;
        public static final byte BC_STR_UTF16 = 123;
        public static final byte BC_STR_UTF16LE = 124;
        public static final byte BC_STR_UTF16BE = 125;
        public static final byte BC_STR_GB18030 = 126;
        public static final byte BC_SYMBOL = 127;
    }

    public static interface IO {
        public static int enumCapacity(Enum e, long features) {
            if ((features & 0x6000L) != 0L) {
                return IO.stringCapacity((features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L ? e.toString() : e.name());
            }
            return 5;
        }

        public static int writeEnum(byte[] bytes, int off, Enum e, long features) {
            if ((features & 0x6000L) != 0L) {
                return IO.writeString(bytes, off, (features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L ? e.toString() : e.name());
            }
            return IO.writeInt32(bytes, off, e.ordinal());
        }

        public static int writeBoolean(byte[] bytes, int off, Boolean value) {
            bytes[off] = value == null ? -81 : (value != false ? -79 : -80);
            return off + 1;
        }

        public static int writeBoolean(byte[] bytes, int off, boolean value) {
            bytes[off] = value ? -79 : -80;
            return off + 1;
        }

        public static int writeBoolean(byte[] bytes, int off, boolean[] values2) {
            if (values2 == null) {
                bytes[off] = -81;
                return off + 1;
            }
            off = IO.startArray(bytes, off, values2.length);
            for (int i = 0; i < values2.length; ++i) {
                bytes[off + i] = values2[i] ? -79 : -80;
            }
            return off + values2.length;
        }

        public static int writeFloat(byte[] bytes, int off, Float value, long features) {
            float floatValue;
            if (value == null) {
                if ((features & 0x1000040L) == 0L) {
                    bytes[off] = -81;
                    return off + 1;
                }
                floatValue = 0.0f;
            } else {
                floatValue = value.floatValue();
            }
            return IO.writeFloat(bytes, off, floatValue);
        }

        public static int writeFloat(byte[] bytes, int off, float[] values2) {
            if (values2 == null) {
                bytes[off] = -81;
                return off + 1;
            }
            off = IO.startArray(bytes, off, values2.length);
            for (float value : values2) {
                off = IO.writeFloat(bytes, off, value);
            }
            return off;
        }

        public static int writeFloat(byte[] bytes, int off, float value) {
            int intValue = (int)value;
            if ((float)intValue == value && (intValue + 262144 & 0xFFF80000) == 0) {
                bytes[off] = -74;
                return IO.writeInt32(bytes, off + 1, intValue);
            }
            bytes[off] = -73;
            IOUtils.putIntBE(bytes, off + 1, Float.floatToIntBits(value));
            return off + 5;
        }

        public static int writeDouble(byte[] bytes, int off, Double value, long features) {
            if (value == null) {
                bytes[off] = (features & 0x1000040L) == 0L ? -81 : -78;
                bytes[off] = (features & 0x1000040L) == 0L ? -81 : -78;
                return off + 1;
            }
            return IO.writeDouble(bytes, off, value);
        }

        public static int writeDouble(byte[] bytes, int off, double value) {
            long longValue;
            if (value == 0.0 || value == 1.0) {
                bytes[off] = value == 0.0 ? -78 : -77;
                return off + 1;
            }
            if (value >= -2.147483648E9 && value <= 2.147483647E9 && (double)(longValue = (long)value) == value) {
                bytes[off] = -76;
                return IO.writeInt64(bytes, off + 1, longValue);
            }
            bytes[off] = -75;
            IOUtils.putLongBE(bytes, off + 1, Double.doubleToLongBits(value));
            return off + 9;
        }

        public static int writeDouble(byte[] bytes, int off, double[] values2) {
            if (values2 == null) {
                bytes[off] = -81;
                return off + 1;
            }
            off = IO.startArray(bytes, off, values2.length);
            for (double value : values2) {
                off = IO.writeDouble(bytes, off, value);
            }
            return off;
        }

        public static int writeInt8(byte[] bytes, int off, Byte val, long features) {
            if (val == null) {
                bytes[off] = (features & 0x1000040L) == 0L ? -81 : 0;
                return off + 1;
            }
            IOUtils.putShortLE(bytes, off, (short)(val << 8 | 0xBD));
            return off + 2;
        }

        public static int writeInt8(byte[] bytes, int off, byte val) {
            IOUtils.putShortLE(bytes, off, (short)(val << 8 | 0xBD));
            return off + 2;
        }

        public static int writeInt16(byte[] bytes, int off, Short val, long features) {
            if (val == null) {
                bytes[off] = (features & 0x1000040L) == 0L ? -81 : 0;
                return off + 1;
            }
            bytes[off] = -68;
            IOUtils.putShortBE(bytes, off + 1, val);
            return off + 3;
        }

        public static int writeInt16(byte[] bytes, int off, short val) {
            bytes[off] = -68;
            IOUtils.putShortBE(bytes, off + 1, val);
            return off + 3;
        }

        public static int writeInt32(byte[] bytes, int off, Integer value, long features) {
            if (value == null) {
                bytes[off] = (features & 0x1000040L) == 0L ? -81 : 0;
                return off + 1;
            }
            return IO.writeInt32(bytes, off, value);
        }

        public static int writeSymbol(byte[] bytes, int off, String str, SymbolTable symbolTable) {
            if (str == null) {
                bytes[off] = -81;
                return off + 1;
            }
            int ordinal = symbolTable.getOrdinal(str);
            if (ordinal >= 0) {
                bytes[off] = 121;
                return IO.writeInt32(bytes, off + 1, -ordinal);
            }
            return IO.writeString(bytes, off, str);
        }

        public static int writeSymbol(byte[] bytes, int off, int symbol) {
            bytes[off++] = 127;
            if (symbol >= -16 && symbol <= 47) {
                bytes[off++] = (byte)symbol;
            } else if (symbol >= -2048 && symbol <= 2047) {
                IOUtils.putShortBE(bytes, off, (short)(14336 + symbol));
                off += 2;
            } else {
                off = IO.writeInt32(bytes, off, symbol);
            }
            return off;
        }

        public static int checkAndWriteTypeName(byte[] bytes, int off, Object object, Class<?> fieldClass, JSONWriter jsonWriter) {
            Class<?> objectClass;
            long features = jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteClassName.mask) == 0L || object == null || (objectClass = object.getClass()) == fieldClass || (features & JSONWriter.Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class || objectClass == ArrayList.class) || (features & JSONWriter.Feature.NotWriteRootClassName.mask) != 0L && object == jsonWriter.rootObject) {
                return off;
            }
            return IO.writeTypeName(bytes, off, TypeUtils.getTypeName(objectClass), jsonWriter);
        }

        public static int writeTypeName(byte[] bytes, int off, String typeName, JSONWriter jsonWriter) {
            JSONWriterJSONB jsonWriterJSONB = (JSONWriterJSONB)jsonWriter;
            SymbolTable symbolTable = jsonWriter.symbolTable;
            bytes[off++] = -110;
            long hash = Fnv.hashCode64(typeName);
            int symbol = -1;
            if (symbolTable != null) {
                symbol = symbolTable.getOrdinalByHashCode(hash);
                if (symbol == -1 && jsonWriterJSONB.symbols != null) {
                    symbol = jsonWriterJSONB.symbols.get(hash);
                }
            } else if (jsonWriterJSONB.symbols != null) {
                symbol = jsonWriterJSONB.symbols.get(hash);
            }
            if (symbol == -1) {
                if (jsonWriterJSONB.symbols == null) {
                    jsonWriterJSONB.symbols = new TLongIntHashMap();
                }
            } else {
                return IO.writeInt32(bytes, off, symbol);
            }
            symbol = jsonWriterJSONB.symbolIndex++;
            jsonWriterJSONB.symbols.put(hash, symbol);
            off = IO.writeString(bytes, off, typeName);
            return IO.writeInt32(bytes, off, symbol);
        }

        public static int writeInt32(byte[] bytes, int off, int value) {
            if ((value + 16 & 0xFFFFFFC0) == 0) {
                bytes[off++] = (byte)value;
            } else if ((value + 2048 & 0xFFFFF000) == 0) {
                IOUtils.putShortBE(bytes, off, (short)(14336 + value));
                off += 2;
            } else if ((value + 262144 & 0xFFF80000) == 0) {
                bytes[off] = (byte)(68 + (value >> 16));
                IOUtils.putShortBE(bytes, off + 1, (short)value);
                off += 3;
            } else {
                bytes[off] = 72;
                IOUtils.putIntBE(bytes, off + 1, value);
                off += 5;
            }
            return off;
        }

        public static int writeInt64(byte[] bytes, int off, Collection<Long> values2, long features) {
            if (values2 == null) {
                bytes[off] = (features & JSONWriter.WRITE_ARRAY_NULL_MASK) != 0L ? -108 : -81;
                return off + 1;
            }
            int size = values2.size();
            off = IO.startArray(bytes, off, size);
            for (Long value : values2) {
                off = IO.writeInt64(bytes, off, value, features);
            }
            return off;
        }

        public static int writeInt64(byte[] bytes, int off, Long value, long features) {
            if (value == null) {
                bytes[off] = (features & 0x1000040L) == 0L ? -81 : -32;
                return off + 1;
            }
            return IO.writeInt64(bytes, off, value);
        }

        public static int writeInt64(byte[] bytes, int off, long value) {
            if (value >= -8L && value <= 15L) {
                bytes[off++] = (byte)(-40L + (value - -8L));
            } else if ((value + 2048L & 0xFFFFFFFFFFFFF000L) == 0L) {
                IOUtils.putShortBE(bytes, off, (short)(-12288L + value));
                off += 2;
            } else if ((value + 262144L & 0xFFFFFFFFFFF80000L) == 0L) {
                bytes[off] = (byte)(-60L + (value >> 16));
                IOUtils.putShortBE(bytes, off + 1, (short)value);
                off += 3;
            } else if ((value + 0x80000000L & 0xFFFFFFFF00000000L) == 0L) {
                bytes[off] = -65;
                IOUtils.putIntBE(bytes, off + 1, (int)value);
                off += 5;
            } else {
                bytes[off] = -66;
                IOUtils.putLongBE(bytes, off + 1, value);
                off += 9;
            }
            return off;
        }

        public static int startArray(byte[] bytes, int off, int size) {
            boolean tinyInt = size <= 15;
            int n = bytes[off++] = tinyInt ? (int)(-108 + size) : -92;
            if (!tinyInt) {
                off = IO.writeInt32(bytes, off, size);
            }
            return off;
        }

        public static int writeString(byte[] bytes, int off, Collection<String> strings, long features) {
            if (strings == null) {
                bytes[off] = (features & JSONWriter.WRITE_ARRAY_NULL_MASK) != 0L ? -108 : -81;
                return off + 1;
            }
            int size = strings.size();
            off = IO.startArray(bytes, off, size);
            for (String string : strings) {
                off = IO.writeString(bytes, off, string);
            }
            return off;
        }

        public static int writeString(byte[] bytes, int off, String[] strings, long features) {
            if (strings == null) {
                bytes[off] = (features & JSONWriter.WRITE_ARRAY_NULL_MASK) != 0L ? -108 : -81;
                return off + 1;
            }
            int size = strings.length;
            off = IO.startArray(bytes, off, size);
            for (String string : strings) {
                off = IO.writeString(bytes, off, string);
            }
            return off;
        }

        public static int writeString(byte[] bytes, int off, String str) {
            if (str == null) {
                bytes[off] = -81;
                return off + 1;
            }
            if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null) {
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                byte[] value = JDKUtils.STRING_VALUE.apply(str);
                if (coder == 0) {
                    return IO.writeStringLatin1(bytes, off, value);
                }
                return IO.writeStringUTF16(bytes, off, value);
            }
            return IO.writeString(bytes, off, JDKUtils.getCharArray(str));
        }

        public static int writeStringUTF16(byte[] bytes, int off, byte[] value) {
            int strlen = value.length;
            bytes[off] = JDKUtils.BIG_ENDIAN ? 125 : 124;
            off = IO.writeInt32(bytes, off + 1, strlen);
            System.arraycopy(value, 0, bytes, off, strlen);
            return off + strlen;
        }

        public static int writeStringLatin1(byte[] bytes, int off, byte[] value) {
            int strlen = value.length;
            if (strlen <= 47) {
                bytes[off++] = (byte)(strlen + 73);
            } else {
                off = strlen <= 2047 ? IO.putStringSizeSmall(bytes, off, strlen) : IO.putStringSizeLarge(bytes, off, strlen);
            }
            System.arraycopy(value, 0, bytes, off, value.length);
            return off + strlen;
        }

        public static int stringCapacity(Collection<String> strings) {
            if (strings == null) {
                return 1;
            }
            int size = IO.stringCapacity(strings.getClass().getName()) + 7;
            for (String string : strings) {
                size += IO.stringCapacity(string);
            }
            return size;
        }

        public static int stringCapacity(String[] strings) {
            if (strings == null) {
                return 1;
            }
            int size = 6;
            for (String string : strings) {
                size += IO.stringCapacity(string);
            }
            return size;
        }

        public static int int64Capacity(Collection<Long> values2) {
            if (values2 == null) {
                return 1;
            }
            return IO.stringCapacity(values2.getClass().getName()) + 7 + values2.size() * 9;
        }

        public static int stringCapacity(String str) {
            if (str == null) {
                return 0;
            }
            int strlen = str.length();
            if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null) {
                return (strlen << JDKUtils.STRING_CODER.applyAsInt(str)) + 6;
            }
            return strlen * 3 + 6;
        }

        public static int putStringSizeSmall(byte[] bytes, int off, int val) {
            bytes[off] = 121;
            IOUtils.putShortBE(bytes, off + 1, (short)(14336 + val));
            return off + 3;
        }

        public static int putStringSizeLarge(byte[] bytes, int off, int strlen) {
            if (strlen <= 262143) {
                IOUtils.putIntBE(bytes, off, 2034499584 + strlen);
                return off + 4;
            }
            IOUtils.putShortBE(bytes, off, (short)31048);
            IOUtils.putIntBE(bytes, off + 2, strlen);
            return off + 6;
        }

        public static int writeString(byte[] bytes, int off, char[] chars) {
            return IO.writeString(bytes, off, chars, 0, chars.length);
        }

        public static int writeString(byte[] bytes, int off, char[] chars, int coff, int strlen) {
            int start = off;
            boolean ascii = true;
            if (strlen < 47) {
                bytes[off++] = (byte)(strlen + 73);
                int end = coff + strlen;
                for (int i = coff; i < end; ++i) {
                    char ch = chars[i];
                    if (ch > '\u00ff') {
                        ascii = false;
                        break;
                    }
                    bytes[off++] = (byte)ch;
                }
                if (ascii) {
                    return off;
                }
                off = start;
            } else {
                ascii = IOUtils.isLatin1(chars, coff, strlen);
            }
            off = ascii ? IO.writeStringLatin1(bytes, off, chars, coff, strlen) : IO.writeUTF8(bytes, off, chars, coff, strlen);
            return off;
        }

        public static int writeStringLatin1(byte[] bytes, int off, char[] chars, int coff, int strlen) {
            if (strlen <= 47) {
                bytes[off++] = (byte)(strlen + 73);
            } else {
                bytes[off] = 121;
                if (strlen <= 2047) {
                    IOUtils.putShortBE(bytes, off + 1, (short)(14336 + strlen));
                    off += 3;
                } else {
                    off = IO.writeInt32(bytes, off + 1, strlen);
                }
            }
            for (int i = 0; i < strlen; ++i) {
                bytes[off++] = (byte)chars[coff + i];
            }
            return off;
        }

        public static int writeUTF8(byte[] bytes, int off, char[] chars, int coff, int strlen) {
            int result;
            int utf8len;
            int utf8lenByteCnt;
            int maxSize = strlen * 3;
            int lenByteCnt = IO.sizeOfInt(maxSize);
            if (lenByteCnt != (utf8lenByteCnt = IO.sizeOfInt(utf8len = (result = IOUtils.encodeUTF8(chars, coff, strlen, bytes, off + lenByteCnt + 1)) - off - lenByteCnt - 1))) {
                System.arraycopy(bytes, off + lenByteCnt + 1, bytes, off + utf8lenByteCnt + 1, utf8len);
            }
            bytes[off] = 122;
            return IO.writeInt32(bytes, off + 1, utf8len) + utf8len;
        }

        public static int sizeOfInt(int i) {
            if (i >= -16 && i <= 47) {
                return 1;
            }
            if (i >= -2048 && i <= 2047) {
                return 2;
            }
            if (i >= -262144 && i <= 262143) {
                return 3;
            }
            return 5;
        }

        public static int writeUUID(byte[] bytes, int off, UUID value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            IOUtils.putShortLE(bytes, off, (short)4241);
            IOUtils.putLongBE(bytes, off + 2, value.getMostSignificantBits());
            IOUtils.putLongBE(bytes, off + 10, value.getLeastSignificantBits());
            return off + 18;
        }

        public static int writeInstant(byte[] bytes, int off, Instant value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            bytes[off] = -82;
            off = IO.writeInt64(bytes, off + 1, value.getEpochSecond());
            return IO.writeInt32(bytes, off, value.getNano());
        }

        public static int writeLocalDate(byte[] bytes, int off, LocalDate value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            bytes[off] = -87;
            int year = value.getYear();
            IOUtils.putIntBE(bytes, off + 1, year << 16 | value.getMonthValue() << 8 | value.getDayOfMonth());
            return off + 5;
        }

        public static int writeLocalTime(byte[] bytes, int off, LocalTime value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            IOUtils.putIntBE(bytes, off, 0xA7000000 | value.getHour() << 16 | value.getMinute() << 8 | value.getSecond());
            return IO.writeInt32(bytes, off + 4, value.getNano());
        }

        public static int writeLocalDateTime(byte[] bytes, int off, LocalDateTime value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            IOUtils.putIntBE(bytes, off, 0xA8000000 | value.getYear() << 8 | value.getMonthValue());
            IOUtils.putIntBE(bytes, off + 4, value.getDayOfMonth() << 24 | value.getHour() << 16 | value.getMinute() << 8 | value.getSecond());
            return IO.writeInt32(bytes, off + 8, value.getNano());
        }

        public static int writeOffsetDateTime(byte[] bytes, int off, OffsetDateTime value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            IOUtils.putIntBE(bytes, off, 0xAA000000 | value.getYear() << 8 | value.getMonthValue());
            IOUtils.putIntBE(bytes, off + 4, value.getDayOfMonth() << 24 | value.getHour() << 16 | value.getMinute() << 8 | value.getSecond());
            off = IO.writeInt32(bytes, off + 8, value.getNano());
            String zoneIdStr = value.getOffset().getId();
            int strlen = zoneIdStr.length();
            bytes[off] = (byte)(strlen + 73);
            zoneIdStr.getBytes(0, strlen, bytes, off + 1);
            return off + strlen + 1;
        }

        public static int writeOffsetTime(byte[] bytes, int off, OffsetTime value) {
            if (value == null) {
                bytes[off] = -81;
                return off + 1;
            }
            int year = 1970;
            int month = 1;
            int dayOfMonth = 1;
            IOUtils.putIntBE(bytes, off, 0xAA000000 | year << 8 | month);
            IOUtils.putIntBE(bytes, off + 4, dayOfMonth << 24 | value.getHour() << 16 | value.getMinute() << 8 | value.getSecond());
            off = IO.writeInt32(bytes, off + 8, value.getNano());
            String zoneIdStr = value.getOffset().getId();
            int strlen = zoneIdStr.length();
            bytes[off] = (byte)(strlen + 73);
            zoneIdStr.getBytes(0, strlen, bytes, off + 1);
            return off + strlen + 1;
        }

        public static int writeReference(byte[] bytes, int off, String path, JSONWriter jsonWriter) {
            if (jsonWriter.lastReference == path) {
                path = "#-1";
            } else {
                jsonWriter.lastReference = path;
            }
            bytes[off] = -109;
            return IO.writeString(bytes, off + 1, path);
        }

        public static int writeNameRaw(byte[] bytes, int off, byte[] name, long nameHash, JSONWriter jsonWriter) {
            int symbol;
            SymbolTable symbolTable = jsonWriter.symbolTable;
            JSONWriterJSONB jsonWriterJSONB = (JSONWriterJSONB)jsonWriter;
            if (symbolTable == null || (symbol = symbolTable.getOrdinalByHashCode(nameHash)) == -1) {
                if ((jsonWriter.context.features & JSONWriter.Feature.WriteNameAsSymbol.mask) == 0L) {
                    System.arraycopy(name, 0, bytes, off, name.length);
                    return off + name.length;
                }
                boolean symbolExists = false;
                if (jsonWriterJSONB.symbols != null) {
                    symbol = jsonWriterJSONB.symbols.putIfAbsent(nameHash, jsonWriterJSONB.symbolIndex);
                    if (symbol != jsonWriterJSONB.symbolIndex) {
                        symbolExists = true;
                    } else {
                        ++jsonWriterJSONB.symbolIndex;
                    }
                } else {
                    jsonWriterJSONB.symbols = new TLongIntHashMap();
                    symbol = jsonWriterJSONB.symbolIndex++;
                    jsonWriterJSONB.symbols.put(nameHash, symbol);
                }
                if (!symbolExists) {
                    bytes[off++] = 127;
                    System.arraycopy(name, 0, bytes, off, name.length);
                    off += name.length;
                    if (symbol >= -16 && symbol <= 47) {
                        bytes[off++] = (byte)symbol;
                    } else {
                        off = IO.writeInt32(bytes, off, symbol);
                    }
                    return off;
                }
                symbol = -symbol;
            }
            bytes[off++] = 127;
            int intValue = -symbol;
            if (intValue >= -16 && intValue <= 47) {
                bytes[off++] = (byte)intValue;
            } else {
                off = IO.writeInt32(bytes, off, intValue);
            }
            return off;
        }
    }
}

