/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.management.web.factory;

import com.alibaba.arthas.nat.agent.management.web.discovery.NativeAgentProxyDiscovery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NativeAgentProxyDiscoveryFactory {
    private static final String FILE_PATH = "META-INF/arthas/com.alibaba.arthas.native.agent.management.web.NativeAgentProxyDiscoveryFactory";
    private static Map<String, NativeAgentProxyDiscovery> nativeAgentProxyDiscoveryMap = new ConcurrentHashMap<String, NativeAgentProxyDiscovery>();
    private static volatile NativeAgentProxyDiscoveryFactory nativeAgentProxyDiscoveryFactory;

    private NativeAgentProxyDiscoveryFactory() {
        Map<String, String> registrationConfigMap = this.readConfigInfo(FILE_PATH);
        this.loadNativeAgentDiscovery2Map(registrationConfigMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeAgentProxyDiscoveryFactory getNativeAgentProxyDiscoveryFactory() {
        if (nativeAgentProxyDiscoveryFactory != null) return nativeAgentProxyDiscoveryFactory;
        Class<NativeAgentProxyDiscoveryFactory> clazz = NativeAgentProxyDiscoveryFactory.class;
        synchronized (NativeAgentProxyDiscoveryFactory.class) {
            if (nativeAgentProxyDiscoveryFactory != null) return nativeAgentProxyDiscoveryFactory;
            nativeAgentProxyDiscoveryFactory = new NativeAgentProxyDiscoveryFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return nativeAgentProxyDiscoveryFactory;
        }
    }

    private void loadNativeAgentDiscovery2Map(Map<String, String> registrationConfigMap) {
        for (Map.Entry<String, String> entry : registrationConfigMap.entrySet()) {
            String name = entry.getKey();
            String classPath = entry.getValue();
            try {
                Class<?> clazz = Class.forName(classPath);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                NativeAgentProxyDiscovery instance = (NativeAgentProxyDiscovery)constructor.newInstance(new Object[0]);
                nativeAgentProxyDiscoveryMap.put(name, instance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, String> readConfigInfo(String filePath) {
        ConcurrentHashMap<String, String> nativeAgentDiscoveryConfigMap = new ConcurrentHashMap<String, String>();
        ClassLoader classLoader = NativeAgentProxyDiscoveryFactory.class.getClassLoader();
        try (InputStream inputStream2 = classLoader.getResourceAsStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
            String line;
            if (inputStream2 == null) {
                throw new IllegalArgumentException("File not found: " + filePath);
            }
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.trim().isEmpty() || !line.contains("=") || (parts = line.split("=", 2)).length != 2) continue;
                nativeAgentDiscoveryConfigMap.put(parts[0].trim(), parts[1].trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nativeAgentDiscoveryConfigMap;
    }

    public NativeAgentProxyDiscovery getNativeAgentProxyDiscovery(String name) {
        return nativeAgentProxyDiscoveryMap.get(name);
    }
}

