/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.management.web.discovery.impl;

import com.alibaba.arthas.nat.agent.management.web.discovery.NativeAgentProxyDiscovery;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.support.CloseableClient;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNativeAgentProxyDiscovery
implements NativeAgentProxyDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNativeAgentProxyDiscovery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listNativeAgentProxy(String address) {
        Client client = null;
        CloseableClient kvClient = null;
        ArrayList<String> res = null;
        try {
            client = Client.builder().endpoints("http://" + address).build();
            kvClient = client.getKVClient();
            GetResponse getResponse = null;
            try {
                ByteSequence prefix = ByteSequence.from("/native-agent-proxy", StandardCharsets.UTF_8);
                GetOption option = GetOption.newBuilder().isPrefix(Boolean.TRUE).build();
                getResponse = kvClient.get(prefix, option).get();
            }
            catch (Exception e) {
                logger.error("get value failed with prefix/native-agent-proxy");
                throw new RuntimeException(e);
            }
            List<KeyValue> kvs = getResponse.getKvs();
            if (kvs == null || kvs.size() == 0) {
                Iterator<KeyValue> iterator2 = null;
                return iterator2;
            }
            res = new ArrayList<String>(kvs.size());
            for (KeyValue kv : kvs) {
                String value = kv.getValue().toString(StandardCharsets.UTF_8);
                res.add(value);
            }
        }
        finally {
            if (kvClient != null) {
                kvClient.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return res;
    }
}

