/*
 * Decompiled with CFR 0.152.
 */
package arthas;

import arthas.VmToolMXBean;
import java.util.Map;

public class VmTool
implements VmToolMXBean {
    public static final String JNI_LIBRARY_NAME = "ArthasJniLibrary";
    private static VmTool instance;

    private VmTool() {
    }

    public static VmTool getInstance() {
        return VmTool.getInstance(null);
    }

    public static synchronized VmTool getInstance(String libPath) {
        if (instance != null) {
            return instance;
        }
        if (libPath == null) {
            System.loadLibrary(JNI_LIBRARY_NAME);
        } else {
            System.load(libPath);
        }
        instance = new VmTool();
        return instance;
    }

    private static synchronized native void forceGc0();

    private static synchronized native <T> T[] getInstances0(Class<T> var0, int var1);

    private static synchronized native long sumInstanceSize0(Class<?> var0);

    private static native long getInstanceSize0(Object var0);

    private static synchronized native long countInstances0(Class<?> var0);

    private static synchronized native Class<?>[] getAllLoadedClasses0(Class<?> var0);

    @Override
    public void forceGc() {
        VmTool.forceGc0();
    }

    @Override
    public void interruptSpecialThread(int threadId) {
        Map<Thread, StackTraceElement[]> allThread = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : allThread.entrySet()) {
            if (entry.getKey().getId() != (long)threadId) continue;
            entry.getKey().interrupt();
            return;
        }
    }

    @Override
    public <T> T[] getInstances(Class<T> klass) {
        return VmTool.getInstances0(klass, -1);
    }

    @Override
    public <T> T[] getInstances(Class<T> klass, int limit) {
        if (limit == 0) {
            throw new IllegalArgumentException("limit can not be 0");
        }
        return VmTool.getInstances0(klass, limit);
    }

    @Override
    public long sumInstanceSize(Class<?> klass) {
        return VmTool.sumInstanceSize0(klass);
    }

    @Override
    public long getInstanceSize(Object instance) {
        return VmTool.getInstanceSize0(instance);
    }

    @Override
    public long countInstances(Class<?> klass) {
        return VmTool.countInstances0(klass);
    }

    @Override
    public Class<?>[] getAllLoadedClasses() {
        return VmTool.getAllLoadedClasses0(Class.class);
    }

    @Override
    public int mallocTrim() {
        return VmTool.mallocTrim0();
    }

    private static synchronized native int mallocTrim0();

    @Override
    public boolean mallocStats() {
        return VmTool.mallocStats0();
    }

    private static synchronized native boolean mallocStats0();
}

