/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import com.taobao.arthas.mcp.server.util.Assert;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class JsonSchemaGenerator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final boolean PROPERTY_REQUIRED_BY_DEFAULT = true;

    private JsonSchemaGenerator() {
    }

    public static McpSchema.JsonSchema generateForMethodInput(Method method) {
        Parameter[] parameters;
        Assert.notNull(method, "method cannot be null");
        ObjectNode schema = OBJECT_MAPPER.createObjectNode();
        schema.put("type", "object");
        ObjectNode properties = schema.putObject("properties");
        ArrayList<String> required = new ArrayList<String>();
        for (Parameter parameter : parameters = method.getParameters()) {
            ToolParam toolParam = parameter.getAnnotation(ToolParam.class);
            if (toolParam == null) continue;
            String paramName = JsonSchemaGenerator.getParameterName(parameter);
            Class<?> paramType = parameter.getType();
            boolean isRequired = JsonSchemaGenerator.isParameterRequired(parameter);
            if (isRequired) {
                required.add(paramName);
            }
            ObjectNode paramProperties = JsonSchemaGenerator.generateParameterProperties(paramType);
            String description = JsonSchemaGenerator.getParameterDescription(parameter);
            if (description != null) {
                paramProperties.put("description", description);
            }
            properties.set(paramName, (JsonNode)paramProperties);
        }
        if (!required.isEmpty()) {
            ArrayNode requiredArray = schema.putArray("required");
            for (String req : required) {
                requiredArray.add(req);
            }
        }
        schema.put("additionalProperties", false);
        return new McpSchema.JsonSchema("object", JsonSchemaGenerator.convertToMap(properties), required, false);
    }

    private static String getParameterName(Parameter parameter) {
        JsonProperty jsonProperty = parameter.getAnnotation(JsonProperty.class);
        if (jsonProperty != null && !jsonProperty.value().isEmpty()) {
            return jsonProperty.value();
        }
        return parameter.getName();
    }

    private static ObjectNode generateParameterProperties(Class<?> paramType) {
        ObjectNode properties = OBJECT_MAPPER.createObjectNode();
        if (paramType == String.class) {
            properties.put("type", "string");
        } else if (paramType == Integer.TYPE || paramType == Integer.class || paramType == Long.TYPE || paramType == Long.class) {
            properties.put("type", "integer");
        } else if (paramType == Double.TYPE || paramType == Double.class || paramType == Float.TYPE || paramType == Float.class) {
            properties.put("type", "number");
        } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            properties.put("type", "boolean");
        } else if (paramType.isArray()) {
            properties.put("type", "array");
            ObjectNode items = properties.putObject("items");
            Class<?> componentType = paramType.getComponentType();
            if (componentType == String.class) {
                items.put("type", "string");
            } else if (componentType == Integer.TYPE || componentType == Integer.class || componentType == Long.TYPE || componentType == Long.class) {
                items.put("type", "integer");
            } else if (componentType == Double.TYPE || componentType == Double.class || componentType == Float.TYPE || componentType == Float.class) {
                items.put("type", "number");
            } else if (componentType == Boolean.TYPE || componentType == Boolean.class) {
                items.put("type", "boolean");
            } else {
                items.put("type", "object");
            }
        } else {
            properties.put("type", "object");
        }
        return properties;
    }

    private static boolean isParameterRequired(Parameter parameter) {
        ToolParam toolParam = parameter.getAnnotation(ToolParam.class);
        if (toolParam != null) {
            return toolParam.required();
        }
        JsonProperty jsonProperty = parameter.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.required();
        }
        return true;
    }

    private static String getParameterDescription(Parameter parameter) {
        ToolParam toolParam = parameter.getAnnotation(ToolParam.class);
        if (toolParam != null && toolParam.description() != null && !toolParam.description().isEmpty()) {
            return toolParam.description();
        }
        JsonPropertyDescription jsonPropertyDescription = parameter.getAnnotation(JsonPropertyDescription.class);
        if (jsonPropertyDescription != null && !jsonPropertyDescription.value().isEmpty()) {
            return jsonPropertyDescription.value();
        }
        return null;
    }

    private static Map<String, Object> convertToMap(ObjectNode node) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        node.fields().forEachRemaining(entry -> {
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                result.put((String)entry.getKey(), JsonSchemaGenerator.convertToMap((ObjectNode)value));
            } else if (value.isArray()) {
                ArrayList array = new ArrayList();
                value.elements().forEachRemaining(element -> {
                    if (element.isObject()) {
                        array.add(JsonSchemaGenerator.convertToMap((ObjectNode)element));
                    } else {
                        array.add(element.asText());
                    }
                });
                result.put((String)entry.getKey(), array);
            } else {
                result.put((String)entry.getKey(), value.asText());
            }
        });
        return result;
    }
}

