/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.session;

import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.session.ArthasCommandSessionManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArthasCommandContext {
    private static final Logger logger = LoggerFactory.getLogger(ArthasCommandContext.class);
    private static final long DEFAULT_SYNC_TIMEOUT = 30000L;
    private final CommandExecutor commandExecutor;
    private final ArthasCommandSessionManager.CommandSessionBinding binding;
    private volatile boolean executionComplete = false;
    private final List<Object> results = new CopyOnWriteArrayList<Object>();
    private final Lock resultLock = new ReentrantLock();

    public ArthasCommandContext(CommandExecutor commandExecutor) {
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor cannot be null");
        this.binding = null;
    }

    public ArthasCommandContext(CommandExecutor commandExecutor, ArthasCommandSessionManager.CommandSessionBinding binding) {
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor cannot be null");
        this.binding = binding;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public String getSessionId() {
        return this.binding != null ? this.binding.getArthasSessionId() : null;
    }

    public String getArthasSessionId() {
        this.requireSessionSupport();
        return this.binding.getArthasSessionId();
    }

    private void requireSessionSupport() {
        if (this.binding == null) {
            throw new IllegalStateException("Session-based operations are not supported in temporary mode. Use ArthasCommandContext(CommandExecutor, CommandSessionBinding) constructor to enable session support.");
        }
    }

    public String getConsumerId() {
        return this.binding != null ? this.binding.getConsumerId() : null;
    }

    public ArthasCommandSessionManager.CommandSessionBinding getBinding() {
        return this.binding;
    }

    public boolean isExecutionComplete() {
        return this.executionComplete;
    }

    public void setExecutionComplete(boolean executionComplete) {
        this.executionComplete = executionComplete;
    }

    public void addResult(Object result) {
        this.results.add(result);
    }

    public List<Object> getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results.clear();
    }

    public Lock getResultLock() {
        return this.resultLock;
    }

    public Map<String, Object> executeSync(String commandLine) {
        return this.executeSync(commandLine, 30000L);
    }

    public Map<String, Object> executeSync(String commandLine, long timeout) {
        return this.commandExecutor.executeSync(commandLine, timeout);
    }

    public Map<String, Object> executeSync(String commandStr, Object authSubject) {
        return this.commandExecutor.executeSync(commandStr, 30000L, null, authSubject, null);
    }

    public Map<String, Object> executeSync(String commandStr, Object authSubject, String userId) {
        return this.commandExecutor.executeSync(commandStr, 30000L, null, authSubject, userId);
    }

    public Map<String, Object> executeAsync(String commandLine) {
        this.requireSessionSupport();
        return this.commandExecutor.executeAsync(commandLine, this.binding.getArthasSessionId());
    }

    public Map<String, Object> pullResults() {
        this.requireSessionSupport();
        return this.commandExecutor.pullResults(this.binding.getArthasSessionId(), this.binding.getConsumerId());
    }

    public Map<String, Object> interruptJob() {
        this.requireSessionSupport();
        return this.commandExecutor.interruptJob(this.binding.getArthasSessionId());
    }

    public void setSessionUserId(String userId) {
        if (this.binding != null && userId != null) {
            this.commandExecutor.setSessionUserId(this.binding.getArthasSessionId(), userId);
            logger.debug("Set userId for session {}: {}", (Object)this.binding.getArthasSessionId(), (Object)userId);
        }
    }
}

