/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.spec;

import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import java.time.Instant;
import java.util.stream.Stream;

public interface EventStore {
    public String storeEvent(String var1, McpSchema.JSONRPCMessage var2);

    public Stream<StoredEvent> getEventsForSession(String var1, String var2);

    public void cleanupOldEvents(String var1, long var2);

    public void removeSessionEvents(String var1);

    public static class StoredEvent {
        private final String eventId;
        private final String sessionId;
        private final McpSchema.JSONRPCMessage message;
        private final Instant timestamp;

        public StoredEvent(String eventId, String sessionId, McpSchema.JSONRPCMessage message, Instant timestamp) {
            this.eventId = eventId;
            this.sessionId = sessionId;
            this.message = message;
            this.timestamp = timestamp;
        }

        public String getEventId() {
            return this.eventId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public McpSchema.JSONRPCMessage getMessage() {
            return this.message;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }
    }
}

