/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.spec;

import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.protocol.server.McpInitRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpNotificationHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.store.InMemoryEventStore;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.protocol.spec.McpStreamableServerSession;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class DefaultMcpStreamableServerSessionFactory
implements McpStreamableServerSession.Factory {
    private final Duration requestTimeout;
    private final McpInitRequestHandler mcpInitRequestHandler;
    private final Map<String, McpRequestHandler<?>> requestHandlers;
    private final Map<String, McpNotificationHandler> notificationHandlers;
    private final CommandExecutor commandExecutor;

    public DefaultMcpStreamableServerSessionFactory(Duration requestTimeout, McpInitRequestHandler mcpInitRequestHandler, Map<String, McpRequestHandler<?>> requestHandlers, Map<String, McpNotificationHandler> notificationHandlers, CommandExecutor commandExecutor) {
        this.requestTimeout = requestTimeout;
        this.mcpInitRequestHandler = mcpInitRequestHandler;
        this.requestHandlers = requestHandlers;
        this.notificationHandlers = notificationHandlers;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public McpStreamableServerSession.McpStreamableServerSessionInit startSession(McpSchema.InitializeRequest initializeRequest) {
        McpStreamableServerSession session = new McpStreamableServerSession(UUID.randomUUID().toString(), initializeRequest.getCapabilities(), initializeRequest.getClientInfo(), this.requestTimeout, this.requestHandlers, this.notificationHandlers, this.commandExecutor, new InMemoryEventStore());
        CompletableFuture<McpSchema.InitializeResult> initResult = this.mcpInitRequestHandler.handle(initializeRequest);
        return new McpStreamableServerSession.McpStreamableServerSessionInit(session, initResult);
    }
}

