/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server.store;

import com.taobao.arthas.mcp.server.protocol.spec.EventStore;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryEventStore
implements EventStore {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryEventStore.class);
    private final AtomicLong globalEventIdCounter = new AtomicLong(0L);
    private final Map<String, List<EventStore.StoredEvent>> sessionEvents = new ConcurrentHashMap<String, List<EventStore.StoredEvent>>();
    private final Map<String, String> eventIdToSession = new ConcurrentHashMap<String, String>();
    private final int maxEventsPerSession;
    private final long defaultRetentionMs;

    public InMemoryEventStore() {
        this(1000, 86400000L);
    }

    public InMemoryEventStore(int maxEventsPerSession, long defaultRetentionMs) {
        this.maxEventsPerSession = maxEventsPerSession;
        this.defaultRetentionMs = defaultRetentionMs;
    }

    @Override
    public String storeEvent(String sessionId, McpSchema.JSONRPCMessage message) {
        String eventId = String.valueOf(this.globalEventIdCounter.incrementAndGet());
        Instant timestamp = Instant.now();
        EventStore.StoredEvent event = new EventStore.StoredEvent(eventId, sessionId, message, timestamp);
        this.sessionEvents.computeIfAbsent(sessionId, k -> new ArrayList()).add(event);
        this.eventIdToSession.put(eventId, sessionId);
        List<EventStore.StoredEvent> events = this.sessionEvents.get(sessionId);
        if (events.size() > this.maxEventsPerSession) {
            int toRemove = events.size() - this.maxEventsPerSession;
            for (int i = 0; i < toRemove; ++i) {
                EventStore.StoredEvent removedEvent = events.remove(0);
                this.eventIdToSession.remove(removedEvent.getEventId());
            }
            logger.debug("Cleaned up {} old events for session {}", (Object)toRemove, (Object)sessionId);
        }
        logger.trace("Stored event {} for session {}", (Object)eventId, (Object)sessionId);
        return eventId;
    }

    @Override
    public Stream<EventStore.StoredEvent> getEventsForSession(String sessionId, String fromEventId) {
        List<EventStore.StoredEvent> events = this.sessionEvents.get(sessionId);
        if (events == null || events.isEmpty()) {
            return Stream.empty();
        }
        if (fromEventId == null) {
            return Stream.empty();
        }
        boolean foundStartEvent = false;
        ArrayList<EventStore.StoredEvent> result = new ArrayList<EventStore.StoredEvent>();
        for (EventStore.StoredEvent event : events) {
            if (!foundStartEvent) {
                if (!event.getEventId().equals(fromEventId)) continue;
                foundStartEvent = true;
                result.add(event);
                events.remove(event);
                this.eventIdToSession.remove(event.getEventId());
                continue;
            }
            result.add(event);
        }
        return result.stream();
    }

    @Override
    public void cleanupOldEvents(String sessionId, long maxAge) {
        List<EventStore.StoredEvent> events = this.sessionEvents.get(sessionId);
        if (events == null || events.isEmpty()) {
            return;
        }
        Instant cutoff = Instant.now().minusMillis(maxAge);
        List toRemove = events.stream().filter(event -> event.getTimestamp().isBefore(cutoff)).collect(Collectors.toList());
        for (EventStore.StoredEvent event2 : toRemove) {
            events.remove(event2);
            this.eventIdToSession.remove(event2.getEventId());
        }
        if (!toRemove.isEmpty()) {
            logger.debug("Cleaned up {} old events for session {}", (Object)toRemove.size(), (Object)sessionId);
        }
    }

    @Override
    public void removeSessionEvents(String sessionId) {
        List<EventStore.StoredEvent> events = this.sessionEvents.remove(sessionId);
        if (events != null) {
            for (EventStore.StoredEvent event : events) {
                this.eventIdToSession.remove(event.getEventId());
            }
            logger.debug("Removed {} events for session {}", (Object)events.size(), (Object)sessionId);
        }
    }

    public void cleanupExpiredEvents() {
        for (String sessionId : this.sessionEvents.keySet()) {
            this.cleanupOldEvents(sessionId, this.defaultRetentionMs);
        }
    }
}

