/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server;

import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessNotificationHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessServerHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContext;
import com.taobao.arthas.mcp.server.protocol.spec.McpError;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.session.ArthasCommandContext;
import com.taobao.arthas.mcp.server.session.ArthasCommandSessionManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMcpStatelessServerHandler
implements McpStatelessServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpStatelessServerHandler.class);
    Map<String, McpStatelessRequestHandler<?>> requestHandlers;
    Map<String, McpStatelessNotificationHandler> notificationHandlers;
    private final CommandExecutor commandExecutor;
    private final ArthasCommandSessionManager commandSessionManager;

    public DefaultMcpStatelessServerHandler(Map<String, McpStatelessRequestHandler<?>> requestHandlers, Map<String, McpStatelessNotificationHandler> notificationHandlers, CommandExecutor commandExecutor) {
        this.requestHandlers = requestHandlers;
        this.notificationHandlers = notificationHandlers;
        this.commandExecutor = commandExecutor;
        this.commandSessionManager = new ArthasCommandSessionManager(commandExecutor);
    }

    @Override
    public CompletableFuture<McpSchema.JSONRPCResponse> handleRequest(McpTransportContext ctx, McpSchema.JSONRPCRequest req) {
        McpStatelessRequestHandler<?> handler;
        String userId;
        String tempSessionId = UUID.randomUUID().toString();
        ArthasCommandSessionManager.CommandSessionBinding binding = this.commandSessionManager.createCommandSession(tempSessionId);
        ArthasCommandContext commandContext = new ArthasCommandContext(this.commandExecutor, binding);
        Object authSubject = ctx.get("mcp.auth.subject");
        if (authSubject != null) {
            this.commandExecutor.setSessionAuth(binding.getArthasSessionId(), authSubject);
            logger.debug("Applied auth subject to stateless session: {}", (Object)binding.getArthasSessionId());
        }
        if ((userId = (String)ctx.get("mcp.user.id")) != null) {
            this.commandExecutor.setSessionUserId(binding.getArthasSessionId(), userId);
            logger.debug("Applied userId to stateless session: {}", (Object)binding.getArthasSessionId());
        }
        if ((handler = this.requestHandlers.get(req.getMethod())) == null) {
            this.closeSession(binding);
            CompletableFuture<McpSchema.JSONRPCResponse> f = new CompletableFuture<McpSchema.JSONRPCResponse>();
            f.completeExceptionally(new McpError((Object)("Missing handler for request type: " + req.getMethod())));
            return f;
        }
        try {
            CompletableFuture<?> result = handler.handle(ctx, commandContext, req.getParams());
            return result.handle((r, ex) -> {
                this.closeSession(binding);
                if (ex != null) {
                    Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
                    return new McpSchema.JSONRPCResponse("2.0", req.getId(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32603, cause.getMessage(), null));
                }
                return new McpSchema.JSONRPCResponse("2.0", req.getId(), r, null);
            });
        }
        catch (Throwable t) {
            this.closeSession(binding);
            CompletableFuture<McpSchema.JSONRPCResponse> f = new CompletableFuture<McpSchema.JSONRPCResponse>();
            f.completeExceptionally(t);
            return f;
        }
    }

    private void closeSession(ArthasCommandSessionManager.CommandSessionBinding binding) {
        try {
            this.commandExecutor.closeSession(binding.getArthasSessionId());
        }
        catch (Exception e) {
            logger.warn("Failed to close temporary session: {}", (Object)binding.getArthasSessionId(), (Object)e);
        }
    }

    @Override
    public CompletableFuture<Void> handleNotification(McpTransportContext ctx, McpSchema.JSONRPCNotification note) {
        McpStatelessNotificationHandler handler = this.notificationHandlers.get(note.getMethod());
        if (handler == null) {
            logger.warn("Missing handler for notification: {}", (Object)note.getMethod());
            return CompletableFuture.completedFuture(null);
        }
        try {
            return handler.handle(ctx, note.getParams());
        }
        catch (Throwable t) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(t);
            return f;
        }
    }
}

