/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.session;

import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.session.ArthasCommandSessionManager;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArthasCommandContext {
    private static final Logger logger = LoggerFactory.getLogger(ArthasCommandContext.class);
    private final CommandExecutor commandExecutor;
    private final ArthasCommandSessionManager.CommandSessionBinding sessionBinding;
    private static final long DEFAULT_SYNC_TIMEOUT = 30000L;

    public ArthasCommandContext(CommandExecutor commandExecutor) {
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor cannot be null");
        this.sessionBinding = null;
    }

    public ArthasCommandContext(CommandExecutor commandExecutor, ArthasCommandSessionManager.CommandSessionBinding sessionBinding) {
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor cannot be null");
        this.sessionBinding = Objects.requireNonNull(sessionBinding, "sessionBinding cannot be null");
    }

    private void requireSessionSupport() {
        if (this.sessionBinding == null) {
            throw new IllegalStateException("Session-based operations are not supported in temporary mode. Use ArthasCommandContext(CommandExecutor, CommandSessionBinding) constructor to enable session support.");
        }
    }

    public Map<String, Object> executeSync(String commandLine) {
        return this.executeSync(commandLine, 30000L);
    }

    public Map<String, Object> executeSync(String commandLine, long timeout) {
        return this.commandExecutor.executeSync(commandLine, timeout);
    }

    public Map<String, Object> executeSync(String commandStr, Object authSubject) {
        return this.commandExecutor.executeSync(commandStr, 30000L, null, authSubject, null);
    }

    public Map<String, Object> executeSync(String commandStr, Object authSubject, String userId) {
        return this.commandExecutor.executeSync(commandStr, 30000L, null, authSubject, userId);
    }

    public Map<String, Object> executeAsync(String commandLine) {
        this.requireSessionSupport();
        return this.commandExecutor.executeAsync(commandLine, this.sessionBinding.getArthasSessionId());
    }

    public Map<String, Object> pullResults() {
        this.requireSessionSupport();
        return this.commandExecutor.pullResults(this.sessionBinding.getArthasSessionId(), this.sessionBinding.getConsumerId());
    }

    public Map<String, Object> interruptJob() {
        this.requireSessionSupport();
        return this.commandExecutor.interruptJob(this.sessionBinding.getArthasSessionId());
    }

    public String getArthasSessionId() {
        this.requireSessionSupport();
        return this.sessionBinding.getArthasSessionId();
    }

    public void setSessionUserId(String userId) {
        if (this.sessionBinding != null && userId != null) {
            this.commandExecutor.setSessionUserId(this.sessionBinding.getArthasSessionId(), userId);
            logger.debug("Set userId for session {}: {}", (Object)this.sessionBinding.getArthasSessionId(), (Object)userId);
        }
    }
}

