/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.protocol.server.DefaultMcpStatelessServerHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpNettyServerExchange;
import com.taobao.arthas.mcp.server.protocol.server.McpNotificationHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessNotificationHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessServerFeatures;
import com.taobao.arthas.mcp.server.protocol.spec.McpError;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.protocol.spec.McpStatelessServerTransport;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpStatelessNettyServer {
    private static final Logger logger = LoggerFactory.getLogger(McpStatelessNettyServer.class);
    private final McpStatelessServerTransport mcpTransportProvider;
    private final ObjectMapper objectMapper;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final String instructions;
    private final CopyOnWriteArrayList<McpStatelessServerFeatures.ToolSpecification> tools = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.ResourceSpecification> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.PromptSpecification> prompts = new ConcurrentHashMap();
    private List<String> protocolVersions;

    public McpStatelessNettyServer(McpStatelessServerTransport mcpTransport, ObjectMapper objectMapper, Duration requestTimeout, McpStatelessServerFeatures.McpServerConfig features, CommandExecutor commandExecutor) {
        this.mcpTransportProvider = mcpTransport;
        this.objectMapper = objectMapper;
        this.serverInfo = features.getServerInfo();
        this.serverCapabilities = features.getServerCapabilities();
        this.instructions = features.getInstructions();
        this.tools.addAll(features.getTools());
        this.resources.putAll(features.getResources());
        this.resourceTemplates.addAll(features.getResourceTemplates());
        this.prompts.putAll(features.getPrompts());
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", (exchange, commandContext, params) -> CompletableFuture.completedFuture(Collections.emptyMap()));
        if (this.serverCapabilities.getTools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (this.serverCapabilities.getResources() != null) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (this.serverCapabilities.getPrompts() != null) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        this.protocolVersions = new ArrayList<String>(mcpTransport.protocolVersions());
        DefaultMcpStatelessServerHandler handler = new DefaultMcpStatelessServerHandler(requestHandlers, new HashMap<String, McpStatelessNotificationHandler>(), commandExecutor);
        mcpTransport.setMcpHandler(handler);
    }

    private CompletableFuture<McpSchema.InitializeResult> initializeRequestHandler(McpSchema.InitializeRequest initializeRequest) {
        return CompletableFuture.supplyAsync(() -> {
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.getProtocolVersion(), initializeRequest.getCapabilities(), initializeRequest.getClientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.getProtocolVersion())) {
                serverProtocolVersion = initializeRequest.getProtocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will suggest {} instead", (Object)initializeRequest.getProtocolVersion(), (Object)serverProtocolVersion);
            }
            return new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, this.instructions);
        });
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public CompletableFuture<Void> closeGracefully() {
        return this.mcpTransportProvider.closeGracefully();
    }

    public void close() {
        this.mcpTransportProvider.close();
    }

    private McpNotificationHandler rootsListChangedNotificationHandler(List<BiFunction<McpNettyServerExchange, List<McpSchema.Root>, CompletableFuture<Void>>> rootsChangeConsumers) {
        return (exchange, commandContext, params) -> {
            CompletableFuture<McpSchema.ListRootsResult> futureRoots = exchange.listRoots();
            return futureRoots.thenCompose(listRootsResult -> {
                List<McpSchema.Root> roots = listRootsResult.getRoots();
                ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
                for (BiFunction consumer : rootsChangeConsumers) {
                    CompletionStage future = ((CompletableFuture)consumer.apply(exchange, roots)).exceptionally(error -> {
                        logger.error("Error handling roots list change notification", error);
                        return null;
                    });
                    futures.add(future);
                }
                return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            });
        };
    }

    public CompletableFuture<Void> addTool(McpStatelessServerFeatures.ToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Tool specification must not be null"));
            return future;
        }
        if (toolSpecification.getTool() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Tool must not be null"));
            return future;
        }
        if (toolSpecification.getCall() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Tool call handler must not be null"));
            return future;
        }
        if (this.serverCapabilities.getTools() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Server must be configured with tool capabilities"));
            return future;
        }
        return CompletableFuture.runAsync(() -> {
            if (this.tools.stream().anyMatch(th -> th.getTool().getName().equals(toolSpecification.getTool().getName()))) {
                throw new CompletionException(new McpError((Object)("Tool with name '" + toolSpecification.getTool().getName() + "' already exists")));
            }
            this.tools.add(toolSpecification);
            logger.debug("Added tool handler: {}", (Object)toolSpecification.getTool().getName());
        }).exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            logger.error("Error while adding tool", cause);
            throw new CompletionException(cause);
        });
    }

    public CompletableFuture<Void> removeTool(String toolName) {
        if (toolName == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Tool name must not be null"));
            return future;
        }
        if (this.serverCapabilities.getTools() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Server must be configured with tool capabilities"));
            return future;
        }
        return CompletableFuture.runAsync(() -> {
            boolean removed = this.tools.removeIf(spec -> spec.getTool().getName().equals(toolName));
            if (!removed) {
                throw new CompletionException(new McpError((Object)("Tool with name '" + toolName + "' not found")));
            }
            logger.debug("Removed tool handler: {}", (Object)toolName);
        }).exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            logger.error("Error while removing tool '{}'", (Object)toolName, (Object)cause);
            throw new CompletionException(cause);
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return (exchange, commandContext, params) -> {
            ArrayList<McpSchema.Tool> tools = new ArrayList<McpSchema.Tool>();
            for (McpStatelessServerFeatures.ToolSpecification toolSpec : this.tools) {
                tools.add(toolSpec.getTool());
            }
            return CompletableFuture.completedFuture(new McpSchema.ListToolsResult(tools, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return (context, commandContext, params) -> {
            McpSchema.CallToolRequest callToolRequest = (McpSchema.CallToolRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.CallToolRequest>(){});
            Optional<McpStatelessServerFeatures.ToolSpecification> toolSpecification = this.tools.stream().filter(tr -> callToolRequest.getName().equals(tr.getTool().getName())).findAny();
            if (!toolSpecification.isPresent()) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(new McpError((Object)("no tool found: " + callToolRequest.getName())));
                return future;
            }
            return toolSpecification.get().getCall().apply(context, commandContext, callToolRequest.getArguments());
        };
    }

    public CompletableFuture<Void> addResource(McpStatelessServerFeatures.ResourceSpecification resourceSpecification) {
        if (resourceSpecification == null || resourceSpecification.getResource() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Resource must not be null"));
            return future;
        }
        if (this.serverCapabilities.getResources() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Server must be configured with resource capabilities"));
            return future;
        }
        return CompletableFuture.runAsync(() -> {
            String uri = resourceSpecification.getResource().getUri();
            if (this.resources.putIfAbsent(uri, resourceSpecification) != null) {
                throw new CompletionException(new McpError((Object)("Resource with URI '" + uri + "' already exists")));
            }
            logger.debug("Added resource handler: {}", (Object)uri);
        }).exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            logger.error("Error while adding resource '{}'", (Object)resourceSpecification.getResource().getUri(), (Object)cause);
            throw new CompletionException(cause);
        });
    }

    public CompletableFuture<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Resource URI must not be null"));
            return future;
        }
        if (this.serverCapabilities.getResources() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Server must be configured with resource capabilities"));
            return future;
        }
        return CompletableFuture.runAsync(() -> {
            McpStatelessServerFeatures.ResourceSpecification removed = this.resources.remove(resourceUri);
            if (removed == null) {
                throw new CompletionException(new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
            }
            logger.debug("Removed resource handler: {}", (Object)resourceUri);
        }).exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            logger.error("Error while removing resource '{}'", (Object)resourceUri, (Object)cause);
            throw new CompletionException(cause);
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return (exchange, commandContext, params) -> {
            ArrayList<McpSchema.Resource> resourceList = new ArrayList<McpSchema.Resource>();
            for (McpStatelessServerFeatures.ResourceSpecification spec : this.resources.values()) {
                resourceList.add(spec.getResource());
            }
            return CompletableFuture.completedFuture(new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return (context, commandContext, params) -> CompletableFuture.completedFuture(new McpSchema.ListResourceTemplatesResult(this.resourceTemplates, null));
    }

    private McpStatelessRequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return (context, commandContext, params) -> {
            McpSchema.ReadResourceRequest resourceRequest = (McpSchema.ReadResourceRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.getUri();
            McpStatelessServerFeatures.ResourceSpecification specification = this.resources.get(resourceUri);
            if (specification != null) {
                return specification.getReadHandler().apply(context, resourceRequest);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new McpError((Object)("Resource not found: " + resourceUri)));
            return future;
        };
    }

    public CompletableFuture<Void> addPrompt(McpStatelessServerFeatures.PromptSpecification promptSpecification) {
        if (promptSpecification == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Prompt specification must not be null"));
            return future;
        }
        if (this.serverCapabilities.getPrompts() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Server must be configured with prompt capabilities"));
            return future;
        }
        return CompletableFuture.runAsync(() -> {
            String name = promptSpecification.getPrompt().getName();
            McpStatelessServerFeatures.PromptSpecification existing = this.prompts.putIfAbsent(name, promptSpecification);
            if (existing != null) {
                throw new CompletionException(new McpError((Object)("Prompt with name '" + name + "' already exists")));
            }
            logger.debug("Added prompt handler: {}", (Object)name);
        }).exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            String name = promptSpecification.getPrompt().getName();
            logger.error("Error while adding prompt '{}'", (Object)name, (Object)cause);
            throw new CompletionException(cause);
        });
    }

    public CompletableFuture<Void> removePrompt(String promptName) {
        if (promptName == null || promptName.isEmpty()) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Prompt name must not be null or empty"));
            return future;
        }
        if (this.serverCapabilities.getPrompts() == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"Server must be configured with prompt capabilities"));
            return future;
        }
        return CompletableFuture.runAsync(() -> {
            McpStatelessServerFeatures.PromptSpecification removed = this.prompts.remove(promptName);
            if (removed == null) {
                throw new CompletionException(new McpError((Object)("Prompt with name '" + promptName + "' not found")));
            }
            logger.debug("Removed prompt handler: {}", (Object)promptName);
        }).exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            logger.error("Error while removing prompt '{}'", (Object)promptName, (Object)cause);
            throw new CompletionException(cause);
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return (exchange, commandContext, params) -> {
            ArrayList<McpSchema.Prompt> promptList = new ArrayList<McpSchema.Prompt>();
            for (McpStatelessServerFeatures.PromptSpecification promptSpec : this.prompts.values()) {
                promptList.add(promptSpec.getPrompt());
            }
            return CompletableFuture.completedFuture(new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return (context, commandContext, params) -> {
            McpSchema.GetPromptRequest promptRequest = (McpSchema.GetPromptRequest)this.objectMapper.convertValue(params, (TypeReference)new TypeReference<McpSchema.GetPromptRequest>(){});
            McpStatelessServerFeatures.PromptSpecification specification = this.prompts.get(promptRequest.getName());
            if (specification != null) {
                return specification.getPromptHandler().apply(context, promptRequest);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new McpError((Object)("Prompt not found: " + promptRequest.getName())));
            return future;
        };
    }

    public void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }
}

