/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.observer.impl;

import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.distribution.ResultDistributor;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.ProcessAware;
import com.taobao.arthas.grpcweb.grpc.DemoBootstrap;
import com.taobao.arthas.grpcweb.grpc.distribution.GrpcResultDistributorImpl;
import com.taobao.arthas.grpcweb.grpc.observer.ArthasStreamObserver;
import com.taobao.arthas.grpcweb.grpc.observer.impl.GrpcProcess;
import com.taobao.arthas.grpcweb.grpc.service.GrpcJobController;
import io.arthas.api.ArthasServices;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.concurrent.atomic.AtomicInteger;

public class ArthasStreamObserverImpl<T>
implements ArthasStreamObserver<T> {
    private StreamObserver<T> streamObserver;
    private AtomicInteger times = new AtomicInteger();
    private GrpcProcess process;
    private Object requestModel;
    private AdviceListener listener;
    private ClassFileTransformer transformer;
    private final int jobId;
    private ResultDistributor resultDistributor;
    private GrpcJobController grpcJobController;
    private Instrumentation instrumentation;

    public ArthasStreamObserverImpl(StreamObserver<T> streamObserver, Object requestModel, GrpcJobController grpcJobController) {
        this.streamObserver = streamObserver;
        this.jobId = grpcJobController.generateGrpcJobId();
        this.instrumentation = grpcJobController.getInstrumentation();
        if (this.resultDistributor == null) {
            this.resultDistributor = new GrpcResultDistributorImpl(this, grpcJobController.getResultViewResolver());
        }
        this.process = new GrpcProcess();
        this.process.setProcessStatus(ExecStatus.READY);
        this.requestModel = requestModel;
        this.setOnCancelHandler();
        this.grpcJobController = grpcJobController;
        this.grpcJobController.registerGrpcJob(this.jobId, this);
    }

    @Override
    public void onNext(T value) {
        this.streamObserver.onNext(value);
    }

    @Override
    public void onError(Throwable t) {
        this.streamObserver.onError(t);
    }

    @Override
    public void onCompleted() {
        this.process.setProcessStatus(ExecStatus.TERMINATED);
        this.streamObserver.onCompleted();
    }

    @Override
    public AtomicInteger times() {
        return this.times;
    }

    @Override
    public void register(AdviceListener adviceListener, ClassFileTransformer transformer) {
        ProcessAware processAware;
        if (adviceListener instanceof ProcessAware && (processAware = (ProcessAware)adviceListener).getProcess() == null) {
            this.process.setProcessStatus(ExecStatus.RUNNING);
            processAware.setProcess((Process)this.process);
        }
        this.listener = adviceListener;
        AdviceWeaver.reg((AdviceListener)this.listener);
        this.transformer = transformer;
    }

    @Override
    public void unregister() {
        if (this.transformer != null) {
            DemoBootstrap.getRunningInstance().getTransformerManager().removeTransformer(this.transformer);
        }
        this.process.setProcessStatus(ExecStatus.TERMINATED);
        if (this.listener instanceof ProcessAware) {
            if (this.process.equals(((ProcessAware)this.listener).getProcess())) {
                AdviceWeaver.unReg((AdviceListener)this.listener);
            }
        } else {
            AdviceWeaver.unReg((AdviceListener)this.listener);
        }
    }

    @Override
    public void end() {
        this.end(0);
    }

    @Override
    public ExecStatus getPorcessStatus() {
        return this.process.status();
    }

    @Override
    public void setProcessStatus(ExecStatus execStatus) {
        this.process.setProcessStatus(execStatus);
    }

    @Override
    public void end(int statusCode) {
        this.end(statusCode, null);
    }

    @Override
    public void end(int statusCode, String message) {
        this.terminate(statusCode, message);
    }

    @Override
    public ArthasStreamObserver write(String msg) {
        ArthasServices.ResponseBody result = ArthasServices.ResponseBody.newBuilder().setStringValue(msg).build();
        this.onNext(result);
        return this;
    }

    @Override
    public void appendResult(ResultModel result) {
        if (this.process.status() != ExecStatus.RUNNING) {
            throw new IllegalStateException("Cannot write to standard output when " + this.process.status().name().toLowerCase());
        }
        result.setJobId(this.jobId);
        if (this.resultDistributor != null) {
            this.resultDistributor.appendResult(result);
        }
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public Object getRequestModel() {
        return this.requestModel;
    }

    @Override
    public void setRequestModel(Object requestModel) {
        this.requestModel = requestModel;
    }

    public void setOnCancelHandler() {
        ServerCallStreamObserver observer = (ServerCallStreamObserver)this.streamObserver;
        observer.setOnCancelHandler(() -> this.end());
    }

    private synchronized boolean terminate(int exitCode, String message) {
        boolean flag;
        if (this.process.status() != ExecStatus.TERMINATED) {
            this.appendResult((ResultModel)new StatusModel(exitCode, message));
            if (this.process != null) {
                this.unregister();
            }
            flag = true;
        } else {
            flag = false;
        }
        this.onCompleted();
        return flag;
    }

    @Override
    public AdviceListener getListener() {
        return this.listener;
    }

    @Override
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }
}

