/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.service.advisor;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AccessPoint;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.ObjectVO;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import com.taobao.arthas.grpcweb.grpc.model.WatchRequestModel;
import com.taobao.arthas.grpcweb.grpc.model.WatchResponseModel;
import com.taobao.arthas.grpcweb.grpc.observer.ArthasStreamObserver;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WatchRpcAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WatchRpcAdviceListener.class);
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private Map<Long, Object> results = new HashMap<Long, Object>();
    private WatchRequestModel watchRequestModel;
    private ArthasStreamObserver arthasStreamObserver;

    public WatchRpcAdviceListener(ArthasStreamObserver arthasStreamObserver, boolean verbose) {
        this.arthasStreamObserver = arthasStreamObserver;
        this.watchRequestModel = (WatchRequestModel)arthasStreamObserver.getRequestModel();
        super.setVerbose(verbose);
    }

    public void setArthasStreamObserver(ArthasStreamObserver arthasStreamObserver) {
        this.arthasStreamObserver = arthasStreamObserver;
        this.watchRequestModel = (WatchRequestModel)arthasStreamObserver.getRequestModel();
    }

    private boolean isFinish() {
        return this.watchRequestModel.isFinish() || !this.watchRequestModel.isBefore() && !this.watchRequestModel.isException() && !this.watchRequestModel.isSuccess();
    }

    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
        if (this.watchRequestModel.isBefore()) {
            this.watching(Advice.newForBefore((ClassLoader)loader, clazz, (ArthasMethod)method, (Object)target, (Object[])args));
        }
    }

    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        Advice advice = Advice.newForAfterReturning((ClassLoader)loader, clazz, (ArthasMethod)method, (Object)target, (Object[])args, (Object)returnObject);
        if (this.watchRequestModel.isSuccess()) {
            this.watching(advice);
        }
        this.finishing(advice);
    }

    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        Advice advice = Advice.newForAfterThrowing((ClassLoader)loader, clazz, (ArthasMethod)method, (Object)target, (Object[])args, (Throwable)throwable);
        if (this.watchRequestModel.isException()) {
            this.watching(advice);
        }
        this.finishing(advice);
    }

    private void finishing(Advice advice) {
        if (this.isFinish()) {
            this.watching(advice);
        }
    }

    private void watching(Advice advice) {
        try {
            System.out.println("************job:  " + this.arthasStreamObserver.getJobId() + "  rpc watch advice\u5f00\u59cb\u6b63\u5f0f\u6267\u884c,\u6267\u884c\u4fe1\u606f\u5982\u4e0b*****************");
            System.out.println("listener ID: + " + this.arthasStreamObserver.getListener().id());
            System.out.println("\u53c2\u6570: \n" + this.watchRequestModel.toString());
            System.out.println("###################***************** \n\n");
            double cost = this.threadLocalWatch.costInMillis();
            boolean conditionResult = this.isConditionMet(this.watchRequestModel.getConditionExpress(), advice, cost);
            if (this.isVerbose()) {
                String msg = "Condition express: " + this.watchRequestModel.getConditionExpress() + " , result: " + conditionResult + "\n";
                this.arthasStreamObserver.appendResult((ResultModel)new MessageModel(msg));
            }
            if (conditionResult) {
                long resultId = this.idGenerator.incrementAndGet();
                this.results.put(resultId, advice);
                Object value = this.getExpressionResult(this.watchRequestModel.getExpress(), advice, cost);
                WatchResponseModel model = new WatchResponseModel();
                model.setResultId(resultId);
                model.setTs(LocalDateTime.now());
                model.setCost(cost);
                model.setValue(new ObjectVO(value, this.watchRequestModel.getExpand()));
                model.setSizeLimit(this.watchRequestModel.getSizeLimit());
                model.setClassName(advice.getClazz().getName());
                model.setMethodName(advice.getMethod().getName());
                if (advice.isBefore()) {
                    model.setAccessPoint(AccessPoint.ACCESS_BEFORE.getKey());
                } else if (advice.isAfterReturning()) {
                    model.setAccessPoint(AccessPoint.ACCESS_AFTER_RETUNING.getKey());
                } else if (advice.isAfterThrowing()) {
                    model.setAccessPoint(AccessPoint.ACCESS_AFTER_THROWING.getKey());
                }
                this.arthasStreamObserver.appendResult((ResultModel)model);
                this.arthasStreamObserver.times().incrementAndGet();
                if (this.isLimitExceeded(this.watchRequestModel.getNumberOfLimit(), this.arthasStreamObserver.times().get())) {
                    String msg = "Command execution times exceed limit: " + this.watchRequestModel.getNumberOfLimit() + ", so command will exit.\n";
                    this.arthasStreamObserver.end();
                }
            }
        }
        catch (Throwable e) {
            logger.warn("watch failed.", e);
            this.arthasStreamObserver.end(-1, "watch failed, condition is: " + this.watchRequestModel.getConditionExpress() + ", express is: " + this.watchRequestModel.getExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.");
        }
    }
}

