/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.model;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.grpcweb.grpc.model.EnhancerRequestModel;
import com.taobao.arthas.grpcweb.grpc.observer.ArthasStreamObserver;
import com.taobao.arthas.grpcweb.grpc.service.advisor.WatchRpcAdviceListener;
import io.arthas.api.ArthasServices;

public class WatchRequestModel
extends EnhancerRequestModel {
    private String classPattern;
    private String methodPattern;
    private String express;
    private String conditionExpress;
    private boolean isBefore = false;
    private boolean isFinish = false;
    private boolean isException = false;
    private boolean isSuccess = false;
    private Integer expand = 1;
    private Integer sizeLimit = 0xA00000;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;
    private static final int MAX_EXPAND = 4;

    public String toString() {
        return "WatchRequestModel{classPattern='" + this.classPattern + '\'' + ", methodPattern='" + this.methodPattern + '\'' + ", express='" + this.express + '\'' + ", conditionExpress='" + this.conditionExpress + '\'' + ", isBefore=" + this.isBefore + ", isFinish=" + this.isFinish + ", isException=" + this.isException + ", isSuccess=" + this.isSuccess + ", expand=" + this.expand + ", sizeLimit=" + this.sizeLimit + ", isRegEx=" + this.isRegEx + ", numberOfLimit=" + this.numberOfLimit + ", excludeClassPattern='" + this.excludeClassPattern + '\'' + ", jobId=" + this.jobId + ", listenerId=" + this.listenerId + ", verbose=" + this.verbose + ", maxNumOfMatchedClass=" + this.maxNumOfMatchedClass + '}';
    }

    public WatchRequestModel(ArthasServices.WatchRequest watchRequest) {
        this.parseRequestParams(watchRequest);
    }

    @Override
    public Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher((String)this.getClassPattern(), (boolean)this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    public Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher((String)this.getMethodPattern(), (boolean)this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(ArthasStreamObserver arthasStreamObserver) {
        AdviceListener listener;
        WatchRequestModel watchRequestModel = (WatchRequestModel)arthasStreamObserver.getRequestModel();
        if (watchRequestModel.getListenerId() != 0L && (listener = AdviceWeaver.listener((long)watchRequestModel.getListenerId())) != null) {
            return listener;
        }
        return new WatchRpcAdviceListener(arthasStreamObserver, GlobalOptions.verbose || watchRequestModel.isVerbose());
    }

    @Override
    public Matcher getClassNameExcludeMatcher() {
        if (this.classNameExcludeMatcher == null && this.getExcludeClassPattern() != null) {
            this.classNameExcludeMatcher = SearchUtils.classNameMatcher((String)this.getExcludeClassPattern(), (boolean)this.isRegEx());
        }
        return this.classNameExcludeMatcher;
    }

    public void parseRequestParams(ArthasServices.WatchRequest watchRequest) {
        this.classPattern = watchRequest.getClassPattern();
        this.methodPattern = watchRequest.getMethodPattern();
        this.express = StringUtils.isEmpty((Object)watchRequest.getExpress()) ? "{params, target, returnObj}" : watchRequest.getExpress();
        this.conditionExpress = watchRequest.getConditionExpress();
        this.isBefore = watchRequest.getIsBefore();
        this.isFinish = watchRequest.getIsFinish();
        this.isException = watchRequest.getIsException();
        this.isSuccess = watchRequest.getIsSuccess();
        if (!(watchRequest.getIsBefore() || watchRequest.getIsFinish() || watchRequest.getIsException() || watchRequest.getIsSuccess())) {
            this.isFinish = true;
        }
        this.expand = watchRequest.getExpand() <= 0 ? Integer.valueOf(1) : (watchRequest.getExpand() > 4 ? Integer.valueOf(4) : Integer.valueOf(watchRequest.getExpand()));
        this.sizeLimit = watchRequest.getSizeLimit() == 0 ? Integer.valueOf(0xA00000) : Integer.valueOf(watchRequest.getSizeLimit());
        this.isRegEx = watchRequest.getIsRegEx();
        this.numberOfLimit = watchRequest.getNumberOfLimit() == 0 ? 100 : watchRequest.getNumberOfLimit();
        this.excludeClassPattern = watchRequest.getExcludeClassPattern().equals("") ? null : watchRequest.getExcludeClassPattern();
        this.listenerId = watchRequest.getListenerId();
        this.verbose = watchRequest.getVerbose();
        this.maxNumOfMatchedClass = watchRequest.getMaxNumOfMatchedClass() == 0 ? 50 : watchRequest.getMaxNumOfMatchedClass();
        this.jobId = watchRequest.getJobId();
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getExpress() {
        return this.express;
    }

    public void setExpress(String express) {
        this.express = express;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    public boolean isBefore() {
        return this.isBefore;
    }

    public void setBefore(boolean before) {
        this.isBefore = before;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public void setFinish(boolean finish) {
        this.isFinish = finish;
    }

    public boolean isException() {
        return this.isException;
    }

    public void setException(boolean exception) {
        this.isException = exception;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public Integer getExpand() {
        return this.expand;
    }

    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    public String getExcludeClassPattern() {
        return this.excludeClassPattern;
    }

    public void setExcludeClassPattern(String excludeClassPattern) {
        this.excludeClassPattern = excludeClassPattern;
    }

    public void setClassNameMatcher(Matcher classNameMatcher) {
        this.classNameMatcher = classNameMatcher;
    }

    public void setClassNameExcludeMatcher(Matcher classNameExcludeMatcher) {
        this.classNameExcludeMatcher = classNameExcludeMatcher;
    }

    public void setMethodNameMatcher(Matcher methodNameMatcher) {
        this.methodNameMatcher = methodNameMatcher;
    }

    public long getListenerId() {
        return this.listenerId;
    }

    public void setListenerId(long listenerId) {
        this.listenerId = listenerId;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getMaxNumOfMatchedClass() {
        return this.maxNumOfMatchedClass;
    }

    public void setMaxNumOfMatchedClass(int maxNumOfMatchedClass) {
        this.maxNumOfMatchedClass = maxNumOfMatchedClass;
    }

    public long getJobId() {
        return this.jobId;
    }
}

