/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.service;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.grpcweb.grpc.DemoBootstrap;
import com.taobao.arthas.grpcweb.grpc.model.WatchRequestModel;
import com.taobao.arthas.grpcweb.grpc.observer.ArthasStreamObserver;
import com.taobao.arthas.grpcweb.grpc.observer.impl.ArthasStreamObserverImpl;
import com.taobao.arthas.grpcweb.grpc.service.GrpcJobController;
import com.taobao.arthas.grpcweb.grpc.service.advisor.WatchRpcAdviceListener;
import io.arthas.api.ArthasServices;
import io.arthas.api.WatchGrpc;
import io.grpc.stub.StreamObserver;

public class WatchCommandService
extends WatchGrpc.WatchImplBase {
    private static final Logger logger = LoggerFactory.getLogger(WatchCommandService.class);
    private WatchRequestModel watchRequestModel;
    private ArthasStreamObserver arthasStreamObserver;
    private GrpcJobController grpcJobController;

    public WatchCommandService(GrpcJobController grpcJobController) {
        this.grpcJobController = grpcJobController;
    }

    @Override
    public void watch(ArthasServices.WatchRequest watchRequest, StreamObserver<ArthasServices.ResponseBody> responseObserver) {
        this.watchRequestModel = new WatchRequestModel(watchRequest);
        ArthasStreamObserverImpl<ArthasServices.ResponseBody> newArthasStreamObserver = new ArthasStreamObserverImpl<ArthasServices.ResponseBody>(responseObserver, this.watchRequestModel, this.grpcJobController);
        if (this.grpcJobController.containsJob(this.watchRequestModel.getJobId())) {
            this.arthasStreamObserver = this.grpcJobController.getGrpcJob(watchRequest.getJobId());
            if (this.arthasStreamObserver != null && this.arthasStreamObserver.getPorcessStatus() == ExecStatus.RUNNING) {
                WatchRpcAdviceListener listener = (WatchRpcAdviceListener)AdviceWeaver.listener((long)this.arthasStreamObserver.getListener().id());
                this.watchRequestModel.setListenerId(listener.id());
                this.arthasStreamObserver.setRequestModel(this.watchRequestModel);
                listener.setArthasStreamObserver(this.arthasStreamObserver);
                this.arthasStreamObserver.appendResult((ResultModel)new MessageModel("SUCCESS CHANGE!!!!!!!!!!!"));
                newArthasStreamObserver.setProcessStatus(ExecStatus.RUNNING);
                newArthasStreamObserver.end(0, "\u4fee\u6539\u6210\u529f!!!");
                return;
            }
            this.arthasStreamObserver = newArthasStreamObserver;
        } else {
            this.arthasStreamObserver = newArthasStreamObserver;
        }
        WatchTask watchTask = new WatchTask();
        DemoBootstrap.getRunningInstance().execute(watchTask);
    }

    private class WatchTask
    implements Runnable {
        private WatchTask() {
        }

        @Override
        public void run() {
            try {
                WatchCommandService.this.watchRequestModel.enhance(WatchCommandService.this.arthasStreamObserver);
            }
            catch (Throwable t) {
                logger.error("Error during processing the command:", t);
                WatchCommandService.this.arthasStreamObserver.end(-1, "Error during processing the command: " + t.getClass().getName() + ", message:" + t.getMessage() + ", please check $HOME/logs/arthas/arthas.log for more details.");
            }
        }
    }
}

