/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.SocketUtils;
import com.taobao.arthas.core.advisor.TransformerManager;
import com.taobao.arthas.grpcweb.grpc.objectUtils.ComplexObject;
import com.taobao.arthas.grpcweb.grpc.server.GrpcServer;
import com.taobao.arthas.grpcweb.grpc.server.httpServer.NettyHttpServer;
import com.taobao.arthas.grpcweb.proxy.server.GrpcWebProxyServer;
import demo.MathGame;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.zeroturnaround.zip.ZipUtil;

public class DemoBootstrap {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private int GRPC_WEB_PROXY_PORT = 8567;
    private int GRPC_PORT = SocketUtils.findAvailableTcpPort();
    private int HTTP_PORT = SocketUtils.findAvailableTcpPort();
    private Instrumentation instrumentation;
    private TransformerManager transformerManager;
    private ScheduledExecutorService executorService;
    private static DemoBootstrap demoBootstrap;

    private DemoBootstrap() throws InterruptedException, IOException {
        ComplexObject ccc = DemoBootstrap.createComplexObject();
        Thread mathDemo = new Thread(() -> {
            MathGame game = new MathGame();
            while (true) {
                try {
                    game.run();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        mathDemo.start();
        this.instrumentation = ByteBuddyAgent.install();
        DemoBootstrap.appendSpyJar(this.instrumentation);
        this.transformerManager = new TransformerManager(this.instrumentation);
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "grpc-service-execute");
                t.setDaemon(true);
                return t;
            }
        });
        Thread allServerStartThread = new Thread("grpc-server-start"){

            @Override
            public void run() {
                try {
                    DemoBootstrap.this.serverStart();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        allServerStartThread.start();
    }

    public void serverStart() throws IOException, InterruptedException {
        ComplexObject complexObject = DemoBootstrap.createComplexObject();
        Thread grpcStartThread = new Thread(() -> {
            GrpcServer grpcServer = new GrpcServer(this.GRPC_PORT, this.instrumentation, this.transformerManager);
            grpcServer.start();
            try {
                System.in.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        grpcStartThread.start();
        Thread grpcWebProxyStartThread = new Thread(() -> {
            GrpcWebProxyServer grpcWebProxyServer = new GrpcWebProxyServer(this.GRPC_WEB_PROXY_PORT, this.GRPC_PORT);
            grpcWebProxyServer.start();
        });
        grpcWebProxyStartThread.start();
        String currentDir = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().getPath();
        String STATIC_LOCATION = Paths.get(currentDir, "static").toString();
        NettyHttpServer nettyHttpServer = new NettyHttpServer(this.HTTP_PORT, STATIC_LOCATION);
        logger.info("start grpc server on port: {}, grpc web proxy server on port: {}, http server server on port: {}", new Object[]{this.GRPC_PORT, this.GRPC_WEB_PROXY_PORT, this.HTTP_PORT});
        System.out.println("Open your web browser and navigate to http://127.0.0.1:" + this.HTTP_PORT + '/' + "index.html");
        nettyHttpServer.start();
    }

    public static synchronized DemoBootstrap getInstance() throws Throwable {
        if (demoBootstrap == null) {
            demoBootstrap = new DemoBootstrap();
        }
        return demoBootstrap;
    }

    public static DemoBootstrap getRunningInstance() {
        if (demoBootstrap == null) {
            throw new IllegalStateException("AllServerStart must be initialized before!");
        }
        return demoBootstrap;
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    public static void appendSpyJar(Instrumentation instrumentation) throws IOException {
        String file = DemoBootstrap.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File spyClassDir = new File(file, "../../../spy/target/classes").getAbsoluteFile();
        File destJarFile = new File(file, "../../../spy/target/test-spy.jar").getAbsoluteFile();
        ZipUtil.pack((File)spyClassDir, (File)destJarFile);
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(destJarFile));
    }

    public static ComplexObject createComplexObject() {
        ComplexObject complexObject = new ComplexObject();
        complexObject.setId(1);
        complexObject.setName("Complex Object");
        complexObject.setValue(3.14);
        int[] numbers = new int[]{1, 2, 3, 4, 5};
        complexObject.setNumbers(numbers);
        Long[] longNumbers = new Long[]{10086L, 10087L, 10088L, 10089L, 10090L, 10091L};
        complexObject.setLongNumbers(longNumbers);
        ComplexObject.NestedObject nestedObject = new ComplexObject.NestedObject();
        nestedObject.setNestedId(10);
        nestedObject.setNestedName("Nested Object");
        nestedObject.setFlag(true);
        complexObject.setNestedObject(nestedObject);
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add("foo");
        stringList.add("bar");
        stringList.add("baz");
        complexObject.setStringList(stringList);
        HashMap<String, Integer> stringIntegerMap = new HashMap<String, Integer>();
        stringIntegerMap.put("one", 1);
        stringIntegerMap.put("two", 2);
        complexObject.setStringIntegerMap(stringIntegerMap);
        complexObject.setDoubleArray(new Double[]{1.0, 2.0, 3.0});
        complexObject.setComplexArray(null);
        complexObject.setCollection(Arrays.asList("element1", "element2"));
        ComplexObject[] complexArray = new ComplexObject[2];
        ComplexObject complexObject1 = new ComplexObject();
        complexObject1.setId(2);
        complexObject1.setName("Complex Object 1");
        complexObject1.setValue(2.71);
        ComplexObject complexObject2 = new ComplexObject();
        complexObject2.setId(3);
        complexObject2.setName("Complex Object 2");
        complexObject2.setValue(1.618);
        complexArray[0] = complexObject1;
        complexArray[1] = complexObject2;
        complexObject.setComplexArray(complexArray);
        int[][] multiDimensionalArray = new int[][]{{1, 2, 3}, {4, 5, 6}};
        complexObject.setMultiDimensionalArray(multiDimensionalArray);
        String[] stringArray = new String[]{"Hello", "World"};
        complexObject.setStringArray(stringArray);
        System.out.println(complexObject);
        return complexObject;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public TransformerManager getTransformerManager() {
        return this.transformerManager;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executorService;
    }

    public static void main(String[] args) throws Throwable {
        DemoBootstrap.getInstance();
    }
}

