/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpc.server.handler.executor;

import com.taobao.arthas.grpc.server.handler.GrpcDispatcher;
import com.taobao.arthas.grpc.server.handler.GrpcRequest;
import com.taobao.arthas.grpc.server.handler.GrpcResponse;
import com.taobao.arthas.grpc.server.handler.StreamObserver;
import com.taobao.arthas.grpc.server.handler.constant.GrpcInvokeTypeEnum;
import com.taobao.arthas.grpc.server.handler.executor.AbstractGrpcExecutor;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientStreamExecutor
extends AbstractGrpcExecutor {
    public ClientStreamExecutor(GrpcDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public GrpcInvokeTypeEnum supportGrpcType() {
        return GrpcInvokeTypeEnum.CLIENT_STREAM;
    }

    @Override
    public void execute(GrpcRequest request, final Http2DataFrame frame, final ChannelHandlerContext context) throws Throwable {
        Integer streamId = request.getStreamId();
        StreamObserver requestObserver = this.requestStreamObserverMap.computeIfAbsent(streamId, id -> {
            StreamObserver<GrpcResponse> responseObserver = new StreamObserver<GrpcResponse>(){
                AtomicBoolean sendHeader = new AtomicBoolean(false);

                @Override
                public void onNext(GrpcResponse res) {
                    if (!this.sendHeader.get()) {
                        this.sendHeader.compareAndSet(false, true);
                        context.writeAndFlush((Object)new DefaultHttp2HeadersFrame(res.getEndHeader()).stream(frame.stream()));
                    }
                    context.writeAndFlush((Object)new DefaultHttp2DataFrame(res.getResponseData()).stream(frame.stream()));
                }

                @Override
                public void onCompleted() {
                    context.writeAndFlush((Object)new DefaultHttp2HeadersFrame(GrpcResponse.getDefaultEndStreamHeader(), true).stream(frame.stream()));
                }
            };
            try {
                return this.dispatcher.clientStreamExecute(request, responseObserver);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        requestObserver.onNext(request);
        if (frame.isEndStream()) {
            requestObserver.onCompleted();
        }
    }
}

