/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.collection;

import com.taobao.arthas.core.util.collection.GaStack;
import java.util.NoSuchElementException;

public class ThreadUnsafeFixGaStack<E>
implements GaStack<E> {
    private static final int EMPTY_INDEX = -1;
    private final Object[] elementArray;
    private final int max;
    private int current = -1;

    public ThreadUnsafeFixGaStack(int max) {
        this.max = max;
        this.elementArray = new Object[max];
    }

    private void checkForPush() {
        if (this.current == this.max) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private void checkForPopOrPeek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public E pop() {
        this.checkForPopOrPeek();
        return (E)this.elementArray[this.current--];
    }

    @Override
    public void push(E e) {
        this.checkForPush();
        this.elementArray[++this.current] = e;
    }

    @Override
    public E peek() {
        this.checkForPopOrPeek();
        return (E)this.elementArray[this.current];
    }

    @Override
    public boolean isEmpty() {
        return this.current == -1;
    }
}

