/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.taobao.arthas.core.shell.term.impl.http.HttpRequestHandler;
import com.taobao.arthas.core.shell.term.impl.http.TtyWebSocketFrameHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.local.LocalChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.termd.core.function.Consumer;
import io.termd.core.tty.TtyConnection;

public class LocalTtyServerInitializer
extends ChannelInitializer<LocalChannel> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private EventExecutorGroup workerGroup;

    public LocalTtyServerInitializer(ChannelGroup group, Consumer<TtyConnection> handler, EventExecutorGroup workerGroup) {
        this.group = group;
        this.handler = handler;
        this.workerGroup = workerGroup;
    }

    protected void initChannel(LocalChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)});
        pipeline.addLast(this.workerGroup, "HttpRequestHandler", (ChannelHandler)new HttpRequestHandler("/ws"));
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws", null, false, 0xA00000, false, true)});
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, 10)});
        pipeline.addLast(new ChannelHandler[]{new TtyWebSocketFrameHandler(this.group, this.handler)});
    }
}

