/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function.klass100;

import com.taobao.arthas.core.mcp.tool.function.AbstractArthasTool;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;

public class ClassLoaderTool
extends AbstractArthasTool {
    public static final String MODE_STATS = "stats";
    public static final String MODE_INSTANCES = "instances";
    public static final String MODE_TREE = "tree";
    public static final String MODE_ALL_CLASSES = "all-classes";
    public static final String MODE_URL_STATS = "url-stats";
    public static final String MODE_URL_CLASSES = "url-classes";

    @Tool(name="classloader", description="ClassLoader \u8bca\u65ad\u5de5\u5177\uff0c\u53ef\u4ee5\u67e5\u770b\u7c7b\u52a0\u8f7d\u5668\u7edf\u8ba1\u4fe1\u606f\u3001\u7ee7\u627f\u6811\u3001URLs\uff0c\u4ee5\u53ca\u8fdb\u884c\u8d44\u6e90\u67e5\u627e\u548c\u7c7b\u52a0\u8f7d\u64cd\u4f5c\u3002\u641c\u7d22\u7c7b\u7684\u573a\u666f\u4f18\u5148\u4f7f\u7528 sc \u5de5\u5177")
    public String classloader(@ToolParam(description="\u663e\u793a\u6a21\u5f0f\uff1astats(\u7edf\u8ba1\u4fe1\u606f\uff0c\u9ed8\u8ba4), instances(\u5b9e\u4f8b\u8be6\u60c5), tree(\u7ee7\u627f\u6811), all-classes(\u6240\u6709\u7c7b\uff0c\u614e\u7528), url-stats(URL\u7edf\u8ba1), url-classes(URL\u4e0e\u7c7b\u5173\u7cfb)", required=false) String mode, @ToolParam(description="ClassLoader\u7684hashcode\uff0816\u8fdb\u5236\uff09\uff0c\u7528\u4e8e\u6307\u5b9a\u7279\u5b9a\u7684ClassLoader", required=false) String classLoaderHash, @ToolParam(description="ClassLoader\u7684\u5b8c\u6574\u7c7b\u540d\uff0c\u5982sun.misc.Launcher$AppClassLoader\uff0c\u53ef\u66ff\u4ee3hashcode", required=false) String classLoaderClass, @ToolParam(description="\u8981\u67e5\u627e\u7684\u8d44\u6e90\u540d\u79f0\uff0c\u5982META-INF/MANIFEST.MF", required=false) String resource, @ToolParam(description="\u8981\u52a0\u8f7d\u7684\u7c7b\u540d\uff0c\u652f\u6301\u5168\u9650\u5b9a\u540d", required=false) String loadClass, @ToolParam(description="\u8be6\u60c5\u6a21\u5f0f\uff1a\u5217\u51fa\u6bcf\u4e2a URL/jar \u4e2d\u7684\u7c7b\u540d\uff08\u7b49\u4ef7\u4e8e -d\uff09\uff0c\u4ec5\u5728 mode=url-classes \u65f6\u751f\u6548", required=false) Boolean details, @ToolParam(description="\u6309 jar \u5305\u540d/URL \u5173\u952e\u5b57\u8fc7\u6ee4\uff0c\u4ec5\u5728 mode=url-classes \u65f6\u751f\u6548", required=false) String jar, @ToolParam(description="\u6309\u7c7b\u540d/\u5305\u540d\u5173\u952e\u5b57\u8fc7\u6ee4\uff0c\u4ec5\u5728 mode=url-classes \u65f6\u751f\u6548", required=false) String classFilter, @ToolParam(description="\u662f\u5426\u4f7f\u7528\u6b63\u5219\u5339\u914d jar/class\uff08\u7b49\u4ef7\u4e8e -E\uff09\uff0c\u4ec5\u5728 mode=url-classes \u65f6\u751f\u6548", required=false) Boolean regex, @ToolParam(description="\u8be6\u60c5\u6a21\u5f0f\u4e0b\u6bcf\u4e2a URL/jar \u6700\u591a\u5c55\u793a\u7c7b\u6570\u91cf\uff08\u7b49\u4ef7\u4e8e -n\uff09\uff0c\u9ed8\u8ba4 100\uff0c\u4ec5\u5728 mode=url-classes \u65f6\u751f\u6548", required=false) Integer limit, ToolContext toolContext) {
        StringBuilder cmd = this.buildCommand("classloader");
        if (mode != null) {
            switch (mode.toLowerCase()) {
                case "instances": {
                    cmd.append(" -l");
                    break;
                }
                case "tree": {
                    cmd.append(" -t");
                    break;
                }
                case "all-classes": {
                    cmd.append(" -a");
                    break;
                }
                case "url-stats": {
                    cmd.append(" --url-stat");
                    break;
                }
                case "url-classes": {
                    cmd.append(" --url-classes");
                    break;
                }
            }
        }
        if (classLoaderHash != null && !classLoaderHash.trim().isEmpty()) {
            this.addParameter(cmd, "-c", classLoaderHash);
        } else if (classLoaderClass != null && !classLoaderClass.trim().isEmpty()) {
            this.addParameter(cmd, "--classLoaderClass", classLoaderClass);
        }
        this.addParameter(cmd, "-r", resource);
        this.addParameter(cmd, "--load", loadClass);
        if (mode != null && MODE_URL_CLASSES.equalsIgnoreCase(mode)) {
            this.addFlag(cmd, "-d", details);
            this.addFlag(cmd, "-E", regex);
            if (limit != null && limit > 0) {
                this.addParameter(cmd, "-n", String.valueOf(limit));
            }
            this.addParameter(cmd, "--jar", jar);
            this.addParameter(cmd, "--class", classFilter);
        }
        return this.executeSync(toolContext, cmd.toString());
    }
}

