/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function.basic1000;

import com.fasterxml.jackson.core.type.TypeReference;
import com.taobao.arthas.core.mcp.tool.function.AbstractArthasTool;
import com.taobao.arthas.core.mcp.tool.function.StreamableToolUtils;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import com.taobao.arthas.mcp.server.util.JsonParser;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ViewFileTool
extends AbstractArthasTool {
    static final String ALLOWED_DIRS_ENV = "ARTHAS_MCP_VIEWFILE_ALLOWED_DIRS";
    static final int DEFAULT_MAX_BYTES = 8192;
    static final int MAX_MAX_BYTES = 65536;

    @Tool(name="viewfile", description="\u67e5\u770b\u6587\u4ef6\u5185\u5bb9\uff08\u4ec5\u5141\u8bb8\u5728\u914d\u7f6e\u7684\u76ee\u5f55\u767d\u540d\u5355\u5185\u67e5\u770b\uff09\uff0c\u5e76\u652f\u6301 cursor/offset \u5206\u6bb5\u8bfb\u53d6\uff0c\u907f\u514d\u4e00\u6b21\u6027\u8fd4\u56de\u5927\u91cf\u5185\u5bb9\u3002\n\u9ed8\u8ba4\u5141\u8bb8\u76ee\u5f55\uff1a\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\u4e0b\u7684 arthas-output\uff08\u82e5\u5b58\u5728\uff09\u3001\u7528\u6237\u76ee\u5f55\u4e0b\u7684 ~/logs/\uff08\u82e5\u5b58\u5728\uff09\u3002\n\u914d\u7f6e\u767d\u540d\u5355\u76ee\u5f55\uff1a\n- \u73af\u5883\u53d8\u91cf: ARTHAS_MCP_VIEWFILE_ALLOWED_DIRS=/path/a,/path/b\n\u4f7f\u7528\u65b9\u5f0f\uff1a\n- \u9996\u6b21\u8bfb\u53d6\uff1a\u4f20 path\uff08\u53ef\u4f20 offset/maxBytes\uff09\n- \u7ee7\u7eed\u8bfb\u53d6\uff1a\u4f20 cursor\uff08\u7531\u4e0a\u4e00\u6b21\u8fd4\u56de\u7ed3\u679c\u63d0\u4f9b\uff09")
    public String viewFile(@ToolParam(description="\u6587\u4ef6\u8def\u5f84\uff08\u7edd\u5bf9\u8def\u5f84\u6216\u76f8\u5bf9\u8def\u5f84\uff1b\u76f8\u5bf9\u8def\u5f84\u4f1a\u5728\u5141\u8bb8\u76ee\u5f55\u4e0b\u89e3\u6790\uff09\u3002\u5f53\u63d0\u4f9b cursor \u65f6\u53ef\u4e0d\u4f20\u3002", required=false) String path, @ToolParam(description="\u6e38\u6807\uff08\u4e0a\u4e00\u6bb5\u8fd4\u56de\u7684 nextCursor\uff09\uff0c\u7528\u4e8e\u7ee7\u7eed\u8bfb\u53d6\u3002\u63d0\u4f9b cursor \u65f6\u4f1a\u5ffd\u7565 path/offset\u3002", required=false) String cursor, @ToolParam(description="\u8d77\u59cb\u5b57\u8282\u504f\u79fb\u91cf\uff08\u9ed8\u8ba4 0\uff09\u3002", required=false) Long offset, @ToolParam(description="\u672c\u6b21\u6700\u591a\u8bfb\u53d6\u5b57\u8282\u6570\uff08\u9ed8\u8ba4 8192\uff0c\u6700\u5927 65536\uff09\u3002", required=false) Integer maxBytes, ToolContext toolContext) {
        try {
            List<Path> allowedRoots = this.loadAllowedRoots();
            if (allowedRoots.isEmpty()) {
                return JsonParser.toJson(StreamableToolUtils.createErrorResponse("viewfile \u672a\u914d\u7f6e\u5141\u8bb8\u76ee\u5f55\u767d\u540d\u5355\uff0c\u4e14\u9ed8\u8ba4\u76ee\u5f55 arthas-output\u3001~/logs/ \u4e0d\u53ef\u7528\u3002\u8bf7\u901a\u8fc7\u73af\u5883\u53d8\u91cf ARTHAS_MCP_VIEWFILE_ALLOWED_DIRS=/path/a,/path/b \u8fdb\u884c\u914d\u7f6e\u3002"));
            }
            CursorRequest cursorRequest = this.parseCursorOrArgs(path, cursor, offset);
            Path targetFile = this.resolveAllowedFile(cursorRequest.path, allowedRoots);
            int readMaxBytes = ViewFileTool.clampMaxBytes(maxBytes);
            long fileSize = Files.size(targetFile);
            long requestedOffset = cursorRequest.offset;
            long effectiveOffset = ViewFileTool.adjustOffset(cursorRequest.cursorUsed, requestedOffset, fileSize);
            byte[] bytes = ViewFileTool.readBytes(targetFile, effectiveOffset, readMaxBytes, fileSize);
            int safeLen = ViewFileTool.utf8SafeLength(bytes, bytes.length);
            String content = new String(bytes, 0, safeLen, StandardCharsets.UTF_8);
            long nextOffset = effectiveOffset + (long)safeLen;
            boolean eof = nextOffset >= fileSize;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("path", targetFile.toString());
            result.put("fileSize", fileSize);
            result.put("requestedOffset", requestedOffset);
            result.put("startOffset", effectiveOffset);
            result.put("maxBytes", readMaxBytes);
            result.put("readBytes", safeLen);
            result.put("nextOffset", nextOffset);
            result.put("eof", eof);
            result.put("nextCursor", this.encodeCursor(targetFile.toString(), nextOffset));
            result.put("content", content);
            if (cursorRequest.cursorUsed && requestedOffset > fileSize) {
                result.put("cursorReset", true);
                result.put("cursorResetReason", "offsetGreaterThanFileSize");
            }
            return JsonParser.toJson(StreamableToolUtils.createCompletedResponse("ok", result));
        }
        catch (Exception e) {
            this.logger.error("viewfile error", (Throwable)e);
            return JsonParser.toJson(StreamableToolUtils.createErrorResponse("viewfile \u6267\u884c\u5931\u8d25: " + e.getMessage()));
        }
    }

    private CursorRequest parseCursorOrArgs(String path, String cursor, Long offset) {
        if (cursor != null && !cursor.trim().isEmpty()) {
            CursorValue decoded = this.decodeCursor(cursor.trim());
            return new CursorRequest(decoded.path, decoded.offset, true);
        }
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9b path \u6216 cursor");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset \u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570");
        }
        long resolvedOffset = offset != null ? offset : 0L;
        return new CursorRequest(path.trim(), resolvedOffset, false);
    }

    private CursorValue decodeCursor(String cursor) {
        try {
            byte[] jsonBytes = Base64.getUrlDecoder().decode(cursor);
            String json = new String(jsonBytes, StandardCharsets.UTF_8);
            Map map = (Map)JsonParser.fromJson((String)json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Object pathObj = map.get("path");
            Object offsetObj = map.get("offset");
            if (!(pathObj instanceof String) || ((String)pathObj).trim().isEmpty()) {
                throw new IllegalArgumentException("cursor \u7f3a\u5c11 path");
            }
            if (!(offsetObj instanceof Number)) {
                throw new IllegalArgumentException("cursor \u7f3a\u5c11 offset");
            }
            long offset = ((Number)offsetObj).longValue();
            if (offset < 0L) {
                throw new IllegalArgumentException("cursor offset \u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570");
            }
            return new CursorValue(((String)pathObj).trim(), offset);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cursor \u89e3\u6790\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private String encodeCursor(String path, long offset) {
        LinkedHashMap<String, Object> cursor = new LinkedHashMap<String, Object>();
        cursor.put("v", 1);
        cursor.put("path", path);
        cursor.put("offset", offset);
        String json = JsonParser.toJson(cursor);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(json.getBytes(StandardCharsets.UTF_8));
    }

    private List<Path> loadAllowedRoots() {
        String config = System.getenv(ALLOWED_DIRS_ENV);
        ArrayList<Path> roots = new ArrayList<Path>();
        if (config != null && !config.trim().isEmpty()) {
            String[] parts;
            for (String part : parts = config.split(",")) {
                String p;
                String string = p = part != null ? part.trim() : "";
                if (p.isEmpty()) continue;
                try {
                    Path root = Paths.get(p, new String[0]).toAbsolutePath().normalize();
                    if (!Files.isDirectory(root, new LinkOption[0])) {
                        this.logger.warn("viewfile allowed dir ignored (not a directory): {}", (Object)root);
                        continue;
                    }
                    roots.add(root.toRealPath(new LinkOption[0]));
                }
                catch (Exception e) {
                    this.logger.warn("viewfile allowed dir ignored (invalid): {}", (Object)p, (Object)e);
                }
            }
        }
        try {
            Path defaultRoot = Paths.get("arthas-output", new String[0]).toAbsolutePath().normalize();
            if (Files.isDirectory(defaultRoot, new LinkOption[0])) {
                roots.add(defaultRoot.toRealPath(new LinkOption[0]));
            }
        }
        catch (Exception e) {
            this.logger.debug("viewfile default root ignored: arthas-output", (Throwable)e);
        }
        try {
            Path userLogsRoot = Paths.get(System.getProperty("user.home"), "logs").toAbsolutePath().normalize();
            if (Files.isDirectory(userLogsRoot, new LinkOption[0])) {
                roots.add(userLogsRoot.toRealPath(new LinkOption[0]));
            }
        }
        catch (Exception e) {
            this.logger.debug("viewfile default root ignored: ~/logs/", (Throwable)e);
        }
        return ViewFileTool.deduplicate(roots);
    }

    private static List<Path> deduplicate(List<Path> roots) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Path> set = new LinkedHashSet<Path>(roots);
        return new ArrayList<Path>(set);
    }

    private Path resolveAllowedFile(String requestedPath, List<Path> allowedRoots) throws Exception {
        Path req = Paths.get(requestedPath, new String[0]);
        if (req.isAbsolute()) {
            Path real = req.toRealPath(new LinkOption[0]);
            ViewFileTool.assertRegularFile(real);
            if (!ViewFileTool.isUnderAllowedRoot(real, allowedRoots)) {
                throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5728\u5141\u8bb8\u76ee\u5f55\u767d\u540d\u5355\u5185: " + requestedPath);
            }
            return real;
        }
        for (Path root : allowedRoots) {
            Path real;
            Path candidate = root.resolve(req).normalize();
            if (!candidate.startsWith(root) || !Files.exists(candidate, new LinkOption[0]) || !(real = candidate.toRealPath(new LinkOption[0])).startsWith(root)) continue;
            ViewFileTool.assertRegularFile(real);
            return real;
        }
        throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u5141\u8bb8\u76ee\u5f55\u767d\u540d\u5355\u5185: " + requestedPath);
    }

    private static void assertRegularFile(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("\u4e0d\u662f\u666e\u901a\u6587\u4ef6: " + file);
        }
    }

    private static boolean isUnderAllowedRoot(Path file, List<Path> allowedRoots) {
        for (Path root : allowedRoots) {
            if (!file.startsWith(root)) continue;
            return true;
        }
        return false;
    }

    private static int clampMaxBytes(Integer maxBytes) {
        int value = maxBytes != null && maxBytes > 0 ? maxBytes : 8192;
        return Math.min(value, 65536);
    }

    private static long adjustOffset(boolean cursorUsed, long requestedOffset, long fileSize) {
        if (requestedOffset < 0L) {
            throw new IllegalArgumentException("offset \u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570");
        }
        if (requestedOffset <= fileSize) {
            return requestedOffset;
        }
        return cursorUsed ? 0L : fileSize;
    }

    private static byte[] readBytes(Path file, long offset, int maxBytes, long fileSize) throws Exception {
        int read;
        if (offset < 0L || offset > fileSize) {
            return new byte[0];
        }
        long remaining = fileSize - offset;
        int toRead = (int)Math.min((long)maxBytes, Math.max(0L, remaining));
        if (toRead <= 0) {
            return new byte[0];
        }
        byte[] buf = new byte[toRead];
        try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");){
            raf.seek(offset);
            read = raf.read(buf);
        }
        if (read <= 0) {
            return new byte[0];
        }
        return Arrays.copyOf(buf, read);
    }

    static int utf8SafeLength(byte[] bytes, int length) {
        int expectedLen;
        int i;
        if (bytes == null || length <= 0) {
            return 0;
        }
        int lastIndex = length - 1;
        int lastByte = bytes[lastIndex] & 0xFF;
        if ((lastByte & 0x80) == 0) {
            return length;
        }
        int continuation = 0;
        for (i = lastIndex; i >= 0 && (bytes[i] & 0xC0) == 128; --i) {
            ++continuation;
        }
        if (i < 0) {
            return Math.max(0, length - continuation);
        }
        int lead = bytes[i] & 0xFF;
        if ((lead & 0xE0) == 192) {
            expectedLen = 2;
        } else if ((lead & 0xF0) == 224) {
            expectedLen = 3;
        } else if ((lead & 0xF8) == 240) {
            expectedLen = 4;
        } else {
            return length;
        }
        int actualLen = continuation + 1;
        if (actualLen < expectedLen) {
            return i;
        }
        return length;
    }

    private static final class CursorValue {
        private final String path;
        private final long offset;

        private CursorValue(String path, long offset) {
            this.path = path;
            this.offset = offset;
        }
    }

    private static final class CursorRequest {
        private final String path;
        private final long offset;
        private final boolean cursorUsed;

        private CursorRequest(String path, long offset, boolean cursorUsed) {
            this.path = path;
            this.offset = offset;
            this.cursorUsed = cursorUsed;
        }
    }
}

