/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function;

import com.taobao.arthas.core.command.model.CommandRequestModel;
import com.taobao.arthas.core.command.model.EnhancerModel;
import com.taobao.arthas.core.command.model.InputStatus;
import com.taobao.arthas.core.command.model.InputStatusModel;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.SessionModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.command.model.WelcomeModel;
import com.taobao.arthas.mcp.server.protocol.server.McpNettyServerExchange;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.session.ArthasCommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamableToolUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamableToolUtils.class);
    private static final int DEFAULT_POLL_INTERVAL_MS = 100;
    private static final int ERROR_RETRY_INTERVAL_MS = 500;
    public static final long DEFAULT_TIMEOUT_MS = 30000L;
    private static final int MAX_ERROR_RETRIES = 10;
    public static final int MIN_ALLOW_INPUT_COUNT_TO_COMPLETE = 2;

    private StreamableToolUtils() {
    }

    public static Map<String, Object> executeAndCollectResults(McpNettyServerExchange exchange, ArthasCommandContext commandContext, Integer expectedResultCount, Integer intervalMs, Integer timeoutMs, String progressToken) {
        ArrayList<Object> allResults = new ArrayList<Object>();
        int errorRetries = 0;
        int allowInputCount = 0;
        int totalResultCount = 0;
        int pullIntervalMs = intervalMs != null && intervalMs > 0 ? intervalMs : 100;
        long executionTimeoutMs = timeoutMs != null && timeoutMs > 0 ? (long)timeoutMs.intValue() : 30000L;
        long deadline = System.currentTimeMillis() + executionTimeoutMs;
        boolean timedOut = false;
        try {
            while (System.currentTimeMillis() < deadline) {
                try {
                    boolean allowInputCompletion;
                    boolean commandCompleted;
                    Map results = commandContext.pullResults();
                    if (results == null) {
                        Thread.sleep(pullIntervalMs);
                        continue;
                    }
                    errorRetries = 0;
                    String errorMessage = StreamableToolUtils.checkForErrorMessages(results);
                    if (errorMessage != null) {
                        logger.warn("Command execution failed with error: {}", (Object)errorMessage);
                        return StreamableToolUtils.createErrorResponseWithResults(errorMessage, allResults, totalResultCount);
                    }
                    Map<String, Object> filteredResults = StreamableToolUtils.filterCommandSpecificResults(results);
                    List<Object> currentBatchResults = StreamableToolUtils.getCommandSpecificResults(filteredResults);
                    if (currentBatchResults != null && !currentBatchResults.isEmpty()) {
                        allResults.addAll(currentBatchResults);
                        logger.debug("Collected {} results, total: {}", (Object)currentBatchResults.size(), (Object)(totalResultCount += currentBatchResults.size()));
                        if (exchange != null) {
                            StreamableToolUtils.sendProgressNotification(exchange, totalResultCount, expectedResultCount != null ? expectedResultCount : totalResultCount, progressToken);
                        }
                    }
                    if (commandCompleted = StreamableToolUtils.checkCommandCompletion(results, allowInputCount)) {
                        ++allowInputCount;
                    }
                    String jobStatus = (String)results.get("jobStatus");
                    boolean hasExpectedResultCount = expectedResultCount != null;
                    boolean reachedExpectedResultCount = hasExpectedResultCount && totalResultCount >= expectedResultCount;
                    boolean bl = allowInputCompletion = !hasExpectedResultCount && commandCompleted && allowInputCount >= 2;
                    if (!"TERMINATED".equals(jobStatus) && !allowInputCompletion && !reachedExpectedResultCount) continue;
                    logger.info("Command completed. Total results collected: {}, Expected: {}", (Object)totalResultCount, (Object)expectedResultCount);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Command execution interrupted");
                    return null;
                }
                catch (Exception e) {
                    if (++errorRetries >= 10) {
                        logger.error("Maximum error retries exceeded", (Throwable)e);
                        return null;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
            }
            if (System.currentTimeMillis() >= deadline) {
                timedOut = true;
            }
            return StreamableToolUtils.createFinalResult(allResults, totalResultCount, timedOut, executionTimeoutMs);
        }
        catch (Exception e) {
            logger.error("Error in command execution", (Throwable)e);
            return null;
        }
    }

    private static boolean checkCommandCompletion(Map<String, Object> results, int currentAllowInputCount) {
        if (results == null) {
            return false;
        }
        List resultList = (List)results.get("results");
        if (resultList == null || resultList.isEmpty()) {
            return false;
        }
        for (Object result : resultList) {
            InputStatusModel inputStatusModel;
            InputStatus inputStatus;
            if (!(result instanceof InputStatusModel) || (inputStatus = (inputStatusModel = (InputStatusModel)result).getInputStatus()) != InputStatus.ALLOW_INPUT) continue;
            logger.debug("Command completion detected: ALLOW_INPUT (count: {})", (Object)(currentAllowInputCount + 1));
            return true;
        }
        return false;
    }

    private static String checkForErrorMessages(Map<String, Object> results) {
        if (results == null) {
            return null;
        }
        List resultList = (List)results.get("results");
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        for (Object result : resultList) {
            String message = null;
            if (result instanceof MessageModel) {
                message = ((MessageModel)result).getMessage();
            } else if (result instanceof EnhancerModel) {
                message = ((EnhancerModel)result).getMessage();
            } else if (result instanceof StatusModel) {
                message = ((StatusModel)result).getMessage();
            } else if (result instanceof CommandRequestModel) {
                message = ((CommandRequestModel)result).getMessage();
            }
            if (message == null || !StreamableToolUtils.isErrorMessage(message)) continue;
            return message;
        }
        return null;
    }

    private static boolean isErrorMessage(String message) {
        return message.matches(".*\\b(failed|error|exception)\\b.*") || message.contains("Malformed OGNL expression") || message.contains("ParseException") || message.contains("ExpressionSyntaxException") || message.matches(".*Exception.*") || message.matches(".*Error.*");
    }

    private static Map<String, Object> filterCommandSpecificResults(Map<String, Object> results) {
        if (results == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> filteredResults = new HashMap<String, Object>(results);
        List resultList = (List)results.get("results");
        if (resultList == null || resultList.isEmpty()) {
            return filteredResults;
        }
        List filteredResultList = resultList.stream().filter(result -> !StreamableToolUtils.isAuxiliaryModel(result)).collect(Collectors.toList());
        filteredResults.put("results", filteredResultList);
        filteredResults.put("resultCount", filteredResultList.size());
        return filteredResults;
    }

    private static boolean isAuxiliaryModel(Object result) {
        return result instanceof InputStatusModel || result instanceof StatusModel || result instanceof WelcomeModel || result instanceof MessageModel || result instanceof CommandRequestModel || result instanceof SessionModel || result instanceof EnhancerModel;
    }

    private static List<Object> getCommandSpecificResults(Map<String, Object> filteredResults) {
        if (filteredResults == null) {
            return new ArrayList<Object>();
        }
        List resultList = (List)filteredResults.get("results");
        return resultList != null ? resultList : new ArrayList();
    }

    private static void sendProgressNotification(McpNettyServerExchange exchange, int currentResultCount, int totalExpected, String progressToken) {
        try {
            if (progressToken != null && !progressToken.trim().isEmpty()) {
                exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, (double)currentResultCount, Double.valueOf(totalExpected))).join();
            }
        }
        catch (Exception e) {
            logger.error("Error sending progress notification", (Throwable)e);
        }
    }

    public static Map<String, Object> createErrorResponse(String message) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("error", true);
        response.put("message", message);
        response.put("status", "error");
        response.put("stage", "final");
        return response;
    }

    public static Map<String, Object> createErrorResponseWithResults(String message, List<Object> collectedResults, int resultCount) {
        Map<String, Object> response = StreamableToolUtils.createErrorResponse(message);
        response.put("results", collectedResults != null ? collectedResults : new ArrayList());
        response.put("resultCount", resultCount);
        return response;
    }

    private static Map<String, Object> createFinalResult(List<Object> allResults, int totalResultCount, boolean timedOut, long timeoutMs) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        finalResult.put("results", allResults);
        finalResult.put("resultCount", totalResultCount);
        finalResult.put("status", "completed");
        finalResult.put("stage", "final");
        finalResult.put("timedOut", timedOut);
        if (timedOut) {
            logger.warn("Command execution timed out after {} ms", (Object)timeoutMs);
            finalResult.put("warning", "Command execution timed out after " + timeoutMs + " ms.");
        }
        return finalResult;
    }

    public static Map<String, Object> createCompletedResponse(String message, Map<String, Object> results) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "completed");
        response.put("message", message);
        response.put("stage", "final");
        if (results != null) {
            response.putAll(results);
        }
        return response;
    }
}

