/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.model;

import com.taobao.arthas.core.command.model.TraceNode;

public class MethodNode
extends TraceNode {
    private String className;
    private String methodName;
    private int lineNumber;
    private Boolean isThrow;
    private String throwExp;
    private boolean isInvoking;
    private long beginTimestamp;
    private long endTimestamp;
    private long minCost = Long.MAX_VALUE;
    private long maxCost = Long.MIN_VALUE;
    private long totalCost = 0L;
    private long times = 0L;

    public MethodNode(String className, String methodName, int lineNumber, boolean isInvoking) {
        super("method");
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
        this.isInvoking = isInvoking;
    }

    @Override
    public void begin() {
        this.beginTimestamp = System.nanoTime();
    }

    @Override
    public void end() {
        this.endTimestamp = System.nanoTime();
        long cost = this.getCost();
        if (cost < this.minCost) {
            this.minCost = cost;
        }
        if (cost > this.maxCost) {
            this.maxCost = cost;
        }
        ++this.times;
        this.totalCost += cost;
    }

    public long getCost() {
        return this.endTimestamp - this.beginTimestamp;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public Boolean getThrow() {
        return this.isThrow;
    }

    public void setThrow(Boolean aThrow) {
        this.isThrow = aThrow;
    }

    public String getThrowExp() {
        return this.throwExp;
    }

    public void setThrowExp(String throwExp) {
        this.throwExp = throwExp;
    }

    public long getMinCost() {
        return this.minCost;
    }

    public void setMinCost(long minCost) {
        this.minCost = minCost;
    }

    public long getMaxCost() {
        return this.maxCost;
    }

    public void setMaxCost(long maxCost) {
        this.maxCost = maxCost;
    }

    public long getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(long totalCost) {
        this.totalCost = totalCost;
    }

    public long getTimes() {
        return this.times;
    }

    public void setTimes(long times) {
        this.times = times;
    }

    public boolean isInvoking() {
        return this.isInvoking;
    }

    public void setInvoking(boolean invoking) {
        this.isInvoking = invoking;
    }
}

