/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class IPUtils {
    private static final String WINDOWS = "windows";
    private static final String OS_NAME = "os.name";

    public static boolean isWindowsOS() {
        String osName = System.getProperty(OS_NAME);
        return osName.toLowerCase().contains(WINDOWS);
    }

    public static String getLocalIP() {
        InetAddress ip = null;
        try {
            if (IPUtils.isWindowsOS()) {
                ip = InetAddress.getLocalHost();
            } else if (!InetAddress.getLocalHost().isLoopbackAddress()) {
                ip = InetAddress.getLocalHost();
            } else {
                boolean bFindIP = false;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                block2: while (netInterfaces.hasMoreElements() && !bFindIP) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        ip = ips.nextElement();
                        if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                        bFindIP = true;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip == null ? null : ip.getHostAddress();
    }

    public static boolean isAllZeroIP(String ipStr) {
        char[] charArray;
        if (ipStr == null || ipStr.isEmpty()) {
            return false;
        }
        for (char c : charArray = ipStr.toCharArray()) {
            if (c == '0' || c == '.' || c == ':') continue;
            return false;
        }
        return true;
    }
}

