/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.taobao.arthas.core.shell.term.impl.http.ExtHttpTtyConnection;
import com.taobao.arthas.core.shell.term.impl.http.HttpRequestHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.termd.core.function.Consumer;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.tty.TtyConnection;

public class TtyWebSocketFrameHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private ChannelHandlerContext context;
    private HttpTtyConnection conn;

    public TtyWebSocketFrameHandler(ChannelGroup group, Consumer<TtyConnection> handler) {
        this.group = group;
        this.handler = handler;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.context = ctx;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            ctx.pipeline().remove(HttpRequestHandler.class);
            this.group.add((Object)ctx.channel());
            this.conn = new ExtHttpTtyConnection(this.context);
            this.handler.accept((Object)this.conn);
        } else if (evt instanceof IdleStateEvent) {
            ctx.writeAndFlush((Object)new PingWebSocketFrame());
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Consumer closeHandler;
        HttpTtyConnection tmp = this.conn;
        this.context = null;
        this.conn = null;
        if (tmp != null && (closeHandler = tmp.getCloseHandler()) != null) {
            closeHandler.accept(null);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        this.conn.writeToDecoder(msg.text());
    }
}

