/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.command.impl;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandBuilder;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.middleware.cli.CLI;
import java.util.Collections;

public class CommandBuilderImpl
extends CommandBuilder {
    private final String name;
    private final CLI cli;
    private Handler<CommandProcess> processHandler;
    private Handler<Completion> completeHandler;

    public CommandBuilderImpl(String name, CLI cli) {
        this.name = name;
        this.cli = cli;
    }

    @Override
    public CommandBuilderImpl processHandler(Handler<CommandProcess> handler) {
        this.processHandler = handler;
        return this;
    }

    @Override
    public CommandBuilderImpl completionHandler(Handler<Completion> handler) {
        this.completeHandler = handler;
        return this;
    }

    @Override
    public Command build() {
        return new CommandImpl();
    }

    private class CommandImpl
    extends Command {
        private CommandImpl() {
        }

        @Override
        public String name() {
            return CommandBuilderImpl.this.name;
        }

        @Override
        public CLI cli() {
            return CommandBuilderImpl.this.cli;
        }

        @Override
        public Handler<CommandProcess> processHandler() {
            return CommandBuilderImpl.this.processHandler;
        }

        @Override
        public void complete(Completion completion) {
            if (CommandBuilderImpl.this.completeHandler != null) {
                try {
                    CommandBuilderImpl.this.completeHandler.handle(completion);
                }
                catch (Throwable t) {
                    completion.complete(Collections.emptyList());
                }
            } else {
                super.complete(completion);
            }
        }
    }
}

