/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function.monitor200;

import com.taobao.arthas.core.mcp.tool.function.AbstractArthasTool;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;

public class WatchTool
extends AbstractArthasTool {
    public static final int DEFAULT_NUMBER_OF_EXECUTIONS = 1;
    public static final int DEFAULT_POLL_INTERVAL_MS = 50;
    public static final int DEFAULT_MAX_MATCH_COUNT = 50;
    public static final int DEFAULT_EXPAND_LEVEL = 1;
    public static final String DEFAULT_EXPRESS = "{params, target, returnObj}";

    @Tool(name="watch", description="Watch \u65b9\u6cd5\u6267\u884c\u89c2\u5bdf\u5de5\u5177: \u89c2\u5bdf\u6307\u5b9a\u65b9\u6cd5\u7684\u8c03\u7528\u60c5\u51b5\uff0c\u5305\u62ec\u5165\u53c2\u3001\u8fd4\u56de\u503c\u548c\u629b\u51fa\u5f02\u5e38\u7b49\u4fe1\u606f\uff0c\u652f\u6301\u5b9e\u65f6\u6d41\u5f0f\u8f93\u51fa\u3002\u5bf9\u5e94 Arthas \u7684 watch \u547d\u4ee4\u3002", streamable=true)
    public String watch(@ToolParam(description="\u7c7b\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\uff0c\u5982demo.MathGame") String classPattern, @ToolParam(description="\u65b9\u6cd5\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\uff0c\u5982primeFactors", required=false) String methodPattern, @ToolParam(description="\u89c2\u5bdf\u8868\u8fbe\u5f0f\uff0c\u9ed8\u8ba4\u4e3a{params, target, returnObj}\uff0c\u652f\u6301OGNL\u8868\u8fbe\u5f0f", required=false) String express, @ToolParam(description="OGNL\u6761\u4ef6\u8868\u8fbe\u5f0f\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u8c03\u7528\u624d\u4f1a\u88ab\u89c2\u5bdf\uff0c\u5982params[0]<0", required=false) String condition, @ToolParam(description="\u5728\u65b9\u6cd5\u8c03\u7528\u4e4b\u524d\u89c2\u5bdf(-b)\uff0c\u9ed8\u8ba4false", required=false) Boolean beforeMethod, @ToolParam(description="\u5728\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38\u540e\u89c2\u5bdf(-e)\uff0c\u9ed8\u8ba4false", required=false) Boolean exceptionOnly, @ToolParam(description="\u5728\u65b9\u6cd5\u6b63\u5e38\u8fd4\u56de\u540e\u89c2\u5bdf(-s)\uff0c\u9ed8\u8ba4false", required=false) Boolean successOnly, @ToolParam(description="\u6267\u884c\u6b21\u6570\u9650\u5236\uff0c\u9ed8\u8ba4\u503c\u4e3a 1\u3002\u8fbe\u5230\u6307\u5b9a\u6b21\u6570\u540e\u81ea\u52a8\u505c\u6b62", required=false) Integer numberOfExecutions, @ToolParam(description="\u5f00\u542f\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u9ed8\u8ba4\u4e3a\u901a\u914d\u7b26\u5339\u914d\uff0c\u9ed8\u8ba4false", required=false) Boolean regex, @ToolParam(description="\u6307\u5b9aClass\u6700\u5927\u5339\u914d\u6570\u91cf\uff0c\u9ed8\u8ba450", required=false) Integer maxMatchCount, @ToolParam(description="\u6307\u5b9a\u8f93\u51fa\u7ed3\u679c\u7684\u5c5e\u6027\u904d\u5386\u6df1\u5ea6\uff0c\u9ed8\u8ba41\uff0c\u6700\u59274", required=false) Integer expandLevel, @ToolParam(description="\u547d\u4ee4\u6267\u884c\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u4e3a\u79d2\uff0c\u9ed8\u8ba430\u79d2\u3002\u8d85\u65f6\u540e\u547d\u4ee4\u81ea\u52a8\u9000\u51fa", required=false) Integer timeout, ToolContext toolContext) {
        int execCount = this.getDefaultValue(numberOfExecutions, 1);
        int maxMatch = this.getDefaultValue(maxMatchCount, 50);
        int expandDepth = expandLevel != null && expandLevel >= 1 && expandLevel <= 4 ? expandLevel : 1;
        String watchExpress = this.getDefaultValue(express, DEFAULT_EXPRESS);
        int timeoutSeconds = this.getDefaultValue(timeout, 30);
        StringBuilder cmd = this.buildCommand("watch");
        cmd.append(" --timeout ").append(timeoutSeconds);
        cmd.append(" -n ").append(execCount);
        cmd.append(" -m ").append(maxMatch);
        cmd.append(" -x ").append(expandDepth);
        this.addFlag(cmd, "-E", regex);
        if (Boolean.TRUE.equals(beforeMethod)) {
            cmd.append(" -b");
        } else if (Boolean.TRUE.equals(exceptionOnly)) {
            cmd.append(" -e");
        } else if (Boolean.TRUE.equals(successOnly)) {
            cmd.append(" -s");
        } else {
            cmd.append(" -f");
        }
        this.addParameter(cmd, classPattern);
        if (methodPattern != null && !methodPattern.trim().isEmpty()) {
            cmd.append(" ").append(methodPattern.trim());
        }
        this.addQuotedParameter(cmd, watchExpress);
        this.addQuotedParameter(cmd, condition);
        return this.executeStreamable(toolContext, cmd.toString(), execCount, 50, timeoutSeconds * 1000, "Watch execution completed successfully");
    }
}

