/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.distribution;

import com.alibaba.fastjson2.JSON;
import com.taobao.arthas.core.command.model.Countable;
import com.taobao.arthas.core.command.model.ResultModel;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultConsumerHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResultConsumerHelper.class);
    private static ConcurrentHashMap<String, List<Field>> modelFieldMap = new ConcurrentHashMap();

    public static int getItemCount(ResultModel model) {
        Field field;
        if (model instanceof Countable) {
            return ((Countable)model).size();
        }
        Class<?> modelClass = model.getClass();
        List<Field> fields = modelFieldMap.get(modelClass.getName());
        if (fields == null) {
            fields = new ArrayList<Field>();
            Field[] declaredFields = modelClass.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                field = declaredFields[i];
                Class<?> fieldClass = field.getType();
                if (!Collection.class.isAssignableFrom(fieldClass) && !Map.class.isAssignableFrom(fieldClass) && !Countable.class.isAssignableFrom(fieldClass) && !fieldClass.isArray()) continue;
                field.setAccessible(true);
                fields.add(field);
            }
            List<Field> old_fields = modelFieldMap.putIfAbsent(modelClass.getName(), fields);
            if (old_fields != null) {
                fields = old_fields;
            }
        }
        int count = 0;
        try {
            for (int i = 0; i < fields.size(); ++i) {
                Object value;
                field = fields.get(i);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((value = field.get(model)) == null) continue;
                if (value instanceof Collection) {
                    count += ((Collection)value).size();
                    continue;
                }
                if (value.getClass().isArray()) {
                    count += Array.getLength(value);
                    continue;
                }
                if (value instanceof Map) {
                    count += ((Map)value).size();
                    continue;
                }
                if (!(value instanceof Countable)) continue;
                count += ((Countable)value).size();
            }
        }
        catch (Exception e) {
            logger.error("get item count of result model failed, model: {}", (Object)JSON.toJSONString((Object)model), (Object)e);
        }
        return count > 0 ? count : 1;
    }
}

