/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.command.model.EnhancerModelFactory;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.monitor200.AbstractTraceAdviceListener;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.view.Ansi;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Option;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class EnhancerCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(EnhancerCommand.class);
    protected static final List<String> EMPTY = Collections.emptyList();
    public static final String[] EXPRESS_EXAMPLES = new String[]{"params", "returnObj", "throwExp", "target", "clazz", "method", "{params,returnObj}", "params[0]"};
    private String excludeClassPattern;
    protected Matcher classNameMatcher;
    protected Matcher classNameExcludeMatcher;
    protected Matcher methodNameMatcher;
    protected long listenerId;
    protected boolean verbose;
    protected int maxNumOfMatchedClass;
    protected Long timeout;
    protected boolean lazy = false;

    @Option(longName="exclude-class-pattern")
    @Description(value="exclude class name pattern, use either '.' or '/' as separator")
    public void setExcludeClassPattern(String excludeClassPattern) {
        this.excludeClassPattern = excludeClassPattern;
    }

    @Option(longName="listenerId")
    @Description(value="The special listenerId")
    public void setListenerId(long listenerId) {
        this.listenerId = listenerId;
    }

    @Option(shortName="v", longName="verbose", flag=true)
    @Description(value="Enables print verbose information, default value false.")
    public void setVerbosee(boolean verbose) {
        this.verbose = verbose;
    }

    @Option(shortName="m", longName="maxMatch")
    @DefaultValue(value="50")
    @Description(value="The maximum of matched class.")
    public void setMaxNumOfMatchedClass(int maxNumOfMatchedClass) {
        this.maxNumOfMatchedClass = maxNumOfMatchedClass;
    }

    @Option(longName="timeout")
    @Description(value="Timeout value in seconds for the command to exit automatically.")
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    @Option(shortName="L", longName="lazy", flag=true)
    @Description(value="Enable lazy mode to enhance classes when they are loaded. Useful when the class is not loaded yet.")
    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    protected abstract Matcher getClassNameMatcher();

    protected abstract Matcher getClassNameExcludeMatcher();

    protected abstract Matcher getMethodNameMatcher();

    protected abstract AdviceListener getAdviceListener(CommandProcess var1);

    AdviceListener getAdviceListenerWithId(CommandProcess process) {
        AdviceListener listener;
        if (this.listenerId != 0L && (listener = AdviceWeaver.listener(this.listenerId)) != null) {
            return listener;
        }
        return this.getAdviceListener(process);
    }

    @Override
    public void process(CommandProcess process) {
        process.interruptHandler(new CommandInterruptHandler(process));
        process.stdinHandler((Handler)new QExitHandler(process));
        this.enhance(process);
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 3) {
            this.completeArgument3(completion);
            return;
        }
        super.complete(completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enhance(CommandProcess process) {
        Session session = process.session();
        if (!session.tryLock()) {
            String msg = "someone else is enhancing classes, pls. wait.";
            process.appendResult((ResultModel)EnhancerModelFactory.create(null, false, msg));
            process.end(-1, msg);
            return;
        }
        EnhancerAffect effect = null;
        int lock = session.getLock();
        try {
            Instrumentation inst = session.getInstrumentation();
            AdviceListener listener = this.getAdviceListenerWithId(process);
            if (listener == null) {
                logger.error("advice listener is null");
                String msg = "advice listener is null, check arthas log";
                process.appendResult((ResultModel)EnhancerModelFactory.create(effect, false, msg));
                process.end(-1, msg);
                return;
            }
            boolean skipJDKTrace = false;
            if (listener instanceof AbstractTraceAdviceListener) {
                skipJDKTrace = ((AbstractTraceAdviceListener)listener).getCommand().isSkipJDKTrace();
            }
            Enhancer enhancer = new Enhancer(listener, listener instanceof InvokeTraceable, skipJDKTrace, this.getClassNameMatcher(), this.getClassNameExcludeMatcher(), this.getMethodNameMatcher(), this.lazy);
            process.register(listener, enhancer);
            effect = enhancer.enhance(inst, this.maxNumOfMatchedClass);
            if (effect.getThrowable() != null) {
                String msg = "error happens when enhancing class: " + effect.getThrowable().getMessage();
                process.appendResult((ResultModel)EnhancerModelFactory.create(effect, false, msg));
                process.end(1, msg + ", check arthas log: " + LogUtil.loggingFile());
                return;
            }
            if (effect.cCnt() == 0 || effect.mCnt() == 0) {
                if (!StringUtils.isEmpty(effect.getOverLimitMsg())) {
                    process.appendResult((ResultModel)EnhancerModelFactory.create(effect, false));
                    process.end(-1);
                    return;
                }
                if (this.lazy) {
                    String lazyMsg = "Lazy mode is enabled, waiting for class to be loaded. Press Q or Ctrl+C to abort.\nWhen the target class is loaded, it will be automatically enhanced.";
                    process.write(lazyMsg + "\n");
                } else {
                    process.appendResult((ResultModel)EnhancerModelFactory.create(effect, false, "No class or method is affected"));
                    String smCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("sm CLASS_NAME METHOD_NAME").reset().toString();
                    String optionsCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("options unsafe true").reset().toString();
                    String javaPackage = Ansi.ansi().fg(Ansi.Color.GREEN).a("java.*").reset().toString();
                    String resetCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("reset CLASS_NAME").reset().toString();
                    String logStr = Ansi.ansi().fg(Ansi.Color.GREEN).a(LogUtil.loggingFile()).reset().toString();
                    String issueStr = Ansi.ansi().fg(Ansi.Color.GREEN).a("https://github.com/alibaba/arthas/issues/47").reset().toString();
                    String msg = "No class or method is affected, try:\n1. Execute `" + smCommand + "` to make sure the method you are tracing actually exists (it might be in your parent class).\n2. Execute `" + optionsCommand + "`, if you want to enhance the classes under the `" + javaPackage + "` package.\n3. Execute `" + resetCommand + "` and try again, your method body might be too large.\n4. Match the constructor, use `<init>`, for example: `watch demo.MathGame <init>`\n5. Check arthas log: " + logStr + "\n6. Visit " + issueStr + " for more details.\n7. If the class is not loaded yet, try to use `--lazy` or `-L` option to enable lazy mode.";
                    process.end(-1, msg);
                    return;
                }
            }
            if (session.getLock() == lock && process.isForeground()) {
                process.echoTips("Press Q or Ctrl+C to abort.\n");
            }
            process.appendResult((ResultModel)EnhancerModelFactory.create(effect, true));
            this.scheduleTimeoutTask(process);
        }
        catch (Throwable e) {
            String msg = "error happens when enhancing class: " + e.getMessage();
            logger.error(msg, e);
            process.appendResult((ResultModel)EnhancerModelFactory.create(effect, false, msg));
            process.end(-1, msg);
        }
        finally {
            if (session.getLock() == lock) {
                process.session().unLock();
            }
        }
    }

    protected void completeArgument3(Completion completion) {
        super.complete(completion);
    }

    public String getExcludeClassPattern() {
        return this.excludeClassPattern;
    }

    private void scheduleTimeoutTask(final CommandProcess process) {
        if (this.timeout == null || this.timeout <= 0L) {
            return;
        }
        final ScheduledFuture<?> timeoutFuture = ArthasBootstrap.getInstance().getScheduledExecutorService().schedule(new Runnable(){

            @Override
            public void run() {
                if (process.isRunning()) {
                    process.write("Command execution timeout after " + EnhancerCommand.this.timeout + " seconds.\n");
                    process.end();
                }
            }
        }, (long)this.timeout, TimeUnit.SECONDS);
        process.endHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                timeoutFuture.cancel(false);
            }
        });
    }
}

