/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.ClassDetailVO;
import com.taobao.arthas.core.command.model.ClassLoaderModel;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ClassSetVO;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.RowAffectModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.ResultUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

@Name(value="classloader")
@Summary(value="Show classloader info")
@Description(value="\nEXAMPLES:\n  classloader\n  classloader -t\n  classloader -l\n  classloader -c 327a647b\n  classloader -c 327a647b -r META-INF/MANIFEST.MF\n  classloader -a\n  classloader -a -c 327a647b\n  classloader -c 659e0bfd --load demo.MathGame\n  classloader -u      # url statistics\n  classloader -c 659e0bfd --url-classes\n  classloader -c 659e0bfd --url-classes -d\n  classloader -c 659e0bfd --url-classes --jar spring-core --class org.springframework\n\nWIKI:\n  https://arthas.aliyun.com/doc/classloader")
public class ClassLoaderCommand
extends AnnotatedCommand {
    private static Logger logger = LoggerFactory.getLogger(ClassLoaderCommand.class);
    private static final int DEFAULT_URL_CLASSES_LIMIT = 100;
    private static final String UNKNOWN_CODE_SOURCE = "<unknown>";
    private boolean isTree = false;
    private String hashCode;
    private String classLoaderClass;
    private boolean all = false;
    private String resource;
    private boolean includeReflectionClassLoader = true;
    private boolean listClassLoader = false;
    private boolean urlStat = false;
    private boolean urlClasses = false;
    private boolean urlClassesDetail = false;
    private boolean urlClassesRegEx = false;
    private int urlClassesLimit = 100;
    private String jarFilter;
    private String classFilter;
    private String loadClass = null;
    private volatile boolean isInterrupted = false;

    @Option(shortName="t", longName="tree", flag=true)
    @Description(value="Display ClassLoader tree")
    public void setTree(boolean tree) {
        this.isTree = tree;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="The hash code of the special ClassLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="a", longName="all", flag=true)
    @Description(value="Display all classes loaded by ClassLoader")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(shortName="r", longName="resource")
    @Description(value="Use ClassLoader to find resources, won't work without -c specified")
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Option(shortName="i", longName="include-reflection-classloader", flag=true)
    @Description(value="Include sun.reflect.DelegatingClassLoader")
    public void setIncludeReflectionClassLoader(boolean includeReflectionClassLoader) {
        this.includeReflectionClassLoader = includeReflectionClassLoader;
    }

    @Option(shortName="l", longName="list-classloader", flag=true)
    @Description(value="Display statistics info by classloader instance")
    public void setListClassLoader(boolean listClassLoader) {
        this.listClassLoader = listClassLoader;
    }

    @Option(longName="load")
    @Description(value="Use ClassLoader to load class, won't work without -c specified")
    public void setLoadClass(String className) {
        this.loadClass = className;
    }

    @Option(shortName="u", longName="url-stat", flag=true)
    @Description(value="Display classloader url statistics")
    public void setUrlStat(boolean urlStat) {
        this.urlStat = urlStat;
    }

    @Option(longName="url-classes", flag=true)
    @Description(value="Display relationship between jar(URL) and loaded classes in the specified ClassLoader")
    public void setUrlClasses(boolean urlClasses) {
        this.urlClasses = urlClasses;
    }

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="Display class list for each jar(URL), only works with --url-classes")
    public void setUrlClassesDetail(boolean urlClassesDetail) {
        this.urlClassesDetail = urlClassesDetail;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match for --jar/--class, only works with --url-classes")
    public void setUrlClassesRegEx(boolean urlClassesRegEx) {
        this.urlClassesRegEx = urlClassesRegEx;
    }

    @Option(shortName="n", longName="limit")
    @Description(value="Maximum number of classes to display per jar(URL) in details mode (100 by default), only works with --url-classes -d")
    public void setUrlClassesLimit(int urlClassesLimit) {
        this.urlClassesLimit = urlClassesLimit;
    }

    @Option(longName="jar")
    @Description(value="Filter jar(URL) by keyword (or regex with -E), only works with --url-classes")
    public void setJarFilter(String jarFilter) {
        this.jarFilter = jarFilter;
    }

    @Option(longName="class")
    @Description(value="Filter classes by keyword/package (or regex with -E), only works with --url-classes")
    public void setClassFilter(String classFilter) {
        this.classFilter = StringUtils.normalizeClassName(classFilter);
    }

    @Override
    public void process(CommandProcess process) {
        process.interruptHandler(new ClassLoaderInterruptHandler(this));
        ClassLoader targetClassLoader = null;
        boolean classLoaderSpecified = false;
        Instrumentation inst = process.session().getInstrumentation();
        if (this.urlStat) {
            Map<ClassLoaderVO, ClassLoaderUrlStat> urlStats = this.urlStats(inst);
            ClassLoaderModel model = new ClassLoaderModel();
            model.setUrlStats(urlStats);
            process.appendResult(model);
            process.end();
            return;
        }
        if (!this.urlClasses && (this.urlClassesDetail || this.urlClassesRegEx || this.jarFilter != null || this.classFilter != null || this.urlClassesLimit != 100)) {
            process.end(-1, "Options -d/-E/-n/--jar/--class only work with --url-classes.");
            return;
        }
        if (this.hashCode != null || this.classLoaderClass != null) {
            classLoaderSpecified = true;
        }
        if (this.hashCode != null) {
            Set<ClassLoader> allClassLoader = ClassLoaderCommand.getAllClassLoaders(inst, new Filter[0]);
            for (ClassLoader cl : allClassLoader) {
                if (!Integer.toHexString(cl.hashCode()).equals(this.hashCode)) continue;
                targetClassLoader = cl;
                break;
            }
        } else if (this.classLoaderClass != null) {
            List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
            if (matchedClassLoaders.size() == 1) {
                targetClassLoader = matchedClassLoaders.get(0);
            } else {
                if (matchedClassLoaders.size() > 1) {
                    List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                    ClassLoaderModel classloaderModel = new ClassLoaderModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                    process.appendResult(classloaderModel);
                    process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                    return;
                }
                process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                return;
            }
        }
        if (this.urlClasses) {
            if (!classLoaderSpecified) {
                process.end(-1, "Please specify classloader with '-c <classloader hash>' or '--classLoaderClass <classloader class name>' for --url-classes.");
                return;
            }
            if (targetClassLoader == null) {
                process.end(-1, "Can not find classloader by hashcode: " + this.hashCode + ".");
                return;
            }
            this.processUrlClasses(process, inst, targetClassLoader);
            return;
        }
        if (this.all) {
            String hashCode = this.hashCode;
            if (StringUtils.isBlank(hashCode) && targetClassLoader != null) {
                hashCode = "" + Integer.toHexString(targetClassLoader.hashCode());
            }
            this.processAllClasses(process, inst, hashCode);
        } else if (classLoaderSpecified && this.resource != null) {
            this.processResources(process, inst, targetClassLoader);
        } else if (classLoaderSpecified && this.loadClass != null) {
            this.processLoadClass(process, inst, targetClassLoader);
        } else if (classLoaderSpecified) {
            this.processClassLoader(process, inst, targetClassLoader);
        } else if (this.listClassLoader || this.isTree) {
            this.processClassLoaders(process, inst);
        } else {
            this.processClassLoaderStats(process, inst);
        }
    }

    private void processClassLoaderStats(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        List<ClassLoaderInfo> classLoaderInfos = ClassLoaderCommand.getAllClassLoaderInfo(inst, new Filter[0]);
        HashMap<String, ClassLoaderStat> classLoaderStats = new HashMap<String, ClassLoaderStat>();
        for (ClassLoaderInfo info : classLoaderInfos) {
            String name = info.classLoader == null ? "BootstrapClassLoader" : info.classLoader.getClass().getName();
            ClassLoaderStat stat = (ClassLoaderStat)classLoaderStats.get(name);
            if (null == stat) {
                stat = new ClassLoaderStat();
                classLoaderStats.put(name, stat);
            }
            stat.addLoadedCount(info.loadedClassCount);
            stat.addNumberOfInstance(1);
        }
        TreeMap<String, ClassLoaderStat> sorted = new TreeMap<String, ClassLoaderStat>(new ValueComparator(classLoaderStats));
        sorted.putAll(classLoaderStats);
        process.appendResult(new ClassLoaderModel().setClassLoaderStats(sorted));
        affect.rCnt(sorted.keySet().size());
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processClassLoaders(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        List<ClassLoaderInfo> classLoaderInfos = this.includeReflectionClassLoader ? ClassLoaderCommand.getAllClassLoaderInfo(inst, new Filter[0]) : ClassLoaderCommand.getAllClassLoaderInfo(inst, new SunReflectionClassLoaderFilter());
        List<ClassLoaderVO> classLoaderVOs = new ArrayList<ClassLoaderVO>(classLoaderInfos.size());
        for (ClassLoaderInfo classLoaderInfo : classLoaderInfos) {
            ClassLoaderVO classLoaderVO = ClassUtils.createClassLoaderVO(classLoaderInfo.classLoader);
            classLoaderVO.setLoadedCount(classLoaderInfo.loadedClassCount());
            classLoaderVOs.add(classLoaderVO);
        }
        if (this.isTree) {
            classLoaderVOs = ClassLoaderCommand.processClassLoaderTree(classLoaderVOs);
        }
        process.appendResult(new ClassLoaderModel().setClassLoaders(classLoaderVOs).setTree(this.isTree));
        affect.rCnt(classLoaderInfos.size());
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processClassLoader(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        RowAffect affect = new RowAffect();
        if (targetClassLoader != null) {
            URL[] classLoaderUrls = ClassLoaderUtils.getUrls(targetClassLoader);
            if (classLoaderUrls != null) {
                affect.rCnt(classLoaderUrls.length);
                if (classLoaderUrls.length == 0) {
                    process.appendResult((ResultModel)new MessageModel("urls is empty."));
                } else {
                    process.appendResult(new ClassLoaderModel().setUrls(StringUtils.toStringList(classLoaderUrls)));
                    affect.rCnt(classLoaderUrls.length);
                }
            } else {
                process.appendResult((ResultModel)new MessageModel("not a URLClassLoader."));
            }
        }
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processResources(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        RowAffect affect = new RowAffect();
        int rowCount = 0;
        ArrayList<String> resources = new ArrayList<String>();
        if (targetClassLoader != null) {
            try {
                Enumeration<URL> urls = targetClassLoader.getResources(this.resource);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    resources.add(url.toString());
                    ++rowCount;
                }
            }
            catch (Throwable e) {
                logger.warn("get resource failed, resource: {}", (Object)this.resource, (Object)e);
            }
        }
        affect.rCnt(rowCount);
        process.appendResult(new ClassLoaderModel().setResources(resources));
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processLoadClass(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        if (targetClassLoader != null) {
            try {
                Class<?> clazz = targetClassLoader.loadClass(this.loadClass);
                process.appendResult((ResultModel)new MessageModel("load class success."));
                ClassDetailVO classInfo = ClassUtils.createClassInfo(clazz, false, null);
                process.appendResult(new ClassLoaderModel().setLoadClass(classInfo));
            }
            catch (Throwable e) {
                logger.warn("load class error, class: {}", (Object)this.loadClass, (Object)e);
                process.end(-1, "load class error, class: " + this.loadClass + ", error: " + e.toString());
                return;
            }
        }
        process.end();
    }

    private void processAllClasses(CommandProcess process, Instrumentation inst, String hashCode) {
        RowAffect affect = new RowAffect();
        this.getAllClasses(hashCode, inst, affect, process);
        if (this.checkInterrupted(process)) {
            return;
        }
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void getAllClasses(String hashCode, Instrumentation inst, RowAffect affect, CommandProcess process) {
        int hashCodeInt = -1;
        if (hashCode != null) {
            hashCodeInt = Integer.valueOf(hashCode, 16);
        }
        TreeSet bootstrapClassSet = new TreeSet(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Class[] allLoadedClasses = inst.getAllLoadedClasses();
        HashMap<ClassLoader, TreeSet<Class>> classLoaderClassMap = new HashMap<ClassLoader, TreeSet<Class>>();
        for (Class clazz : allLoadedClasses) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                if (hashCode != null) continue;
                bootstrapClassSet.add(clazz);
                continue;
            }
            if (hashCode != null && classLoader.hashCode() != hashCodeInt) continue;
            TreeSet<Class> classSet = (TreeSet<Class>)classLoaderClassMap.get(classLoader);
            if (classSet == null) {
                classSet = new TreeSet<Class>(new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> o1, Class<?> o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                classLoaderClassMap.put(classLoader, classSet);
            }
            classSet.add(clazz);
        }
        int pageSize = 256;
        this.processClassSet(process, ClassUtils.createClassLoaderVO(null), bootstrapClassSet, pageSize, affect);
        for (Map.Entry entry : classLoaderClassMap.entrySet()) {
            if (this.checkInterrupted(process)) {
                return;
            }
            ClassLoader classLoader = (ClassLoader)entry.getKey();
            SortedSet classSet = (SortedSet)entry.getValue();
            this.processClassSet(process, ClassUtils.createClassLoaderVO(classLoader), classSet, pageSize, affect);
        }
    }

    private void processClassSet(final CommandProcess process, final ClassLoaderVO classLoaderVO, Collection<Class<?>> classes, int pageSize, final RowAffect affect) {
        ResultUtils.processClassNames(classes, pageSize, new ResultUtils.PaginationHandler<List<String>>(){

            @Override
            public boolean handle(List<String> classNames, int segment) {
                process.appendResult(new ClassLoaderModel().setClassSet(new ClassSetVO(classLoaderVO, classNames, segment)));
                affect.rCnt(classNames.size());
                return !ClassLoaderCommand.this.checkInterrupted(process);
            }
        });
    }

    private boolean checkInterrupted(CommandProcess process) {
        if (!process.isRunning()) {
            return true;
        }
        if (this.isInterrupted) {
            process.end(-1, "Processing has been interrupted");
            return true;
        }
        return false;
    }

    private void processUrlClasses(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        if (!this.urlClassesDetail && this.urlClassesLimit != 100) {
            process.end(-1, "Option -n/--limit only works with --url-classes -d.");
            return;
        }
        if (this.urlClassesDetail && this.urlClassesLimit <= 0) {
            process.end(-1, "Option -n/--limit must be greater than 0.");
            return;
        }
        Pattern jarPattern = null;
        Pattern classPattern = null;
        if (this.urlClassesRegEx) {
            try {
                if (this.jarFilter != null) {
                    jarPattern = Pattern.compile(this.jarFilter);
                }
                if (this.classFilter != null) {
                    classPattern = Pattern.compile(this.classFilter);
                }
            }
            catch (Throwable e) {
                process.end(-1, "Regex compile error: " + e.getMessage());
                return;
            }
        }
        HashMap<Object, UrlClassStatBuilder> statsMap = new HashMap<Object, UrlClassStatBuilder>();
        Class[] allLoadedClasses = inst.getAllLoadedClasses();
        for (int i = 0; i < allLoadedClasses.length; ++i) {
            Object url;
            if ((i & 0x3FFF) == 0 && this.checkInterrupted(process)) {
                return;
            }
            Class clazz = allLoadedClasses[i];
            if (clazz == null || clazz.getClassLoader() != targetClassLoader || !this.matchJarFilter((String)(url = ClassLoaderCommand.codeSourceLocation(clazz)), jarPattern)) continue;
            UrlClassStatBuilder builder = (UrlClassStatBuilder)statsMap.get(url);
            if (builder == null) {
                builder = new UrlClassStatBuilder((String)url, this.classFilter != null, this.urlClassesDetail ? this.urlClassesLimit : 0);
                statsMap.put(url, builder);
            }
            builder.increaseLoadedCount();
            if (this.classFilter != null) {
                if (!this.matchClassFilter(clazz.getName(), classPattern)) continue;
                builder.increaseMatchedCount();
                builder.tryAddClass(clazz.getName());
                continue;
            }
            builder.tryAddClass(clazz.getName());
        }
        final boolean hasClassFilter = this.classFilter != null;
        ArrayList<UrlClassStat> stats = new ArrayList<UrlClassStat>(statsMap.size());
        for (UrlClassStatBuilder builder : statsMap.values()) {
            if (hasClassFilter && builder.getMatchedClassCount() == 0) continue;
            stats.add(builder.build());
        }
        Collections.sort(stats, new Comparator<UrlClassStat>(){

            @Override
            public int compare(UrlClassStat o1, UrlClassStat o2) {
                int c1;
                int c2 = hasClassFilter ? ClassLoaderCommand.safeInt(o2.getMatchedClassCount()) : o2.getLoadedClassCount();
                int diff = c2 - (c1 = hasClassFilter ? ClassLoaderCommand.safeInt(o1.getMatchedClassCount()) : o1.getLoadedClassCount());
                if (diff != 0) {
                    return diff;
                }
                return o1.getUrl().compareTo(o2.getUrl());
            }
        });
        RowAffect affect = new RowAffect();
        affect.rCnt(stats.size());
        ClassLoaderModel model = new ClassLoaderModel().setClassLoader(ClassUtils.createClassLoaderVO(targetClassLoader)).setUrlClassStats(stats).setUrlClassStatsDetail(this.urlClassesDetail);
        process.appendResult(model);
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private static int safeInt(Integer v) {
        return v == null ? 0 : v;
    }

    private boolean matchJarFilter(String url, Pattern jarPattern) {
        if (this.jarFilter == null) {
            return true;
        }
        String jarName = ClassLoaderCommand.guessJarName(url);
        if (this.urlClassesRegEx) {
            return jarPattern != null && (jarPattern.matcher(url).find() || jarPattern.matcher(jarName).find());
        }
        return ClassLoaderCommand.containsIgnoreCase(url, this.jarFilter) || ClassLoaderCommand.containsIgnoreCase(jarName, this.jarFilter);
    }

    private boolean matchClassFilter(String className, Pattern classPattern) {
        if (this.classFilter == null) {
            return true;
        }
        if (this.urlClassesRegEx) {
            return classPattern != null && classPattern.matcher(className).find();
        }
        return ClassLoaderCommand.containsIgnoreCase(className, this.classFilter);
    }

    static boolean containsIgnoreCase(String text, String keyword) {
        if (text == null || keyword == null) {
            return false;
        }
        return text.toLowerCase().contains(keyword.toLowerCase());
    }

    private static String codeSourceLocation(Class<?> clazz) {
        try {
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return UNKNOWN_CODE_SOURCE;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return UNKNOWN_CODE_SOURCE;
            }
            URL location = codeSource.getLocation();
            if (location == null) {
                return UNKNOWN_CODE_SOURCE;
            }
            return location.toString();
        }
        catch (Throwable t) {
            return UNKNOWN_CODE_SOURCE;
        }
    }

    static String guessJarName(String url) {
        if (url == null) {
            return "";
        }
        String s = url;
        int bangIndex = s.lastIndexOf(33);
        if (bangIndex >= 0) {
            s = s.substring(0, bangIndex);
        }
        while (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        int slash = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
        if (slash >= 0 && slash < s.length() - 1) {
            s = s.substring(slash + 1);
        }
        return s;
    }

    private Map<ClassLoaderVO, ClassLoaderUrlStat> urlStats(Instrumentation inst) {
        HashMap<ClassLoaderVO, ClassLoaderUrlStat> urlStats = new HashMap<ClassLoaderVO, ClassLoaderUrlStat>();
        HashMap<ClassLoader, HashSet<String>> usedUrlsMap = new HashMap<ClassLoader, HashSet<String>>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            URL location;
            ProtectionDomain protectionDomain;
            CodeSource codeSource;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || (codeSource = (protectionDomain = clazz.getProtectionDomain()).getCodeSource()) == null || (location = codeSource.getLocation()) == null) continue;
            HashSet<String> urls = (HashSet<String>)usedUrlsMap.get(classLoader);
            if (urls == null) {
                urls = new HashSet<String>();
                usedUrlsMap.put(classLoader, urls);
            }
            urls.add(location.toString());
        }
        for (Map.Entry entry : usedUrlsMap.entrySet()) {
            ClassLoader loader = (ClassLoader)entry.getKey();
            Set usedUrls = (Set)entry.getValue();
            URL[] allUrls = ClassLoaderUtils.getUrls(loader);
            ArrayList<String> unusedUrls = new ArrayList<String>();
            if (allUrls != null) {
                for (URL url : allUrls) {
                    String urlStr = url.toString();
                    if (usedUrls.contains(urlStr)) continue;
                    unusedUrls.add(urlStr);
                }
            }
            urlStats.put(ClassUtils.createClassLoaderVO(loader), new ClassLoaderUrlStat(usedUrls, unusedUrls));
        }
        return urlStats;
    }

    private static List<ClassLoaderVO> processClassLoaderTree(List<ClassLoaderVO> classLoaders) {
        ArrayList<ClassLoaderVO> rootClassLoaders = new ArrayList<ClassLoaderVO>();
        HashMap<String, List<ClassLoaderVO>> childMap = new HashMap<String, List<ClassLoaderVO>>();
        for (ClassLoaderVO classLoaderVO : classLoaders) {
            if (classLoaderVO.getParent() == null) {
                rootClassLoaders.add(classLoaderVO);
                continue;
            }
            childMap.computeIfAbsent(classLoaderVO.getParent(), k -> new ArrayList()).add(classLoaderVO);
        }
        for (ClassLoaderVO root : rootClassLoaders) {
            ClassLoaderCommand.buildTree(root, childMap);
        }
        return rootClassLoaders;
    }

    private static void buildTree(ClassLoaderVO parent, Map<String, List<ClassLoaderVO>> childMap) {
        List<ClassLoaderVO> children = childMap.get(parent.getName());
        if (children != null) {
            for (ClassLoaderVO child : children) {
                parent.addChild(child);
                ClassLoaderCommand.buildTree(child, childMap);
            }
        }
    }

    private static Set<ClassLoader> getAllClassLoaders(Instrumentation inst, Filter ... filters) {
        HashSet<ClassLoader> classLoaderSet = new HashSet<ClassLoader>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || !ClassLoaderCommand.shouldInclude(classLoader, filters)) continue;
            classLoaderSet.add(classLoader);
        }
        return classLoaderSet;
    }

    private static List<ClassLoaderInfo> getAllClassLoaderInfo(Instrumentation inst, Filter ... filters) {
        ClassLoader classLoader;
        ClassLoaderInfo bootstrapInfo = new ClassLoaderInfo(null);
        HashMap<ClassLoader, ClassLoaderInfo> loaderInfos = new HashMap<ClassLoader, ClassLoaderInfo>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                bootstrapInfo.increase();
                continue;
            }
            if (!ClassLoaderCommand.shouldInclude(classLoader, filters)) continue;
            ClassLoaderInfo loaderInfo = (ClassLoaderInfo)loaderInfos.get(classLoader);
            if (loaderInfo == null) {
                loaderInfo = new ClassLoaderInfo(classLoader);
                loaderInfos.put(classLoader, loaderInfo);
                for (ClassLoader parent = classLoader.getParent(); parent != null; parent = parent.getParent()) {
                    ClassLoaderInfo parentLoaderInfo = (ClassLoaderInfo)loaderInfos.get(parent);
                    if (parentLoaderInfo != null) continue;
                    parentLoaderInfo = new ClassLoaderInfo(parent);
                    loaderInfos.put(parent, parentLoaderInfo);
                }
            }
            loaderInfo.increase();
        }
        ArrayList<ClassLoaderInfo> sunClassLoaderList = new ArrayList<ClassLoaderInfo>();
        ArrayList<ClassLoaderInfo> otherClassLoaderList = new ArrayList<ClassLoaderInfo>();
        for (Map.Entry entry : loaderInfos.entrySet()) {
            classLoader = (ClassLoader)entry.getKey();
            if (classLoader.getClass().getName().startsWith("sun.")) {
                sunClassLoaderList.add((ClassLoaderInfo)entry.getValue());
                continue;
            }
            otherClassLoaderList.add((ClassLoaderInfo)entry.getValue());
        }
        Collections.sort(sunClassLoaderList);
        Collections.sort(otherClassLoaderList);
        ArrayList<ClassLoaderInfo> result = new ArrayList<ClassLoaderInfo>();
        result.add(bootstrapInfo);
        result.addAll(otherClassLoaderList);
        result.addAll(sunClassLoaderList);
        return result;
    }

    private static boolean shouldInclude(ClassLoader classLoader, Filter ... filters) {
        if (filters == null) {
            return true;
        }
        for (Filter filter : filters) {
            if (filter.accept(classLoader)) continue;
            return false;
        }
        return true;
    }

    private static class ClassLoaderInterruptHandler
    implements Handler<Void> {
        private ClassLoaderCommand command;

        public ClassLoaderInterruptHandler(ClassLoaderCommand command) {
            this.command = command;
        }

        @Override
        public void handle(Void event) {
            this.command.isInterrupted = true;
        }
    }

    private static class ValueComparator
    implements Comparator<String> {
        private Map<String, ClassLoaderStat> unsortedStats;

        ValueComparator(Map<String, ClassLoaderStat> stats) {
            this.unsortedStats = stats;
        }

        @Override
        public int compare(String o1, String o2) {
            if (null == this.unsortedStats) {
                return -1;
            }
            if (!this.unsortedStats.containsKey(o1)) {
                return 1;
            }
            if (!this.unsortedStats.containsKey(o2)) {
                return -1;
            }
            return this.unsortedStats.get(o2).getLoadedCount() - this.unsortedStats.get(o1).getLoadedCount();
        }
    }

    public static class ClassLoaderStat {
        private int loadedCount;
        private int numberOfInstance;

        void addLoadedCount(int count) {
            this.loadedCount += count;
        }

        void addNumberOfInstance(int count) {
            this.numberOfInstance += count;
        }

        public int getLoadedCount() {
            return this.loadedCount;
        }

        public int getNumberOfInstance() {
            return this.numberOfInstance;
        }
    }

    public static class ClassLoaderUrlStat {
        private Collection<String> usedUrls;
        private Collection<String> unUsedUrls;

        public ClassLoaderUrlStat() {
        }

        public ClassLoaderUrlStat(Collection<String> usedUrls, Collection<String> unUsedUrls) {
            this.usedUrls = usedUrls;
            this.unUsedUrls = unUsedUrls;
        }

        public Collection<String> getUsedUrls() {
            return this.usedUrls;
        }

        public void setUsedUrls(Collection<String> usedUrls) {
            this.usedUrls = usedUrls;
        }

        public Collection<String> getUnUsedUrls() {
            return this.unUsedUrls;
        }

        public void setUnUsedUrls(Collection<String> unUsedUrls) {
            this.unUsedUrls = unUsedUrls;
        }
    }

    private static class UrlClassStatBuilder {
        private final String url;
        private final boolean hasClassFilter;
        private final int limit;
        private int loadedClassCount;
        private int matchedClassCount;
        private SortedSet<String> classNames;
        private boolean truncated;

        UrlClassStatBuilder(String url, boolean hasClassFilter, int limit) {
            this.url = url;
            this.hasClassFilter = hasClassFilter;
            this.limit = limit;
            if (limit > 0) {
                this.classNames = new TreeSet<String>();
            }
        }

        void increaseLoadedCount() {
            ++this.loadedClassCount;
        }

        void increaseMatchedCount() {
            ++this.matchedClassCount;
        }

        int getMatchedClassCount() {
            return this.matchedClassCount;
        }

        void tryAddClass(String className) {
            if (this.classNames == null) {
                return;
            }
            if (this.classNames.size() >= this.limit) {
                this.truncated = true;
                return;
            }
            this.classNames.add(className);
        }

        UrlClassStat build() {
            UrlClassStat stat = new UrlClassStat();
            stat.setUrl(this.url);
            stat.setLoadedClassCount(this.loadedClassCount);
            if (this.hasClassFilter) {
                stat.setMatchedClassCount(this.matchedClassCount);
            }
            if (this.classNames != null) {
                stat.setClasses(new ArrayList<String>(this.classNames));
            }
            stat.setTruncated(this.truncated);
            return stat;
        }
    }

    public static class UrlClassStat {
        private String url;
        private int loadedClassCount;
        private Integer matchedClassCount;
        private List<String> classes;
        private boolean truncated;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getLoadedClassCount() {
            return this.loadedClassCount;
        }

        public void setLoadedClassCount(int loadedClassCount) {
            this.loadedClassCount = loadedClassCount;
        }

        public Integer getMatchedClassCount() {
            return this.matchedClassCount;
        }

        public void setMatchedClassCount(Integer matchedClassCount) {
            this.matchedClassCount = matchedClassCount;
        }

        public List<String> getClasses() {
            return this.classes;
        }

        public void setClasses(List<String> classes) {
            this.classes = classes;
        }

        public boolean isTruncated() {
            return this.truncated;
        }

        public void setTruncated(boolean truncated) {
            this.truncated = truncated;
        }
    }

    private static class SunReflectionClassLoaderFilter
    implements Filter {
        private static final List<String> REFLECTION_CLASSLOADERS = Arrays.asList("sun.reflect.DelegatingClassLoader", "jdk.internal.reflect.DelegatingClassLoader");

        private SunReflectionClassLoaderFilter() {
        }

        @Override
        public boolean accept(ClassLoader classLoader) {
            return !REFLECTION_CLASSLOADERS.contains(classLoader.getClass().getName());
        }
    }

    private static interface Filter {
        public boolean accept(ClassLoader var1);
    }

    private static class ClassLoaderInfo
    implements Comparable<ClassLoaderInfo> {
        private ClassLoader classLoader;
        private int loadedClassCount = 0;

        ClassLoaderInfo(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public String getName() {
            if (this.classLoader != null) {
                return this.classLoader.toString();
            }
            return "BootstrapClassLoader";
        }

        String hashCodeStr() {
            if (this.classLoader != null) {
                return "" + Integer.toHexString(this.classLoader.hashCode());
            }
            return "null";
        }

        void increase() {
            ++this.loadedClassCount;
        }

        int loadedClassCount() {
            return this.loadedClassCount;
        }

        ClassLoader parent() {
            return this.classLoader == null ? null : this.classLoader.getParent();
        }

        String parentStr() {
            if (this.classLoader == null) {
                return "null";
            }
            ClassLoader parent = this.classLoader.getParent();
            if (parent == null) {
                return "null";
            }
            return parent.toString();
        }

        @Override
        public int compareTo(ClassLoaderInfo other) {
            if (other == null) {
                return -1;
            }
            if (other.classLoader == null) {
                return -1;
            }
            if (this.classLoader == null) {
                return -1;
            }
            return this.classLoader.getClass().getName().compareTo(other.classLoader.getClass().getName());
        }
    }
}

