/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.LoggerModel;
import com.taobao.arthas.core.command.view.ClassLoaderView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;
import java.util.Map;

public class LoggerView
extends ResultView<LoggerModel> {
    @Override
    public void draw(CommandProcess process, LoggerModel result) {
        if (result.getMatchedClassLoaders() != null) {
            process.write("Matched classloaders: \n");
            ClassLoaderView.drawClassLoaders(process, result.getMatchedClassLoaders(), false);
            process.write("\n");
            return;
        }
        process.write(this.renderLoggerInfo(result.getLoggerInfoMap(), process.width()));
    }

    private String renderLoggerInfo(Map<String, Map<String, Object>> loggerInfos, int width) {
        StringBuilder sb = new StringBuilder(8192);
        for (Map.Entry<String, Map<String, Object>> entry : loggerInfos.entrySet()) {
            Map<String, Object> info = entry.getValue();
            TableElement table = new TableElement(new int[]{2, 10}).leftCellPadding(1).rightCellPadding(1);
            TableElement appendersTable = new TableElement().rightCellPadding(1);
            Class clazz = (Class)info.get("class");
            table.row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)("" + info.get("name")))}).row(new Element[]{Element.label((String)"class").style(Decoration.bold.bold()), Element.label((String)("" + clazz.getName()))}).row(new Element[]{Element.label((String)"classLoader").style(Decoration.bold.bold()), Element.label((String)("" + info.get("classLoader")))}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)("" + info.get("classLoaderHash")))}).row(new Element[]{Element.label((String)"level").style(Decoration.bold.bold()), Element.label((String)("" + info.get("level")))});
            if (info.get("effectiveLevel") != null) {
                table.row(new Element[]{Element.label((String)"effectiveLevel").style(Decoration.bold.bold()), Element.label((String)("" + info.get("effectiveLevel")))});
            }
            if (info.get("config") != null) {
                table.row(new Element[]{Element.label((String)"config").style(Decoration.bold.bold()), Element.label((String)("" + info.get("config")))});
            }
            table.row(new Element[]{Element.label((String)"additivity").style(Decoration.bold.bold()), Element.label((String)("" + info.get("additivity")))}).row(new Element[]{Element.label((String)"codeSource").style(Decoration.bold.bold()), Element.label((String)("" + info.get("codeSource")))});
            List appenders = (List)info.get("appenders");
            if (appenders != null && !appenders.isEmpty()) {
                for (Map appenderInfo : appenders) {
                    Class appenderClass = (Class)appenderInfo.get("class");
                    appendersTable.row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)("" + appenderInfo.get("name")))});
                    appendersTable.row(new Element[]{Element.label((String)"class"), Element.label((String)("" + appenderClass.getName()))});
                    appendersTable.row(new Element[]{Element.label((String)"classLoader"), Element.label((String)("" + info.get("classLoader")))});
                    appendersTable.row(new Element[]{Element.label((String)"classLoaderHash"), Element.label((String)("" + info.get("classLoaderHash")))});
                    if (appenderInfo.get("file") != null) {
                        appendersTable.row(new Element[]{Element.label((String)"file"), Element.label((String)("" + appenderInfo.get("file")))});
                    }
                    if (appenderInfo.get("target") != null) {
                        appendersTable.row(new Element[]{Element.label((String)"target"), Element.label((String)("" + appenderInfo.get("target")))});
                    }
                    if (appenderInfo.get("blocking") != null) {
                        appendersTable.row(new Element[]{Element.label((String)"blocking"), Element.label((String)("" + appenderInfo.get("blocking")))});
                    }
                    if (appenderInfo.get("appenderRef") == null) continue;
                    appendersTable.row(new Element[]{Element.label((String)"appenderRef"), Element.label((String)("" + appenderInfo.get("appenderRef")))});
                }
                table.row(new Element[]{Element.label((String)"appenders").style(Decoration.bold.bold()), appendersTable});
            }
            sb.append(RenderUtil.render((Element)table, (int)width)).append('\n');
        }
        return sb.toString();
    }
}

