/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.view;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.Ansi;
import com.taobao.arthas.core.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeView
implements View {
    private static final String STEP_FIRST_CHAR = "`---";
    private static final String STEP_NORMAL_CHAR = "+---";
    private static final String STEP_HAS_BOARD = "|   ";
    private static final String STEP_EMPTY_BOARD = "    ";
    private static final String TIME_UNIT = "ms";
    private final boolean isPrintCost;
    private final Node root;
    private Node current;
    private Node maxCost;

    public TreeView(boolean isPrintCost, String title) {
        this.current = this.root = new Node(title).markBegin().markEnd();
        this.isPrintCost = isPrintCost;
    }

    @Override
    public String draw() {
        this.findMaxCostNode(this.root);
        final StringBuilder treeSB = new StringBuilder();
        final Ansi highlighted = Ansi.ansi().fg(Ansi.Color.RED);
        this.recursive(0, true, "", this.root, new Callback(){

            @Override
            public void callback(int deep, boolean isLast, String prefix, Node node) {
                treeSB.append(prefix).append(isLast ? TreeView.STEP_FIRST_CHAR : TreeView.STEP_NORMAL_CHAR);
                if (TreeView.this.isPrintCost && !node.isRoot()) {
                    if (node == TreeView.this.maxCost) {
                        treeSB.append(highlighted.a(node.toString()).reset().toString());
                    } else {
                        treeSB.append(node.toString());
                    }
                }
                treeSB.append(node.data);
                if (!StringUtils.isBlank(node.mark)) {
                    treeSB.append(" [").append(node.mark).append(node.marks > 1L ? "," + node.marks : "").append("]");
                }
                treeSB.append("\n");
            }
        });
        return treeSB.toString();
    }

    private void recursive(int deep, boolean isLast, String prefix, Node node, Callback callback) {
        callback.callback(deep, isLast, prefix, node);
        if (!node.isLeaf()) {
            int size = node.children.size();
            for (int index = 0; index < size; ++index) {
                boolean isLastFlag = index == size - 1;
                String currentPrefix = isLast ? prefix + STEP_EMPTY_BOARD : prefix + STEP_HAS_BOARD;
                this.recursive(deep + 1, isLastFlag, currentPrefix, node.children.get(index), callback);
            }
        }
    }

    private void findMaxCostNode(Node node) {
        if (!node.isRoot() && !node.parent.isRoot()) {
            if (this.maxCost == null) {
                this.maxCost = node;
            } else if (this.maxCost.totalCost < node.totalCost) {
                this.maxCost = node;
            }
        }
        if (!node.isLeaf()) {
            for (Node n : node.children) {
                this.findMaxCostNode(n);
            }
        }
    }

    public TreeView begin(String data) {
        Node n = this.current.find(data);
        this.current = n != null ? n : new Node(this.current, data);
        this.current.markBegin();
        return this;
    }

    public TreeView end() {
        if (this.current.isRoot()) {
            throw new IllegalStateException("current node is root.");
        }
        this.current.markEnd();
        this.current = this.current.parent;
        return this;
    }

    public TreeView end(String mark) {
        if (this.current.isRoot()) {
            throw new IllegalStateException("current node is root.");
        }
        this.current.markEnd().mark(mark);
        this.current = this.current.parent;
        return this;
    }

    private static interface Callback {
        public void callback(int var1, boolean var2, String var3, Node var4);
    }

    private static class Node {
        final Node parent;
        final String data;
        final List<Node> children = new ArrayList<Node>();
        final Map<String, Node> map = new HashMap<String, Node>();
        private long beginTimestamp;
        private long endTimestamp;
        private String mark;
        private long minCost = Long.MAX_VALUE;
        private long maxCost = Long.MIN_VALUE;
        private long totalCost = 0L;
        private long times = 0L;
        private long marks = 0L;

        private Node(String data) {
            this.parent = null;
            this.data = data;
        }

        private Node(Node parent, String data) {
            this.parent = parent;
            this.data = data;
            parent.children.add(this);
            parent.map.put(data, this);
        }

        Node find(String data) {
            return this.map.get(data);
        }

        boolean isRoot() {
            return null == this.parent;
        }

        boolean isLeaf() {
            return this.children.isEmpty();
        }

        Node markBegin() {
            this.beginTimestamp = System.nanoTime();
            return this;
        }

        Node markEnd() {
            this.endTimestamp = System.nanoTime();
            long cost = this.getCost();
            if (cost < this.minCost) {
                this.minCost = cost;
            }
            if (cost > this.maxCost) {
                this.maxCost = cost;
            }
            ++this.times;
            this.totalCost += cost;
            return this;
        }

        Node mark(String mark) {
            this.mark = mark;
            ++this.marks;
            return this;
        }

        long getCost() {
            return this.endTimestamp - this.beginTimestamp;
        }

        double getCostInMillis(long nanoSeconds) {
            return (double)nanoSeconds / 1000000.0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.times <= 1L) {
                sb.append("[").append(this.getCostInMillis(this.getCost())).append(TreeView.TIME_UNIT).append("] ");
            } else {
                sb.append("[min=").append(this.getCostInMillis(this.minCost)).append(TreeView.TIME_UNIT).append(",max=").append(this.getCostInMillis(this.maxCost)).append(TreeView.TIME_UNIT).append(",total=").append(this.getCostInMillis(this.totalCost)).append(TreeView.TIME_UNIT).append(",count=").append(this.times).append("] ");
            }
            return sb.toString();
        }
    }
}

