/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.impl;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.security.AuthUtils;
import com.taobao.arthas.core.security.SecurityAuthenticator;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.Shell;
import com.taobao.arthas.core.shell.ShellServer;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.CliTokens;
import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.shell.CloseHandler;
import com.taobao.arthas.core.shell.handlers.shell.CommandManagerCompletionHandler;
import com.taobao.arthas.core.shell.handlers.shell.FutureHandler;
import com.taobao.arthas.core.shell.handlers.shell.InterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.ShellLineHandler;
import com.taobao.arthas.core.shell.handlers.shell.SuspendHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.session.impl.SessionImpl;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobController;
import com.taobao.arthas.core.shell.system.JobListener;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.impl.TermImpl;
import com.taobao.arthas.core.shell.term.impl.http.ExtHttpTtyConnection;
import com.taobao.arthas.core.util.Constants;
import com.taobao.arthas.core.util.FileUtils;
import io.netty.channel.ChannelHandlerContext;
import io.termd.core.telnet.TelnetConnection;
import io.termd.core.telnet.TelnetTtyConnection;
import io.termd.core.telnet.netty.NettyTelnetConnection;
import io.termd.core.tty.TtyConnection;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class ShellImpl
implements Shell {
    private static final Logger logger = LoggerFactory.getLogger(ShellImpl.class);
    private SecurityAuthenticator securityAuthenticator = ArthasBootstrap.getInstance().getSecurityAuthenticator();
    private JobControllerImpl jobController;
    final String id;
    final Future<Void> closedFuture;
    private InternalCommandManager commandManager;
    private Session session = new SessionImpl();
    private Term term;
    private String welcome;
    private Job currentForegroundJob;
    private String prompt;

    public ShellImpl(ShellServer server, Term term, InternalCommandManager commandManager, Instrumentation instrumentation, long pid, JobControllerImpl jobController) {
        if (term instanceof TermImpl) {
            ChannelHandlerContext handlerContext;
            Principal principal;
            TelnetConnection telnetConnection;
            TermImpl termImpl = (TermImpl)term;
            TtyConnection conn = termImpl.getConn();
            if (conn instanceof TelnetTtyConnection && (telnetConnection = ((TelnetTtyConnection)conn).getTelnetConnection()) instanceof NettyTelnetConnection && (principal = AuthUtils.localPrincipal(handlerContext = ((NettyTelnetConnection)telnetConnection).channelHandlerContext())) != null) {
                try {
                    Subject subject = this.securityAuthenticator.login(principal);
                    if (subject != null) {
                        this.session.put("subject", subject);
                    }
                }
                catch (LoginException e) {
                    logger.error("local connection auth error", (Throwable)e);
                }
            }
            if (conn instanceof ExtHttpTtyConnection) {
                ExtHttpTtyConnection extConn = (ExtHttpTtyConnection)conn;
                Map<String, Object> extSessions = extConn.extSessions();
                for (Map.Entry<String, Object> entry : extSessions.entrySet()) {
                    this.session.put(entry.getKey(), entry.getValue());
                }
            }
        }
        this.session.put("arthas-command-manager", commandManager);
        this.session.put("instrumentation", instrumentation);
        this.session.put("pid", pid);
        this.session.put("server", server);
        this.session.put("tty", term);
        this.id = UUID.randomUUID().toString();
        this.session.put("id", this.id);
        this.commandManager = commandManager;
        this.closedFuture = Future.future();
        this.term = term;
        this.jobController = jobController;
        if (term != null) {
            term.setSession(this.session);
        }
        this.setPrompt();
    }

    @Override
    public JobController jobController() {
        return this.jobController;
    }

    public Set<Job> jobs() {
        return this.jobController.jobs();
    }

    @Override
    public synchronized Job createJob(List<CliToken> args) {
        Job job = this.jobController.createJob(this.commandManager, args, this.session, new ShellJobHandler(this), this.term, null);
        return job;
    }

    @Override
    public Job createJob(String line) {
        return this.createJob(CliTokens.tokenize(line));
    }

    @Override
    public Session session() {
        return this.session;
    }

    public Term term() {
        return this.term;
    }

    public FutureHandler closedFutureHandler() {
        return new FutureHandler(this.closedFuture);
    }

    public long lastAccessedTime() {
        return this.term.lastAccessedTime();
    }

    public void setWelcome(String welcome) {
        this.welcome = welcome;
    }

    private void setPrompt() {
        this.prompt = "[arthas@" + this.session.getPid() + "]$ ";
    }

    public ShellImpl init() {
        this.term.interruptHandler(new InterruptHandler(this));
        this.term.suspendHandler(new SuspendHandler(this));
        this.term.closeHandler(new CloseHandler(this));
        if (this.welcome != null && this.welcome.length() > 0) {
            this.term.write(this.welcome + "\n");
        }
        return this;
    }

    public String statusLine(Job job, ExecStatus status) {
        Date timeoutDate;
        StringBuilder sb = new StringBuilder("[").append(job.id()).append("]");
        if (this.session().equals(job.getSession())) {
            sb.append("*");
        }
        sb.append("\n");
        sb.append("       ").append(Character.toUpperCase(status.name().charAt(0))).append(status.name().substring(1).toLowerCase());
        sb.append("           ").append(job.line()).append("\n");
        sb.append("       execution count : ").append(job.process().times()).append("\n");
        sb.append("       start time      : ").append(job.process().startTime()).append("\n");
        String cacheLocation = job.process().cacheLocation();
        if (cacheLocation != null) {
            sb.append("       cache location  : ").append(cacheLocation).append("\n");
        }
        if ((timeoutDate = job.timeoutDate()) != null) {
            sb.append("       timeout date    : ").append(timeoutDate).append("\n");
        }
        sb.append("       session         : ").append(job.getSession().getSessionId()).append(this.session.equals(job.getSession()) ? " (current)" : "").append("\n");
        return sb.toString();
    }

    public void readline() {
        this.term.readline(this.prompt, new ShellLineHandler(this), new CommandManagerCompletionHandler(this.commandManager));
    }

    @Override
    public void close(String reason) {
        if (this.term != null) {
            try {
                this.term.write("session (" + this.session.getSessionId() + ") is closed because " + reason + "\n");
            }
            catch (Throwable t) {
                logger.error("Error writing data:", t);
            }
            this.term.close();
        } else {
            this.jobController.close(this.closedFutureHandler());
        }
    }

    public void setForegroundJob(Job job) {
        this.currentForegroundJob = job;
    }

    public Job getForegroundJob() {
        return this.currentForegroundJob;
    }

    private static class ShellJobHandler
    implements JobListener {
        ShellImpl shell;

        public ShellJobHandler(ShellImpl shell) {
            this.shell = shell;
        }

        @Override
        public void onForeground(Job job) {
            this.shell.setForegroundJob(job);
        }

        @Override
        public void onBackground(Job job) {
            this.resetAndReadLine();
        }

        @Override
        public void onTerminated(Job job) {
            Term term;
            if (!job.isRunInBackground()) {
                this.resetAndReadLine();
            }
            if ((term = this.shell.term()) instanceof TermImpl) {
                List history = ((TermImpl)term).getReadline().getHistory();
                FileUtils.saveCommandHistory(history, new File(Constants.CMD_HISTORY_FILE));
            }
        }

        @Override
        public void onSuspend(Job job) {
            if (!job.isRunInBackground()) {
                this.resetAndReadLine();
            }
        }

        private void resetAndReadLine() {
            this.shell.setForegroundJob(null);
            this.shell.readline();
        }
    }
}

