/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.future;

import com.taobao.arthas.core.shell.handlers.Handler;

public class Future<T> {
    private boolean failed;
    private boolean succeeded;
    private Handler<Future<T>> handler;
    private T result;
    private Throwable throwable;

    public Future() {
    }

    public Future(Throwable t) {
        this.fail(t);
    }

    public Future(String failureMessage) {
        this(new Throwable(failureMessage));
    }

    public Future(T result) {
        this.complete(result);
    }

    public static <T> Future<T> future() {
        return new Future<T>();
    }

    public static <T> Future<T> succeededFuture() {
        return new Future<Object>(null);
    }

    public static <T> Future<T> succeededFuture(T result) {
        return new Future<T>(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return new Future<T>(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return new Future<T>(failureMessage);
    }

    public boolean isComplete() {
        return this.failed || this.succeeded;
    }

    public Future<T> setHandler(Handler<Future<T>> handler) {
        this.handler = handler;
        this.checkCallHandler();
        return this;
    }

    public void complete(T result) {
        this.checkComplete();
        this.result = result;
        this.succeeded = true;
        this.checkCallHandler();
    }

    public void complete() {
        this.complete(null);
    }

    public void fail(Throwable throwable) {
        this.checkComplete();
        this.throwable = throwable;
        this.failed = true;
        this.checkCallHandler();
    }

    public void fail(String failureMessage) {
        this.fail(new Throwable(failureMessage));
    }

    public T result() {
        return this.result;
    }

    public Throwable cause() {
        return this.throwable;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public boolean failed() {
        return this.failed;
    }

    public Handler<Future<T>> completer() {
        return new Handler<Future<T>>(){

            @Override
            public void handle(Future<T> ar) {
                if (ar.succeeded()) {
                    Future.this.complete(ar.result());
                } else {
                    Future.this.fail(ar.cause());
                }
            }
        };
    }

    private void checkCallHandler() {
        if (this.handler != null && this.isComplete()) {
            this.handler.handle(this);
        }
    }

    private void checkComplete() {
        if (this.succeeded || this.failed) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }
}

