/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.StackModel;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.DateUtils;
import com.taobao.arthas.core.util.ThreadUtil;

public class StackView
extends ResultView<StackModel> {
    @Override
    public void draw(CommandProcess process, StackModel result) {
        int skip;
        StringBuilder sb = new StringBuilder();
        sb.append(ThreadUtil.getThreadTitle(result)).append("\n");
        StackTraceElement[] stackTraceElements = result.getStackTrace();
        StackTraceElement locationStackTraceElement = stackTraceElements[0];
        String locationString = String.format("    @%s.%s()", locationStackTraceElement.getClassName(), locationStackTraceElement.getMethodName());
        sb.append(locationString).append("\n");
        for (int index = skip = 1; index < stackTraceElements.length; ++index) {
            StackTraceElement ste = stackTraceElements[index];
            sb.append("        at ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
        }
        process.write("ts=" + DateUtils.formatDateTime(result.getTs()) + ";" + sb.toString() + "\n");
    }
}

