/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.cli.impl;

import com.taobao.arthas.core.shell.cli.CliToken;
import io.termd.core.readline.LineStatus;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CliTokenImpl
implements CliToken {
    private static final String PIPE = "|";
    private static final String REDIRECT = ">";
    private static final String REDIRECT_APPEND = ">>";
    final boolean text;
    final String raw;
    final String value;

    public CliTokenImpl(boolean text, String value) {
        this(text, value, value);
    }

    public CliTokenImpl(boolean text, String raw, String value) {
        this.text = text;
        this.raw = raw;
        this.value = value;
    }

    @Override
    public boolean isText() {
        return this.text;
    }

    @Override
    public boolean isBlank() {
        return !this.text;
    }

    @Override
    public String raw() {
        return this.raw;
    }

    @Override
    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CliTokenImpl) {
            CliTokenImpl that = (CliTokenImpl)obj;
            return this.text == that.text && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return "CliToken[text=" + this.text + ",value=" + this.value + "]";
    }

    public static List<CliToken> tokenize(String s) {
        List<CliToken> tokens = new LinkedList<CliToken>();
        CliTokenImpl.tokenize(s, 0, tokens);
        tokens = CliTokenImpl.adjustTokensForSpecialSymbols(tokens);
        return tokens;
    }

    private static List<CliToken> adjustTokensForSpecialSymbols(List<CliToken> tokens) {
        return CliTokenImpl.separateLeadingAndTailingSymbol(tokens, PIPE, REDIRECT_APPEND, REDIRECT);
    }

    private static List<CliToken> separateLeadingAndTailingSymbol(List<CliToken> tokens, String ... symbols) {
        ArrayList<CliToken> adjustedTokens = new ArrayList<CliToken>();
        for (CliToken token : tokens) {
            String value = token.value();
            String raw = token.raw();
            boolean handled = false;
            for (String symbol : symbols) {
                if (value.equals(symbol)) break;
                if (value.endsWith(symbol)) {
                    handled = true;
                    int lastIndexOfSymbol = raw.lastIndexOf(symbol);
                    adjustedTokens.add(new CliTokenImpl(token.isText(), raw.substring(0, lastIndexOfSymbol), value.substring(0, value.length() - symbol.length())));
                    adjustedTokens.add(new CliTokenImpl(true, raw.substring(lastIndexOfSymbol), symbol));
                    break;
                }
                if (!value.startsWith(symbol)) continue;
                handled = true;
                int firstIndexOfSymbol = raw.indexOf(symbol);
                adjustedTokens.add(new CliTokenImpl(true, raw.substring(0, firstIndexOfSymbol + symbol.length()), symbol));
                adjustedTokens.add(new CliTokenImpl(token.isText(), raw.substring(firstIndexOfSymbol + symbol.length()), value.substring(symbol.length())));
                break;
            }
            if (handled) continue;
            adjustedTokens.add(token);
        }
        return adjustedTokens;
    }

    private static void tokenize(String s, int index, List<CliToken> builder) {
        block3: while (index < s.length()) {
            char c = s.charAt(index);
            switch (c) {
                case '\t': 
                case ' ': {
                    index = CliTokenImpl.blankToken(s, index, builder);
                    continue block3;
                }
            }
            index = CliTokenImpl.textToken(s, index, builder);
        }
    }

    private static int textToken(String s, int index, List<CliToken> builder) {
        LineStatus quoter = new LineStatus();
        int from = index;
        StringBuilder value = new StringBuilder();
        while (index < s.length()) {
            char c = s.charAt(index);
            quoter.accept((int)c);
            if (!quoter.isQuoted() && !quoter.isEscaped() && CliTokenImpl.isBlank(c)) break;
            if (quoter.isCodePoint()) {
                if (quoter.isEscaped() && quoter.isWeaklyQuoted() && c != '\"') {
                    value.append('\\');
                }
                value.append(c);
            }
            ++index;
        }
        builder.add(new CliTokenImpl(true, s.substring(from, index), value.toString()));
        return index;
    }

    private static int blankToken(String s, int index, List<CliToken> builder) {
        int from = index;
        while (index < s.length() && CliTokenImpl.isBlank(s.charAt(index))) {
            ++index;
        }
        builder.add(new CliTokenImpl(false, s.substring(from, index)));
        return index;
    }

    private static boolean isBlank(char c) {
        return c == ' ' || c == '\t';
    }
}

