/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.ObjectVO;
import com.taobao.arthas.core.command.model.RowAffectModel;
import com.taobao.arthas.core.command.model.TimeFragmentVO;
import com.taobao.arthas.core.command.model.TimeTunnelModel;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.TimeFragment;
import com.taobao.arthas.core.command.monitor200.TimeTunnelAdviceListener;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Name(value="tt")
@Summary(value="Time Tunnel")
@Description(value="  The express may be one of the following expression (evaluated dynamically):\n          target : the object\n           clazz : the object's class\n          method : the constructor or method\n          params : the parameters array of method\n    params[0..n] : the element of parameters array\n       returnObj : the returned object of method\n        throwExp : the throw exception of method\n        isReturn : the method ended by return\n         isThrow : the method ended by throwing exception\n           #cost : the execution time in ms of method invocation\nEXAMPLES:\n  tt -t *StringUtils isEmpty\n  tt -t *StringUtils isEmpty params[0].length==1\n  tt -l\n  tt -i 1000\n  tt -i 1000 -w params[0]\n  tt -i 1000 -p \n  tt -i 1000 -p --replay-times 3 --replay-interval 3000\n  tt -s '{params[0] > 1}' -w '{params}' \n  tt --delete-all\n\nWIKI:\n  https://arthas.aliyun.com/3.x/doc/tt")
public class TimeTunnelCommand
extends EnhancerCommand {
    private static final Map<Integer, TimeFragment> timeFragmentMap = new LinkedHashMap<Integer, TimeFragment>();
    private static final AtomicInteger sequence = new AtomicInteger(1000);
    private boolean isTimeTunnel = false;
    private String classPattern;
    private String methodPattern;
    private String conditionExpress;
    private boolean isList = false;
    private boolean isDeleteAll = false;
    private Integer index;
    private Integer expand = 1;
    private Integer sizeLimit = 0xA00000;
    private String watchExpress = "";
    private String searchExpress = "";
    private boolean isPlay = false;
    private boolean isDelete = false;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;
    private int replayTimes = 1;
    private long replayInterval = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(TimeTunnelCommand.class);

    @Argument(index=0, argName="class-pattern", required=false)
    @Description(value="Path and classname of Pattern Matching")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(index=1, argName="method-pattern", required=false)
    @Description(value="Method of Pattern Matching")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(index=2, argName="condition-express", required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n  '#cost>100'\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="t", longName="time-tunnel", flag=true)
    @Description(value="Record the method invocation within time fragments")
    public void setTimeTunnel(boolean timeTunnel) {
        this.isTimeTunnel = timeTunnel;
    }

    @Option(shortName="l", longName="list", flag=true)
    @Description(value="List all the time fragments")
    public void setList(boolean list) {
        this.isList = list;
    }

    @Option(longName="delete-all", flag=true)
    @Description(value="Delete all the time fragments")
    public void setDeleteAll(boolean deleteAll) {
        this.isDeleteAll = deleteAll;
    }

    @Option(shortName="i", longName="index")
    @Description(value="Display the detailed information from specified time fragment")
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default)")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    @Option(shortName="M", longName="sizeLimit")
    @Description(value="Upper size limit in bytes for the result (10 * 1024 * 1024 by default)")
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Option(shortName="w", longName="watch-express")
    @Description(value="watch the time fragment by ognl express.\nExamples:\n  params\n  params[0]\n  'params[0]+params[1]'\n  '{params[0], target, returnObj}'\n  returnObj\n  throwExp\n  target\n  clazz\n  method\n")
    public void setWatchExpress(String watchExpress) {
        this.watchExpress = watchExpress;
    }

    @Option(shortName="s", longName="search-express")
    @Description(value="Search-expression, to search the time fragments by ognl express.\nThe structure of 'advice' like conditional expression")
    public void setSearchExpress(String searchExpress) {
        this.searchExpress = searchExpress;
    }

    @Option(shortName="p", longName="play", flag=true)
    @Description(value="Replay the time fragment specified by index")
    public void setPlay(boolean play) {
        this.isPlay = play;
    }

    @Option(shortName="d", longName="delete", flag=true)
    @Description(value="Delete time fragment specified by index")
    public void setDelete(boolean delete) {
        this.isDelete = delete;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times, default value 100")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    @Option(longName="replay-times")
    @Description(value="execution times when play tt")
    public void setReplayTimes(int replayTimes) {
        this.replayTimes = replayTimes;
    }

    @Option(longName="replay-interval")
    @Description(value="replay interval  for  play tt with option r greater than 1")
    public void setReplayInterval(int replayInterval) {
        this.replayInterval = replayInterval;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    public int getReplayTimes() {
        return this.replayTimes;
    }

    public long getReplayInterval() {
        return this.replayInterval;
    }

    public Integer getExpand() {
        return this.expand;
    }

    private boolean hasWatchExpress() {
        return !StringUtils.isEmpty(this.watchExpress);
    }

    private boolean hasSearchExpress() {
        return !StringUtils.isEmpty(this.searchExpress);
    }

    private void checkArguments() {
        if ((this.isDelete || this.isPlay) && null == this.index) {
            throw new IllegalArgumentException("Time fragment index is expected, please type -i to specify");
        }
        if (this.isTimeTunnel) {
            if (StringUtils.isEmpty(this.classPattern)) {
                throw new IllegalArgumentException("Class-pattern is expected, please type the wildcard expression to match");
            }
            if (StringUtils.isEmpty(this.methodPattern)) {
                throw new IllegalArgumentException("Method-pattern is expected, please type the wildcard expression to match");
            }
        }
        if (null == this.index && !this.isTimeTunnel && !this.isDeleteAll && StringUtils.isEmpty(this.watchExpress) && !this.isList && StringUtils.isEmpty(this.searchExpress)) {
            throw new IllegalArgumentException("Argument(s) is/are expected, type 'help tt' to read usage");
        }
    }

    int putTimeTunnel(TimeFragment tt) {
        int indexOfSeq = sequence.getAndIncrement();
        timeFragmentMap.put(indexOfSeq, tt);
        return indexOfSeq;
    }

    @Override
    public void process(CommandProcess process) {
        this.checkArguments();
        process.interruptHandler(new CommandInterruptHandler(process));
        process.stdinHandler(new QExitHandler(process));
        if (this.isTimeTunnel) {
            this.enhance(process);
        } else if (this.isPlay) {
            this.processPlay(process);
        } else if (this.isList) {
            this.processList(process);
        } else if (this.isDeleteAll) {
            this.processDeleteAll(process);
        } else if (this.isDelete) {
            this.processDelete(process);
        } else if (this.hasSearchExpress()) {
            this.processSearch(process);
        } else if (this.index != null) {
            if (this.hasWatchExpress()) {
                this.processWatch(process);
            } else {
                this.processShow(process);
            }
        }
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getClassNameExcludeMatcher() {
        if (this.classNameExcludeMatcher == null && this.getExcludeClassPattern() != null) {
            this.classNameExcludeMatcher = SearchUtils.classNameMatcher(this.getExcludeClassPattern(), this.isRegEx());
        }
        return this.classNameExcludeMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        return new TimeTunnelAdviceListener(this, process, GlobalOptions.verbose || this.verbose);
    }

    private void processShow(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            TimeFragment tf = timeFragmentMap.get(this.index);
            if (null == tf) {
                process.end(1, String.format("Time fragment[%d] does not exist.", this.index));
                return;
            }
            TimeFragmentVO timeFragmentVO = TimeTunnelCommand.createTimeFragmentVO(this.index, tf, this.expand);
            TimeTunnelModel timeTunnelModel = new TimeTunnelModel().setTimeFragment(timeFragmentVO).setExpand(this.expand).setSizeLimit(this.sizeLimit);
            process.appendResult(timeTunnelModel);
            affect.rCnt(1);
            process.appendResult(new RowAffectModel(affect));
            process.end();
        }
        catch (Throwable e) {
            logger.warn("tt failed.", e);
            process.end(1, e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more detail");
        }
    }

    private void processWatch(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            TimeFragment tf = timeFragmentMap.get(this.index);
            if (null == tf) {
                process.end(1, String.format("Time fragment[%d] does not exist.", this.index));
                return;
            }
            Advice advice = tf.getAdvice();
            Object value = ExpressFactory.unpooledExpress(advice.getLoader()).bind(advice).get(this.watchExpress);
            TimeTunnelModel timeTunnelModel = new TimeTunnelModel().setWatchValue(new ObjectVO(value, this.expand)).setExpand(this.expand).setSizeLimit(this.sizeLimit);
            process.appendResult(timeTunnelModel);
            affect.rCnt(1);
            process.appendResult(new RowAffectModel(affect));
            process.end();
        }
        catch (ExpressException e) {
            logger.warn("tt failed.", (Throwable)e);
            process.end(1, e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more detail");
        }
    }

    private void processSearch(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            LinkedHashMap<Integer, TimeFragment> matchingTimeSegmentMap = new LinkedHashMap<Integer, TimeFragment>();
            for (Map.Entry<Integer, TimeFragment> entry : timeFragmentMap.entrySet()) {
                int n = entry.getKey();
                TimeFragment tf = entry.getValue();
                Advice advice = tf.getAdvice();
                if (!ExpressFactory.threadLocalExpress(advice).is(this.searchExpress)) continue;
                matchingTimeSegmentMap.put(n, tf);
            }
            if (this.hasWatchExpress()) {
                LinkedHashMap<Integer, ObjectVO> searchResults = new LinkedHashMap<Integer, ObjectVO>();
                for (Map.Entry entry : matchingTimeSegmentMap.entrySet()) {
                    Object value = ExpressFactory.threadLocalExpress(((TimeFragment)entry.getValue()).getAdvice()).get(this.watchExpress);
                    searchResults.put((Integer)entry.getKey(), new ObjectVO(value, this.expand));
                }
                TimeTunnelModel timeTunnelModel = new TimeTunnelModel().setWatchResults(searchResults).setExpand(this.expand).setSizeLimit(this.sizeLimit);
                process.appendResult(timeTunnelModel);
            } else {
                List<TimeFragmentVO> timeFragmentList = this.createTimeTunnelVOList(matchingTimeSegmentMap);
                process.appendResult(new TimeTunnelModel().setTimeFragmentList(timeFragmentList).setFirst(true));
            }
            affect.rCnt(matchingTimeSegmentMap.size());
            process.appendResult(new RowAffectModel(affect));
            process.end();
        }
        catch (ExpressException e) {
            logger.warn("tt failed.", (Throwable)e);
            process.end(1, e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more detail");
        }
    }

    private void processDelete(CommandProcess process) {
        RowAffect affect = new RowAffect();
        if (timeFragmentMap.remove(this.index) != null) {
            affect.rCnt(1);
        }
        process.appendResult(new MessageModel(String.format("Time fragment[%d] successfully deleted.", this.index)));
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processDeleteAll(CommandProcess process) {
        int count = timeFragmentMap.size();
        RowAffect affect = new RowAffect(count);
        timeFragmentMap.clear();
        process.appendResult(new MessageModel("Time fragments are cleaned."));
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processList(CommandProcess process) {
        RowAffect affect = new RowAffect();
        List<TimeFragmentVO> timeFragmentList = this.createTimeTunnelVOList(timeFragmentMap);
        process.appendResult(new TimeTunnelModel().setTimeFragmentList(timeFragmentList).setFirst(true));
        affect.rCnt(timeFragmentMap.size());
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private List<TimeFragmentVO> createTimeTunnelVOList(Map<Integer, TimeFragment> timeFragmentMap) {
        ArrayList<TimeFragmentVO> timeFragmentList = new ArrayList<TimeFragmentVO>(timeFragmentMap.size());
        for (Map.Entry<Integer, TimeFragment> entry : timeFragmentMap.entrySet()) {
            timeFragmentList.add(TimeTunnelCommand.createTimeFragmentVO(entry.getKey(), entry.getValue(), this.expand));
        }
        return timeFragmentList;
    }

    public static TimeFragmentVO createTimeFragmentVO(Integer index, TimeFragment tf, Integer expand) {
        Advice advice = tf.getAdvice();
        String object = advice.getTarget() == null ? "NULL" : "0x" + Integer.toHexString(advice.getTarget().hashCode());
        return new TimeFragmentVO().setIndex(index).setTimestamp(tf.getGmtCreate()).setCost(tf.getCost()).setParams(ObjectVO.array(advice.getParams(), expand)).setReturn(advice.isAfterReturning()).setReturnObj(new ObjectVO(advice.getReturnObj(), expand)).setThrow(advice.isAfterThrowing()).setThrowExp(new ObjectVO(advice.getThrowExp(), expand)).setObject(object).setClassName(advice.getClazz().getName()).setMethodName(advice.getMethod().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlay(CommandProcess process) {
        TimeFragment tf = timeFragmentMap.get(this.index);
        if (null == tf) {
            process.end(1, String.format("Time fragment[%d] does not exist.", this.index));
            return;
        }
        Advice advice = tf.getAdvice();
        ArthasMethod method = advice.getMethod();
        boolean accessible = advice.getMethod().isAccessible();
        try {
            if (!accessible) {
                method.setAccessible(true);
            }
            for (int i = 0; i < this.getReplayTimes(); ++i) {
                double cost;
                if (i > 0) {
                    Thread.sleep(this.getReplayInterval());
                    if (!process.isRunning()) {
                        return;
                    }
                }
                long beginTime = System.nanoTime();
                TimeFragmentVO replayResult = TimeTunnelCommand.createTimeFragmentVO(this.index, tf, this.expand);
                replayResult.setTimestamp(new Date()).setCost(0.0).setReturn(false).setReturnObj(null).setThrow(false).setThrowExp(null);
                try {
                    Object returnObj = method.invoke(advice.getTarget(), advice.getParams());
                    cost = (double)(System.nanoTime() - beginTime) / 1000000.0;
                    replayResult.setCost(cost).setReturn(true).setReturnObj(new ObjectVO(returnObj, this.expand));
                }
                catch (Throwable t) {
                    cost = (double)(System.nanoTime() - beginTime) / 1000000.0;
                    replayResult.setCost(cost).setThrow(true).setThrowExp(new ObjectVO(t, this.expand));
                }
                TimeTunnelModel timeTunnelModel = new TimeTunnelModel().setReplayResult(replayResult).setReplayNo(i + 1).setExpand(this.expand).setSizeLimit(this.sizeLimit);
                process.appendResult(timeTunnelModel);
            }
            process.end();
        }
        catch (Throwable t) {
            logger.warn("tt replay failed.", t);
            process.end(-1, "tt replay failed");
        }
        finally {
            method.setAccessible(accessible);
        }
    }
}

