/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.command.model.MemoryEntryVO;
import com.taobao.arthas.core.command.model.MemoryModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Name(value="memory")
@Summary(value="Display jvm memory info.")
@Description(value="\nEXAMPLES:\n  memory\n\nWIKI:\n  https://arthas.aliyun.com/3.x/doc/memory")
public class MemoryCommand
extends AnnotatedCommand {
    @Override
    public void process(CommandProcess process) {
        MemoryModel result = new MemoryModel();
        result.setMemoryInfo(MemoryCommand.memoryInfo());
        process.appendResult(result);
        process.end();
    }

    static Map<String, List<MemoryEntryVO>> memoryInfo() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        LinkedHashMap<String, List<MemoryEntryVO>> memoryInfoMap = new LinkedHashMap<String, List<MemoryEntryVO>>();
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        ArrayList<MemoryEntryVO> heapMemEntries = new ArrayList<MemoryEntryVO>();
        heapMemEntries.add(MemoryCommand.createMemoryEntryVO("heap", "heap", heapMemoryUsage));
        for (MemoryPoolMXBean poolMXBean : memoryPoolMXBeans) {
            MemoryUsage usage;
            if (!MemoryType.HEAP.equals((Object)poolMXBean.getType()) || (usage = MemoryCommand.getUsage(poolMXBean)) == null) continue;
            String poolName = StringUtils.beautifyName(poolMXBean.getName());
            heapMemEntries.add(MemoryCommand.createMemoryEntryVO("heap", poolName, usage));
        }
        memoryInfoMap.put("heap", heapMemEntries);
        MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        ArrayList<MemoryEntryVO> nonheapMemEntries = new ArrayList<MemoryEntryVO>();
        nonheapMemEntries.add(MemoryCommand.createMemoryEntryVO("nonheap", "nonheap", nonHeapMemoryUsage));
        for (MemoryPoolMXBean poolMXBean : memoryPoolMXBeans) {
            MemoryUsage usage;
            if (!MemoryType.NON_HEAP.equals((Object)poolMXBean.getType()) || (usage = MemoryCommand.getUsage(poolMXBean)) == null) continue;
            String poolName = StringUtils.beautifyName(poolMXBean.getName());
            nonheapMemEntries.add(MemoryCommand.createMemoryEntryVO("nonheap", poolName, usage));
        }
        memoryInfoMap.put("nonheap", nonheapMemEntries);
        MemoryCommand.addBufferPoolMemoryInfo(memoryInfoMap);
        return memoryInfoMap;
    }

    private static MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMXBean) {
        try {
            return memoryPoolMXBean.getUsage();
        }
        catch (InternalError e) {
            return null;
        }
    }

    private static void addBufferPoolMemoryInfo(Map<String, List<MemoryEntryVO>> memoryInfoMap) {
        try {
            ArrayList<MemoryEntryVO> bufferPoolMemEntries = new ArrayList<MemoryEntryVO>();
            Class<?> bufferPoolMXBeanClass = Class.forName("java.lang.management.BufferPoolMXBean");
            List<BufferPoolMXBean> bufferPoolMXBeans = ManagementFactory.getPlatformMXBeans(bufferPoolMXBeanClass);
            for (BufferPoolMXBean mbean : bufferPoolMXBeans) {
                long used = mbean.getMemoryUsed();
                long total = mbean.getTotalCapacity();
                bufferPoolMemEntries.add(new MemoryEntryVO("buffer_pool", mbean.getName(), used, total, Long.MIN_VALUE));
            }
            memoryInfoMap.put("buffer_pool", bufferPoolMemEntries);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static MemoryEntryVO createMemoryEntryVO(String type, String name, MemoryUsage memoryUsage) {
        return new MemoryEntryVO(type, name, memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax());
    }
}

