/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.command.model.JvmModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@Name(value="jvm")
@Summary(value="Display the target JVM information")
@Description(value="\nWIKI:\n  https://arthas.aliyun.com/3.x/doc/jvm")
public class JvmCommand
extends AnnotatedCommand {
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private final Collection<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final Collection<MemoryManagerMXBean> memoryManagerMXBeans = ManagementFactory.getMemoryManagerMXBeans();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    @Override
    public void process(CommandProcess process) {
        JvmModel jvmModel = new JvmModel();
        this.addRuntimeInfo(jvmModel);
        this.addClassLoading(jvmModel);
        this.addCompilation(jvmModel);
        if (!this.garbageCollectorMXBeans.isEmpty()) {
            this.addGarbageCollectors(jvmModel);
        }
        if (!this.memoryManagerMXBeans.isEmpty()) {
            this.addMemoryManagers(jvmModel);
        }
        this.addMemory(jvmModel);
        this.addOperatingSystem(jvmModel);
        this.addThread(jvmModel);
        this.addFileDescriptor(jvmModel);
        process.appendResult(jvmModel);
        process.end();
    }

    private void addFileDescriptor(JvmModel jvmModel) {
        String group = "FILE-DESCRIPTOR";
        jvmModel.addItem(group, "MAX-FILE-DESCRIPTOR-COUNT", this.invokeFileDescriptor(this.operatingSystemMXBean, "getMaxFileDescriptorCount")).addItem(group, "OPEN-FILE-DESCRIPTOR-COUNT", this.invokeFileDescriptor(this.operatingSystemMXBean, "getOpenFileDescriptorCount"));
    }

    private long invokeFileDescriptor(OperatingSystemMXBean os, String name) {
        try {
            Method method = os.getClass().getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return (Long)method.invoke((Object)os, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private void addRuntimeInfo(JvmModel jvmModel) {
        String bootClassPath = "";
        try {
            bootClassPath = this.runtimeMXBean.getBootClassPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String group = "RUNTIME";
        jvmModel.addItem(group, "MACHINE-NAME", this.runtimeMXBean.getName());
        jvmModel.addItem(group, "JVM-START-TIME", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.runtimeMXBean.getStartTime())));
        jvmModel.addItem(group, "MANAGEMENT-SPEC-VERSION", this.runtimeMXBean.getManagementSpecVersion());
        jvmModel.addItem(group, "SPEC-NAME", this.runtimeMXBean.getSpecName());
        jvmModel.addItem(group, "SPEC-VENDOR", this.runtimeMXBean.getSpecVendor());
        jvmModel.addItem(group, "SPEC-VERSION", this.runtimeMXBean.getSpecVersion());
        jvmModel.addItem(group, "VM-NAME", this.runtimeMXBean.getVmName());
        jvmModel.addItem(group, "VM-VENDOR", this.runtimeMXBean.getVmVendor());
        jvmModel.addItem(group, "VM-VERSION", this.runtimeMXBean.getVmVersion());
        jvmModel.addItem(group, "INPUT-ARGUMENTS", this.runtimeMXBean.getInputArguments());
        jvmModel.addItem(group, "CLASS-PATH", this.runtimeMXBean.getClassPath());
        jvmModel.addItem(group, "BOOT-CLASS-PATH", bootClassPath);
        jvmModel.addItem(group, "LIBRARY-PATH", this.runtimeMXBean.getLibraryPath());
    }

    private void addClassLoading(JvmModel jvmModel) {
        String group = "CLASS-LOADING";
        jvmModel.addItem(group, "LOADED-CLASS-COUNT", this.classLoadingMXBean.getLoadedClassCount());
        jvmModel.addItem(group, "TOTAL-LOADED-CLASS-COUNT", this.classLoadingMXBean.getTotalLoadedClassCount());
        jvmModel.addItem(group, "UNLOADED-CLASS-COUNT", this.classLoadingMXBean.getUnloadedClassCount());
        jvmModel.addItem(group, "IS-VERBOSE", this.classLoadingMXBean.isVerbose());
    }

    private void addCompilation(JvmModel jvmModel) {
        if (this.compilationMXBean == null) {
            return;
        }
        String group = "COMPILATION";
        jvmModel.addItem(group, "NAME", this.compilationMXBean.getName());
        if (this.compilationMXBean.isCompilationTimeMonitoringSupported()) {
            jvmModel.addItem(group, "TOTAL-COMPILE-TIME", this.compilationMXBean.getTotalCompilationTime(), "time (ms)");
        }
    }

    private void addGarbageCollectors(JvmModel jvmModel) {
        String group = "GARBAGE-COLLECTORS";
        for (GarbageCollectorMXBean gcMXBean : this.garbageCollectorMXBeans) {
            LinkedHashMap<String, Object> gcInfo = new LinkedHashMap<String, Object>();
            gcInfo.put("name", gcMXBean.getName());
            gcInfo.put("collectionCount", gcMXBean.getCollectionCount());
            gcInfo.put("collectionTime", gcMXBean.getCollectionTime());
            jvmModel.addItem(group, gcMXBean.getName(), gcInfo, "count/time (ms)");
        }
    }

    private void addMemoryManagers(JvmModel jvmModel) {
        String group = "MEMORY-MANAGERS";
        for (MemoryManagerMXBean memoryManagerMXBean : this.memoryManagerMXBeans) {
            if (!memoryManagerMXBean.isValid()) continue;
            String name = memoryManagerMXBean.isValid() ? memoryManagerMXBean.getName() : memoryManagerMXBean.getName() + "(Invalid)";
            jvmModel.addItem(group, name, memoryManagerMXBean.getMemoryPoolNames());
        }
    }

    private void addMemory(JvmModel jvmModel) {
        String group = "MEMORY";
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        Map<String, Object> heapMemoryInfo = this.getMemoryUsageInfo("heap", heapMemoryUsage);
        jvmModel.addItem(group, "HEAP-MEMORY-USAGE", heapMemoryInfo, "memory in bytes");
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        Map<String, Object> nonheapMemoryInfo = this.getMemoryUsageInfo("nonheap", nonHeapMemoryUsage);
        jvmModel.addItem(group, "NO-HEAP-MEMORY-USAGE", nonheapMemoryInfo, "memory in bytes");
        jvmModel.addItem(group, "PENDING-FINALIZE-COUNT", this.memoryMXBean.getObjectPendingFinalizationCount());
    }

    private Map<String, Object> getMemoryUsageInfo(String name, MemoryUsage heapMemoryUsage) {
        LinkedHashMap<String, Object> memoryInfo = new LinkedHashMap<String, Object>();
        memoryInfo.put("name", name);
        memoryInfo.put("init", heapMemoryUsage.getInit());
        memoryInfo.put("used", heapMemoryUsage.getUsed());
        memoryInfo.put("committed", heapMemoryUsage.getCommitted());
        memoryInfo.put("max", heapMemoryUsage.getMax());
        return memoryInfo;
    }

    private void addOperatingSystem(JvmModel jvmModel) {
        String group = "OPERATING-SYSTEM";
        jvmModel.addItem(group, "OS", this.operatingSystemMXBean.getName()).addItem(group, "ARCH", this.operatingSystemMXBean.getArch()).addItem(group, "PROCESSORS-COUNT", this.operatingSystemMXBean.getAvailableProcessors()).addItem(group, "LOAD-AVERAGE", this.operatingSystemMXBean.getSystemLoadAverage()).addItem(group, "VERSION", this.operatingSystemMXBean.getVersion());
    }

    private void addThread(JvmModel jvmModel) {
        String group = "THREAD";
        jvmModel.addItem(group, "COUNT", this.threadMXBean.getThreadCount()).addItem(group, "DAEMON-COUNT", this.threadMXBean.getDaemonThreadCount()).addItem(group, "PEAK-COUNT", this.threadMXBean.getPeakThreadCount()).addItem(group, "STARTED-COUNT", this.threadMXBean.getTotalStartedThreadCount()).addItem(group, "DEADLOCK-COUNT", this.getDeadlockedThreadsCount(this.threadMXBean));
    }

    private int getDeadlockedThreadsCount(ThreadMXBean threads) {
        long[] ids = threads.findDeadlockedThreads();
        if (ids == null) {
            return 0;
        }
        return ids.length;
    }
}

