/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.logger;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.common.ReflectUtils;
import com.taobao.arthas.core.command.logger.AsmRenameUtil;
import com.taobao.arthas.core.command.logger.Log4j2Helper;
import com.taobao.arthas.core.command.logger.Log4jHelper;
import com.taobao.arthas.core.command.logger.LogbackHelper;
import com.taobao.arthas.core.command.logger.LoggerHelper;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.LoggerModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Name(value="logger")
@Summary(value="Print logger info, and update the logger level")
@Description(value="\nExamples:\n  logger\n  logger -c 327a647b\n  logger -c 327a647b --name ROOT --level debug\n  logger --include-no-appender\n\nWIKI:\n  https://arthas.aliyun.com/3.x/doc/logger")
public class LoggerCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(LoggerCommand.class);
    private static byte[] LoggerHelperBytes;
    private static byte[] Log4jHelperBytes;
    private static byte[] LogbackHelperBytes;
    private static byte[] Log4j2HelperBytes;
    private static Map<Class<?>, byte[]> classToBytesMap;
    private static String arthasClassLoaderHash;
    private String name;
    private String hashCode;
    private String classLoaderClass;
    private String level;
    private boolean includeNoAppender;

    @Option(shortName="n", longName="name")
    @Description(value="logger name")
    public void setName(String name) {
        this.name = name;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="classLoader hashcode, if no value is set, default value is SystemClassLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Option(shortName="l", longName="level")
    @Description(value="set logger level")
    public void setLevel(String level) {
        this.level = level;
    }

    @Option(longName="include-no-appender", flag=true)
    @Description(value="include the loggers which don't have appenders, default value false")
    public void setHaveAppender(boolean includeNoAppender) {
        this.includeNoAppender = includeNoAppender;
    }

    @Override
    public void process(CommandProcess process) {
        if (this.hashCode == null && this.classLoaderClass != null) {
            Instrumentation inst = process.session().getInstrumentation();
            List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
            if (matchedClassLoaders.size() == 1) {
                this.hashCode = Integer.toHexString(matchedClassLoaders.get(0).hashCode());
            } else {
                if (matchedClassLoaders.size() > 1) {
                    List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                    LoggerModel loggerModel = new LoggerModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                    process.appendResult(loggerModel);
                    process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                    return;
                }
                process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                return;
            }
        }
        if (this.name != null && this.level != null) {
            this.level(process);
        } else {
            this.loggers(process);
        }
    }

    public void level(CommandProcess process) {
        Boolean updateResult;
        Instrumentation inst = process.session().getInstrumentation();
        boolean result = false;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (this.hashCode != null && (classLoader = ClassLoaderUtils.getClassLoader(inst, this.hashCode)) == null) {
            process.end(-1, "Can not find classloader by hashCode: " + this.hashCode + ".");
            return;
        }
        LoggerTypes loggerTypes = this.findLoggerTypes(process.session().getInstrumentation(), classLoader);
        if (loggerTypes.contains(LoggerType.LOG4J)) {
            try {
                updateResult = this.updateLevel(inst, classLoader, Log4jHelper.class);
                if (Boolean.TRUE.equals(updateResult)) {
                    result = true;
                }
            }
            catch (Throwable e) {
                logger.error("logger command update log4j level error", e);
            }
        }
        if (loggerTypes.contains(LoggerType.LOGBACK)) {
            try {
                updateResult = this.updateLevel(inst, classLoader, LogbackHelper.class);
                if (Boolean.TRUE.equals(updateResult)) {
                    result = true;
                }
            }
            catch (Throwable e) {
                logger.error("logger command update logback level error", e);
            }
        }
        if (loggerTypes.contains(LoggerType.LOG4J2)) {
            try {
                updateResult = this.updateLevel(inst, classLoader, Log4j2Helper.class);
                if (Boolean.TRUE.equals(updateResult)) {
                    result = true;
                }
            }
            catch (Throwable e) {
                logger.error("logger command update log4j2 level error", e);
            }
        }
        if (result) {
            process.end(0, "Update logger level success.");
        } else {
            process.end(-1, "Update logger level fail. Try to specify the classloader with the -c option. Use `sc -d CLASSNAME` to find out the classloader hashcode.");
        }
    }

    public void loggers(CommandProcess process) {
        LinkedHashMap<ClassLoader, LoggerTypes> classLoaderLoggerMap = new LinkedHashMap<ClassLoader, LoggerTypes>();
        for (Class clazz : process.session().getInstrumentation().getAllLoadedClasses()) {
            String className = clazz.getName();
            ClassLoader classLoader = clazz.getClassLoader();
            if (this.hashCode != null && !this.hashCode.equals(StringUtils.classLoaderHash(clazz)) || classLoader == null) continue;
            LoggerTypes loggerTypes = (LoggerTypes)classLoaderLoggerMap.get(classLoader);
            if (loggerTypes == null) {
                loggerTypes = new LoggerTypes();
                classLoaderLoggerMap.put(classLoader, loggerTypes);
            }
            this.updateLoggerType(loggerTypes, classLoader, className);
        }
        for (Map.Entry entry : classLoaderLoggerMap.entrySet()) {
            Map<String, Map<String, Object>> loggerInfoMap;
            ClassLoader classLoader = (ClassLoader)entry.getKey();
            LoggerTypes loggerTypes = (LoggerTypes)entry.getValue();
            if (loggerTypes.contains(LoggerType.LOG4J)) {
                loggerInfoMap = this.loggerInfo(classLoader, Log4jHelper.class);
                process.appendResult(new LoggerModel(loggerInfoMap));
            }
            if (loggerTypes.contains(LoggerType.LOGBACK)) {
                loggerInfoMap = this.loggerInfo(classLoader, LogbackHelper.class);
                process.appendResult(new LoggerModel(loggerInfoMap));
            }
            if (!loggerTypes.contains(LoggerType.LOG4J2)) continue;
            loggerInfoMap = this.loggerInfo(classLoader, Log4j2Helper.class);
            process.appendResult(new LoggerModel(loggerInfoMap));
        }
        process.end();
    }

    private LoggerTypes findLoggerTypes(Instrumentation inst, ClassLoader classLoader) {
        LoggerTypes loggerTypes = new LoggerTypes();
        for (Class clazz : inst.getAllLoadedClasses()) {
            if (classLoader != clazz.getClassLoader()) continue;
            this.updateLoggerType(loggerTypes, classLoader, clazz.getName());
        }
        return loggerTypes;
    }

    private void updateLoggerType(LoggerTypes loggerTypes, ClassLoader classLoader, String className) {
        if ("org.apache.log4j.Logger".equals(className)) {
            try {
                if (classLoader.getResource("org/apache/log4j/AsyncAppender.class") != null) {
                    loggerTypes.addType(LoggerType.LOG4J);
                }
            }
            catch (Throwable throwable) {}
        } else if ("ch.qos.logback.classic.Logger".equals(className)) {
            try {
                if (classLoader.getResource("ch/qos/logback/core/Appender.class") != null) {
                    loggerTypes.addType(LoggerType.LOGBACK);
                }
            }
            catch (Throwable throwable) {}
        } else if ("org.apache.logging.log4j.Logger".equals(className)) {
            try {
                if (classLoader.getResource("org/apache/logging/log4j/core/LoggerContext.class") != null) {
                    loggerTypes.addType(LoggerType.LOG4J2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Class<?> helperClassNameWithClassLoader(ClassLoader classLoader, Class<?> helperClass) {
        String classLoaderHash = ClassLoaderUtils.classLoaderHash(classLoader);
        String className = helperClass.getName();
        String helperClassName = className + arthasClassLoaderHash + classLoaderHash;
        try {
            return classLoader.loadClass(helperClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                byte[] helperClassBytes = AsmRenameUtil.renameClass(classToBytesMap.get(helperClass), helperClass.getName(), helperClassName);
                return ReflectUtils.defineClass((String)helperClassName, (byte[])helperClassBytes, (ClassLoader)classLoader);
            }
            catch (Throwable e1) {
                logger.error("arthas loggger command try to define helper class error: " + helperClassName, e1);
                return null;
            }
        }
    }

    private Map<String, Map<String, Object>> loggerInfo(ClassLoader classLoader, Class<?> helperClass) {
        Map loggers = Collections.emptyMap();
        try {
            Class<?> clazz = LoggerCommand.helperClassNameWithClassLoader(classLoader, helperClass);
            Method getLoggersMethod = clazz.getMethod("getLoggers", String.class, Boolean.TYPE);
            loggers = (Map)getLoggersMethod.invoke(null, this.name, this.includeNoAppender);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Map loggerInfo : loggers.values()) {
            Class clazz = (Class)loggerInfo.get("class");
            loggerInfo.put("classLoader", this.getClassLoaderName(clazz.getClassLoader()));
            loggerInfo.put("classLoaderHash", StringUtils.classLoaderHash(clazz));
            List appenders = (List)loggerInfo.get("appenders");
            for (Map appenderInfo : appenders) {
                Class appenderClass = (Class)appenderInfo.get("class");
                if (appenderClass == null) continue;
                appenderInfo.put("classLoader", this.getClassLoaderName(appenderClass.getClassLoader()));
                appenderInfo.put("classLoaderHash", StringUtils.classLoaderHash(appenderClass));
            }
        }
        return loggers;
    }

    private String getClassLoaderName(ClassLoader classLoader) {
        return classLoader == null ? null : classLoader.toString();
    }

    private Boolean updateLevel(Instrumentation inst, ClassLoader classLoader, Class<?> helperClass) throws Exception {
        Class<?> clazz = LoggerCommand.helperClassNameWithClassLoader(classLoader, helperClass);
        Method updateLevelMethod = clazz.getMethod("updateLevel", String.class, String.class);
        return (Boolean)updateLevelMethod.invoke(null, this.name, this.level);
    }

    private static byte[] loadClassBytes(Class<?> clazz) {
        try {
            InputStream stream = LoggerCommand.class.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
            return IOUtils.getBytes((InputStream)stream);
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        classToBytesMap = new HashMap();
        arthasClassLoaderHash = ClassLoaderUtils.classLoaderHash(LoggerCommand.class.getClassLoader());
        LoggerHelperBytes = LoggerCommand.loadClassBytes(LoggerHelper.class);
        Log4jHelperBytes = LoggerCommand.loadClassBytes(Log4jHelper.class);
        LogbackHelperBytes = LoggerCommand.loadClassBytes(LogbackHelper.class);
        Log4j2HelperBytes = LoggerCommand.loadClassBytes(Log4j2Helper.class);
        classToBytesMap.put(LoggerHelper.class, LoggerHelperBytes);
        classToBytesMap.put(Log4jHelper.class, Log4jHelperBytes);
        classToBytesMap.put(LogbackHelper.class, LogbackHelperBytes);
        classToBytesMap.put(Log4j2Helper.class, Log4j2HelperBytes);
    }

    static class LoggerTypes {
        Set<LoggerType> types = new HashSet<LoggerType>();

        LoggerTypes() {
        }

        public Collection<LoggerType> types() {
            return this.types;
        }

        public void addType(LoggerType type) {
            this.types.add(type);
        }

        public boolean contains(LoggerType type) {
            return this.types.contains((Object)type);
        }
    }

    static enum LoggerType {
        LOG4J,
        LOGBACK,
        LOG4J2;

    }
}

