/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.taobao.arthas.core.advisor.TransformerManager;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.RetransformModel;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@Name(value="retransform")
@Summary(value="Retransform classes. @see Instrumentation#retransformClasses(Class...)")
@Description(value="\nEXAMPLES:\n  retransform /tmp/Test.class\n  retransform -l \n  retransform -d 1                    # delete retransform entry\n  retransform --deleteAll             # delete all retransform entries\n  retransform --classPattern demo.*   # triger retransform classes\n  retransform -c 327a647b /tmp/Test.class /tmp/Test\\$Inner.class \n  retransform --classLoaderClass 'sun.misc.Launcher$AppClassLoader' /tmp/Test.class\n\nWIKI:\n  https://arthas.aliyun.com/3.x/doc/retransform")
public class RetransformCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(RetransformCommand.class);
    private static final int MAX_FILE_SIZE = 0xA00000;
    private static volatile List<RetransformEntry> retransformEntries = new ArrayList<RetransformEntry>();
    private static volatile ClassFileTransformer transformer = null;
    private String hashCode;
    private String classLoaderClass;
    private List<String> paths;
    private boolean list;
    private int delete = -1;
    private boolean deleteAll;
    private String classPattern;
    private int limit;

    @Option(shortName="l", longName="list", flag=true)
    @Description(value="list all retransform entry.")
    public void setList(boolean list) {
        this.list = list;
    }

    @Option(shortName="d", longName="delete")
    @Description(value="delete retransform entry by id.")
    public void setDelete(int delete) {
        this.delete = delete;
    }

    @Option(longName="deleteAll", flag=true)
    @Description(value="delete all retransform entries.")
    public void setDeleteAll(boolean deleteAll) {
        this.deleteAll = deleteAll;
    }

    @Option(longName="classPattern")
    @Description(value="trigger retransform matched classes by class pattern.")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="classLoader hashcode")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Argument(argName="classfilePaths", index=0, required=false)
    @Description(value=".class file paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    @Option(longName="limit")
    @Description(value="The limit of dump classes size, default value is 50")
    @DefaultValue(value="50")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTransformer() {
        if (transformer != null) {
            return;
        }
        Class<RetransformCommand> clazz = RetransformCommand.class;
        synchronized (RetransformCommand.class) {
            if (transformer == null) {
                transformer = new RetransformClassFileTransformer();
                TransformerManager transformerManager = ArthasBootstrap.getInstance().getTransformerManager();
                transformerManager.addRetransformer(transformer);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        RetransformCommand.initTransformer();
        RetransformModel retransformModel = new RetransformModel();
        Instrumentation inst = process.session().getInstrumentation();
        if (this.list) {
            List<RetransformEntry> retransformEntryList = RetransformCommand.allRetransformEntries();
            retransformModel.setRetransformEntries(retransformEntryList);
            process.appendResult(retransformModel);
            process.end();
            return;
        }
        if (this.deleteAll) {
            RetransformCommand.deleteAllRetransformEntry();
            process.appendResult(retransformModel);
            process.end();
            return;
        }
        if (this.delete > 0) {
            RetransformCommand.deleteRetransformEntry(this.delete);
            process.end();
            return;
        }
        if (this.classPattern != null) {
            Set<Class<?>> searchClass = SearchUtils.searchClass(inst, this.classPattern, false, this.hashCode);
            if (searchClass.isEmpty()) {
                process.end(-1, "These classes are not found in the JVM and may not be loaded: " + this.classPattern);
                return;
            }
            if (searchClass.size() > this.limit) {
                process.end(-1, "match classes size: " + searchClass.size() + ", more than limit: " + this.limit + ", It is recommended to use a more precise class pattern.");
            }
            try {
                inst.retransformClasses(searchClass.toArray(new Class[0]));
                for (Class<?> clazz : searchClass) {
                    retransformModel.addRetransformClass(clazz.getName());
                }
                process.appendResult(retransformModel);
                process.end();
                return;
            }
            catch (Throwable throwable) {
                String message = "retransform error! " + throwable.toString();
                logger.error(message, throwable);
                process.end(-1, message);
                return;
            }
        }
        for (String string : this.paths) {
            File file = new File(string);
            if (!file.exists()) {
                process.end(-1, "file does not exist, path:" + string);
                return;
            }
            if (!file.isFile()) {
                process.end(-1, "not a normal file, path:" + string);
                return;
            }
            if (file.length() < 0xA00000L) continue;
            process.end(-1, "file size: " + file.length() + " >= " + 0xA00000 + ", path: " + string);
            return;
        }
        HashMap<String, byte[]> bytesMap = new HashMap<String, byte[]>();
        for (String path : this.paths) {
            Class[] f = null;
            try {
                f = new RandomAccessFile(path, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                String clazzName = RetransformCommand.readClassName(bytes);
                bytesMap.put(clazzName, bytes);
            }
            catch (Exception e) {
                logger.warn("load class file failed: " + path, (Throwable)e);
                process.end(-1, "load class file failed: " + path + ", error: " + e);
                return;
            }
            finally {
                if (f == null) continue;
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bytesMap.size() != this.paths.size()) {
            process.end(-1, "paths may contains same class name!");
            return;
        }
        ArrayList<RetransformEntry> arrayList = new ArrayList<RetransformEntry>();
        ArrayList<Class> classList = new ArrayList<Class>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader;
            if (!bytesMap.containsKey(clazz.getName())) continue;
            if (this.hashCode == null && this.classLoaderClass != null) {
                List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
                if (matchedClassLoaders.size() == 1) {
                    this.hashCode = Integer.toHexString(matchedClassLoaders.get(0).hashCode());
                } else {
                    if (matchedClassLoaders.size() > 1) {
                        List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                        retransformModel.setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                        process.appendResult(retransformModel);
                        process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                        return;
                    }
                    process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                    return;
                }
            }
            if ((classLoader = clazz.getClassLoader()) != null && this.hashCode != null && !Integer.toHexString(classLoader.hashCode()).equals(this.hashCode)) continue;
            RetransformEntry retransformEntry = new RetransformEntry(clazz.getName(), (byte[])bytesMap.get(clazz.getName()), this.hashCode, this.classLoaderClass);
            arrayList.add(retransformEntry);
            classList.add(clazz);
            retransformModel.addRetransformClass(clazz.getName());
            logger.info("Try retransform class name: {}, ClassLoader: {}", (Object)clazz.getName(), (Object)clazz.getClassLoader());
        }
        try {
            if (arrayList.isEmpty()) {
                process.end(-1, "These classes are not found in the JVM and may not be loaded: " + bytesMap.keySet());
                return;
            }
            RetransformCommand.addRetransformEntry(arrayList);
            inst.retransformClasses(classList.toArray(new Class[0]));
            process.appendResult(retransformModel);
            process.end();
        }
        catch (Throwable e) {
            String message = "retransform error! " + e.toString();
            logger.error(message, e);
            process.end(-1, message);
        }
    }

    private static String readClassName(byte[] bytes) {
        return new ClassReader(bytes).getClassName().replace('/', '.');
    }

    @Override
    public void complete(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        if (CompletionUtils.shouldCompleteOption(completion, "--classPattern")) {
            CompletionUtils.completeClassName(completion);
            return;
        }
        for (CliToken token : tokens) {
            String tokenStr = token.value();
            if (tokenStr == null || !tokenStr.startsWith("-")) continue;
            super.complete(completion);
            return;
        }
        if (!CompletionUtils.completeFilePath(completion)) {
            super.complete(completion);
        }
    }

    public static synchronized void addRetransformEntry(List<RetransformEntry> retransformEntryList) {
        ArrayList<RetransformEntry> tmp = new ArrayList<RetransformEntry>();
        tmp.addAll(retransformEntries);
        tmp.addAll(retransformEntryList);
        Collections.sort(tmp, new Comparator<RetransformEntry>(){

            @Override
            public int compare(RetransformEntry entry1, RetransformEntry entry2) {
                return entry1.getId() - entry2.getId();
            }
        });
        retransformEntries = tmp;
    }

    public static synchronized RetransformEntry deleteRetransformEntry(int id) {
        RetransformEntry result = null;
        ArrayList<RetransformEntry> tmp = new ArrayList<RetransformEntry>();
        for (RetransformEntry entry : retransformEntries) {
            if (entry.getId() != id) {
                tmp.add(entry);
                continue;
            }
            result = entry;
        }
        retransformEntries = tmp;
        return result;
    }

    public static List<RetransformEntry> allRetransformEntries() {
        return retransformEntries;
    }

    public static synchronized void deleteAllRetransformEntry() {
        retransformEntries = new ArrayList<RetransformEntry>();
    }

    static class RetransformClassFileTransformer
    implements ClassFileTransformer {
        RetransformClassFileTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (className == null) {
                return null;
            }
            className = className.replace('/', '.');
            List<RetransformEntry> allRetransformEntries = RetransformCommand.allRetransformEntries();
            ListIterator<RetransformEntry> listIterator = allRetransformEntries.listIterator(allRetransformEntries.size());
            while (listIterator.hasPrevious()) {
                RetransformEntry retransformEntry = listIterator.previous();
                int id = retransformEntry.getId();
                boolean updateFlag = false;
                if (className.equals(retransformEntry.getClassName())) {
                    updateFlag = retransformEntry.getClassLoaderClass() != null || retransformEntry.getHashCode() != null ? this.isLoaderMatch(retransformEntry, loader) : true;
                }
                if (!updateFlag) continue;
                logger.info("RetransformCommand match class: {}, id: {}, classLoaderClass: {}, hashCode: {}", new Object[]{className, id, retransformEntry.getClassLoaderClass(), retransformEntry.getHashCode()});
                retransformEntry.incTransformCount();
                return retransformEntry.getBytes();
            }
            return null;
        }

        private boolean isLoaderMatch(RetransformEntry retransformEntry, ClassLoader loader) {
            String hashCode;
            if (loader == null) {
                return false;
            }
            if (retransformEntry.getClassLoaderClass() != null && loader.getClass().getName().equals(retransformEntry.getClassLoaderClass())) {
                return true;
            }
            return retransformEntry.getHashCode() != null && (hashCode = Integer.toHexString(loader.hashCode())).equals(retransformEntry.getHashCode());
        }
    }

    public static class RetransformEntry {
        private static final AtomicInteger counter = new AtomicInteger(0);
        private int id = counter.incrementAndGet();
        private String className;
        private byte[] bytes;
        private String hashCode;
        private String classLoaderClass;
        private int transformCount = 0;

        public RetransformEntry(String className, byte[] bytes, String hashCode, String classLoaderClass) {
            this.className = className;
            this.bytes = bytes;
            this.hashCode = hashCode;
            this.classLoaderClass = classLoaderClass;
        }

        public void incTransformCount() {
            ++this.transformCount;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getTransformCount() {
            return this.transformCount;
        }

        public void setTransformCount(int transformCount) {
            this.transformCount = transformCount;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public String getHashCode() {
            return this.hashCode;
        }

        public void setHashCode(String hashCode) {
            this.hashCode = hashCode;
        }

        public String getClassLoaderClass() {
            return this.classLoaderClass;
        }

        public void setClassLoaderClass(String classLoaderClass) {
            this.classLoaderClass = classLoaderClass;
        }
    }
}

