/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.MonitorModel;
import com.taobao.arthas.core.command.monitor200.MonitorData;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class MonitorView
extends ResultView<MonitorModel> {
    @Override
    public void draw(CommandProcess process, MonitorModel result) {
        TableElement table = new TableElement(new int[]{2, 3, 3, 1, 1, 1, 1, 1}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"timestamp").style(Decoration.bold.bold()), Element.label((String)"class").style(Decoration.bold.bold()), Element.label((String)"method").style(Decoration.bold.bold()), Element.label((String)"total").style(Decoration.bold.bold()), Element.label((String)"success").style(Decoration.bold.bold()), Element.label((String)"fail").style(Decoration.bold.bold()), Element.label((String)"avg-rt(ms)").style(Decoration.bold.bold()), Element.label((String)"fail-rate").style(Decoration.bold.bold())});
        DecimalFormat df = new DecimalFormat("0.00");
        for (MonitorData data : result.getMonitorDataList()) {
            table.row(new String[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(data.getTimestamp()), data.getClassName(), data.getMethodName(), "" + data.getTotal(), "" + data.getSuccess(), "" + data.getFailed(), df.format(this.div(data.getCost(), data.getTotal())), df.format(100.0 * this.div(data.getFailed(), data.getTotal())) + "%"});
        }
        process.write(RenderUtil.render((Element)table, (int)process.width()) + "\n");
    }

    private double div(double a, double b) {
        if (b == 0.0) {
            return 0.0;
        }
        return a / b;
    }
}

