/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.MBeanAttributeVO;
import com.taobao.arthas.core.command.model.MBeanModel;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TokenUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

@Name(value="mbean")
@Summary(value="Display the mbean information")
@Description(value="\nExamples:\n  mbean\n  mbean -m java.lang:type=Threading\n  mbean java.lang:type=Threading\n  mbean java.lang:type=Threading *Count\n  mbean java.lang:type=MemoryPool,name=PS\\ Old\\ Gen\n  mbean java.lang:type=MemoryPool,name=*\n  mbean java.lang:type=MemoryPool,name=* Usage\n  mbean -E java.lang:type=Threading PeakThreadCount|ThreadCount|DaemonThreadCount\n  mbean -i 1000 java.lang:type=Threading *Count\n\nWIKI:\n  https://arthas.aliyun.com/doc/mbean")
public class MBeanCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(MBeanCommand.class);
    private String name;
    private String attribute;
    private boolean isRegEx = false;
    private long interval = 0L;
    private boolean metaData;
    private int numOfExecutions = 100;
    private Timer timer;
    private long count = 0L;

    @Argument(argName="name-pattern", index=0, required=false)
    @Description(value="ObjectName pattern, see javax.management.ObjectName for more detail. \nIt looks like this: \n  domain: key-property-list\nFor example: \n  java.lang:name=G1 Old Gen,type=MemoryPool\n  java.lang:name=*,type=MemoryPool")
    public void setNamePattern(String name) {
        this.name = name;
    }

    @Argument(argName="attribute-pattern", index=1, required=false)
    @Description(value="Attribute name pattern.")
    public void setAttributePattern(String attribute) {
        this.attribute = attribute;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="The interval (in ms) between two executions.")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match attribute name (wildcard matching by default).")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="m", longName="metadata", flag=true)
    @Description(value="Show metadata of mbean.")
    public void setMetaData(boolean metaData) {
        this.metaData = metaData;
    }

    @Option(shortName="n", longName="number-of-execution")
    @Description(value="The number of times this command will be executed.")
    public void setNumOfExecutions(int numOfExecutions) {
        this.numOfExecutions = numOfExecutions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public boolean isMetaData() {
        return this.metaData;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getNumOfExecutions() {
        return this.numOfExecutions;
    }

    @Override
    public void process(CommandProcess process) {
        if (StringUtils.isEmpty(this.getName())) {
            this.listMBean(process);
        } else if (this.isMetaData()) {
            this.listMetaData(process);
        } else {
            this.listAttribute(process);
        }
    }

    private void listMBean(CommandProcess process) {
        Set<ObjectName> objectNames = this.queryObjectNames();
        ArrayList<String> mbeanNames = new ArrayList<String>(objectNames.size());
        for (ObjectName objectName : objectNames) {
            mbeanNames.add(objectName.toString());
        }
        process.appendResult(new MBeanModel(mbeanNames));
        process.end();
    }

    private void listAttribute(final CommandProcess process) {
        Session session = process.session();
        this.timer = new Timer("Timer-for-arthas-mbean-" + session.getSessionId(), true);
        process.interruptHandler(new MBeanInterruptHandler(process, this.timer));
        Handler<Void> stopHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                MBeanCommand.this.stop();
            }
        };
        Handler<Void> restartHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                MBeanCommand.this.restart(process);
            }
        };
        process.suspendHandler(stopHandler);
        process.resumeHandler(restartHandler);
        process.endHandler(stopHandler);
        process.stdinHandler(new QExitHandler(process));
        if (this.getInterval() > 0L) {
            this.timer.scheduleAtFixedRate((TimerTask)new MBeanTimerTask(process), 0L, this.getInterval());
        } else {
            this.timer.schedule((TimerTask)new MBeanTimerTask(process), 0L);
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public synchronized void restart(CommandProcess process) {
        if (this.timer == null) {
            Session session = process.session();
            this.timer = new Timer("Timer-for-arthas-mbean-" + session.getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new MBeanTimerTask(process), 0L, this.getInterval());
        }
    }

    private void listMetaData(CommandProcess process) {
        Set<ObjectName> objectNames = this.queryObjectNames();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            MBeanModel mbeanModel = new MBeanModel();
            LinkedHashMap<String, MBeanInfo> mbeanMetaData = new LinkedHashMap<String, MBeanInfo>();
            mbeanModel.setMbeanMetadata(mbeanMetaData);
            for (ObjectName objectName : objectNames) {
                MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
                mbeanMetaData.put(objectName.toString(), mBeanInfo);
            }
            process.appendResult(mbeanModel);
            process.end();
        }
        catch (Throwable e) {
            logger.warn("listMetaData error", e);
            process.end(1, "list mbean metadata error");
        }
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!this.completeBeanName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!this.completeAttributeName(completion)) {
                super.complete(completion);
            }
            return;
        }
        super.complete(completion);
    }

    private boolean completeBeanName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = TokenUtils.getLast(tokens).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        if (lastToken.startsWith("-") || lastToken.startsWith("--")) {
            return false;
        }
        Set<ObjectName> objectNames = this.queryObjectNames();
        HashSet<String> names = new HashSet<String>();
        if (objectNames == null) {
            return false;
        }
        for (ObjectName objectName : objectNames) {
            String name = objectName.toString();
            if (!name.startsWith(lastToken)) continue;
            int index = name.indexOf(46, lastToken.length());
            if (index > 0) {
                names.add(name.substring(0, index + 1));
                continue;
            }
            index = name.indexOf(58, lastToken.length());
            if (index > 0) {
                names.add(name.substring(0, index + 1));
                continue;
            }
            names.add(name);
        }
        String next = (String)names.iterator().next();
        if (names.size() == 1 && (next.endsWith(".") || next.endsWith(":"))) {
            completion.complete(next.substring(lastToken.length()), false);
            return true;
        }
        return CompletionUtils.complete(completion, names);
    }

    private boolean completeAttributeName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = TokenUtils.getLast(tokens).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        String beanName = TokenUtils.retrievePreviousArg(tokens, lastToken);
        Set<ObjectName> objectNames = null;
        try {
            objectNames = platformMBeanServer.queryNames(new ObjectName(beanName), null);
        }
        catch (MalformedObjectNameException e) {
            logger.warn("queryNames error", (Throwable)e);
        }
        if (objectNames == null || objectNames.size() == 0) {
            return false;
        }
        try {
            MBeanAttributeInfo[] attributes;
            MBeanInfo mBeanInfo = platformMBeanServer.getMBeanInfo(objectNames.iterator().next());
            ArrayList<String> attributeNames = new ArrayList<String>();
            for (MBeanAttributeInfo attribute : attributes = mBeanInfo.getAttributes()) {
                if (StringUtils.isBlank(lastToken)) {
                    attributeNames.add(attribute.getName());
                    continue;
                }
                if (!attribute.getName().startsWith(lastToken)) continue;
                attributeNames.add(attribute.getName());
            }
            return CompletionUtils.complete(completion, attributeNames);
        }
        catch (Throwable e) {
            logger.warn("getMBeanInfo error", e);
            return false;
        }
    }

    private Set<ObjectName> queryObjectNames() {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = new HashSet<ObjectName>();
        try {
            if (StringUtils.isEmpty(this.name)) {
                this.name = "*:*";
            }
            objectNames = platformMBeanServer.queryNames(new ObjectName(this.name), null);
        }
        catch (MalformedObjectNameException e) {
            logger.warn("queryObjectNames error", (Throwable)e);
        }
        return objectNames;
    }

    private Matcher<String> getAttributeMatcher() {
        if (StringUtils.isEmpty(this.attribute)) {
            this.attribute = this.isRegEx ? ".*" : "*";
        }
        return this.isRegEx ? new RegexMatcher(this.attribute) : new WildcardMatcher(this.attribute);
    }

    private MBeanAttributeVO createMBeanAttributeVO(String attributeName, Object originAttrValue) {
        Object attrValue = this.convertAttrValue(attributeName, originAttrValue);
        return new MBeanAttributeVO(attributeName, attrValue);
    }

    private Object convertAttrValue(String attributeName, Object originAttrValue) {
        ArrayList<Map<String, Object>> attrValue = originAttrValue;
        try {
            if (originAttrValue instanceof ObjectName) {
                attrValue = String.valueOf(originAttrValue);
            } else if (attrValue instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)((Object)attrValue);
                attrValue = this.convertCompositeData(attributeName, compositeData);
            } else if (attrValue instanceof CompositeData[]) {
                CompositeData[] compositeDataArray = (CompositeData[])attrValue;
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(compositeDataArray.length);
                for (CompositeData compositeData : compositeDataArray) {
                    dataList.add(this.convertCompositeData(attributeName, compositeData));
                }
                attrValue = dataList;
            } else if (attrValue instanceof TabularData) {
                TabularData tabularData = (TabularData)((Object)attrValue);
                Collection<?> compositeDataList = tabularData.values();
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(compositeDataList.size());
                for (CompositeData compositeData : compositeDataList) {
                    dataList.add(this.convertCompositeData(attributeName, compositeData));
                }
                attrValue = dataList;
            }
        }
        catch (Throwable e) {
            logger.error("convert mbean attribute error, attribute: {}={}", new Object[]{attributeName, originAttrValue, e});
            attrValue = String.valueOf(originAttrValue);
        }
        return attrValue;
    }

    private Map<String, Object> convertCompositeData(String attributeName, CompositeData compositeData) {
        Set<String> keySet = compositeData.getCompositeType().keySet();
        String[] keys = keySet.toArray(new String[0]);
        Object[] values = compositeData.getAll(keys);
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            data.put(keys[i], this.convertAttrValue(attributeName + "." + keys[i], values[i]));
        }
        return data;
    }

    private class MBeanTimerTask
    extends TimerTask {
        private CommandProcess process;

        public MBeanTimerTask(CommandProcess process) {
            this.process = process;
        }

        @Override
        public void run() {
            if (MBeanCommand.this.count >= (long)MBeanCommand.this.getNumOfExecutions()) {
                MBeanCommand.this.timer.cancel();
                MBeanCommand.this.timer.purge();
                this.process.end(-1, "Process ends after " + MBeanCommand.this.getNumOfExecutions() + " time(s).");
                return;
            }
            try {
                MBeanModel mBeanModel = new MBeanModel();
                LinkedHashMap<String, List<MBeanAttributeVO>> mbeanAttributeMap = new LinkedHashMap<String, List<MBeanAttributeVO>>();
                mBeanModel.setMbeanAttribute(mbeanAttributeMap);
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                Set objectNames = MBeanCommand.this.queryObjectNames();
                for (ObjectName objectName : objectNames) {
                    MBeanAttributeInfo[] attributes;
                    ArrayList<MBeanAttributeVO> attributeVOs = null;
                    MBeanInfo mBeanInfo = platformMBeanServer.getMBeanInfo(objectName);
                    for (MBeanAttributeInfo attribute : attributes = mBeanInfo.getAttributes()) {
                        String attributeName = attribute.getName();
                        if (!MBeanCommand.this.getAttributeMatcher().matching(attributeName)) continue;
                        if (attributeVOs == null) {
                            attributeVOs = new ArrayList<MBeanAttributeVO>();
                            mbeanAttributeMap.put(objectName.toString(), attributeVOs);
                        }
                        if (!attribute.isReadable()) {
                            attributeVOs.add(new MBeanAttributeVO(attributeName, null, "Unavailable"));
                            continue;
                        }
                        try {
                            Object attributeObj = platformMBeanServer.getAttribute(objectName, attributeName);
                            attributeVOs.add(MBeanCommand.this.createMBeanAttributeVO(attributeName, attributeObj));
                        }
                        catch (Throwable e) {
                            logger.error("read mbean attribute failed: objectName={}, attributeName={}", new Object[]{objectName, attributeName, e});
                            Throwable cause = e.getCause();
                            String errorStr = cause instanceof UnsupportedOperationException ? "Unsupported" : "Failure";
                            attributeVOs.add(new MBeanAttributeVO(attributeName, null, errorStr));
                        }
                    }
                }
                this.process.appendResult(mBeanModel);
            }
            catch (Throwable e) {
                logger.warn("read mbean error", e);
                MBeanCommand.this.stop();
                this.process.end(1, "read mbean error.");
                return;
            }
            MBeanCommand.this.count++;
            this.process.times().incrementAndGet();
            if (MBeanCommand.this.getInterval() <= 0L) {
                MBeanCommand.this.stop();
                this.process.end();
            }
        }
    }

    public static class MBeanInterruptHandler
    extends CommandInterruptHandler {
        private volatile Timer timer;

        public MBeanInterruptHandler(CommandProcess process, Timer timer) {
            super(process);
            this.timer = timer;
        }

        @Override
        public void handle(Void event) {
            this.timer.cancel();
            super.handle(event);
        }
    }
}

